/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AuditOpenSecureChannelEventType;
import com.prosysopc.ua.types.opcua.client.AuditChannelEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.SecurityTokenRequestType;

public abstract class AuditOpenSecureChannelEventTypeImplBase
extends AuditChannelEventTypeImpl
implements AuditOpenSecureChannelEventType {
    protected AuditOpenSecureChannelEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public byte[] getClientCertificate() {
        Object object = this.getClientCertificateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(byte[] byArray) throws StatusException {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificate failed, the Optional node does not exist");
        }
        uaProperty.setValue(byArray);
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateThumbprintNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificateThumbprint");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientCertificateThumbprint() {
        Object object = this.getClientCertificateThumbprintNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientCertificateThumbprint(String string) throws StatusException {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRequestTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SecurityTokenRequestType getRequestType() {
        Object object = this.getRequestTypeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return SecurityTokenRequestType.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setRequestType(SecurityTokenRequestType securityTokenRequestType) throws StatusException {
        UaProperty uaProperty = this.getRequestTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestType failed, the Optional node does not exist");
        }
        uaProperty.setValue(securityTokenRequestType);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        Object object = this.getSecurityPolicyUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        Object object = this.getSecurityModeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return MessageSecurityMode.valueOf((int)((Integer)object));
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist");
        }
        uaProperty.setValue(messageSecurityMode);
    }

    @Override
    @Mandatory
    public UaProperty getRequestedLifetimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedLifetime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRequestedLifetime() {
        Object object = this.getRequestedLifetimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRequestedLifetime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getRequestedLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedLifetime failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }
}

