/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AuditHistoryValueUpdateEventType;
import com.prosysopc.ua.types.opcua.client.AuditHistoryUpdateEventTypeImpl;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.PerformUpdateType;

public abstract class AuditHistoryValueUpdateEventTypeImplBase
extends AuditHistoryUpdateEventTypeImpl
implements AuditHistoryValueUpdateEventType {
    protected AuditHistoryValueUpdateEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getUpdatedNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdatedNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getUpdatedNode() {
        Object object = this.getUpdatedNodeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setUpdatedNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdatedNode failed, the Optional node does not exist");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getPerformInsertReplaceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PerformInsertReplace");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PerformUpdateType getPerformInsertReplace() {
        Object object = this.getPerformInsertReplaceNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return PerformUpdateType.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setPerformInsertReplace(PerformUpdateType performUpdateType) throws StatusException {
        UaProperty uaProperty = this.getPerformInsertReplaceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PerformInsertReplace failed, the Optional node does not exist");
        }
        uaProperty.setValue(performUpdateType);
    }

    @Override
    @Mandatory
    public UaProperty getNewValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NewValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataValue[] getNewValues() {
        Object object = this.getNewValuesNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DataValue[])object;
    }

    @Override
    @Mandatory
    public void setNewValues(DataValue[] dataValueArray) throws StatusException {
        UaProperty uaProperty = this.getNewValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NewValues failed, the Optional node does not exist");
        }
        uaProperty.setValue(dataValueArray);
    }

    @Override
    @Mandatory
    public UaProperty getOldValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OldValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataValue[] getOldValues() {
        Object object = this.getOldValuesNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DataValue[])object;
    }

    @Override
    @Mandatory
    public void setOldValues(DataValue[] dataValueArray) throws StatusException {
        UaProperty uaProperty = this.getOldValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OldValues failed, the Optional node does not exist");
        }
        uaProperty.setValue(dataValueArray);
    }
}

