/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AuditEventType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditEventTypeImplBase
extends BaseEventTypeImpl
implements AuditEventType {
    protected AuditEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getActionTimeStampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActionTimeStamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getActionTimeStamp() {
        Object object = this.getActionTimeStampNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setActionTimeStamp(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getActionTimeStampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActionTimeStamp failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStatus() {
        Object object = this.getStatusNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStatus(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Status failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerId() {
        Object object = this.getServerIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerId(String string) throws StatusException {
        UaProperty uaProperty = this.getServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerId failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getClientAuditEntryIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientAuditEntryId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientAuditEntryId() {
        Object object = this.getClientAuditEntryIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientAuditEntryId(String string) throws StatusException {
        UaProperty uaProperty = this.getClientAuditEntryIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientAuditEntryId failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        Object object = this.getClientUserIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) throws StatusException {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }
}

