/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AuditCertificateEventType;
import com.prosysopc.ua.types.opcua.client.AuditSecurityEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditCertificateEventTypeImplBase
extends AuditSecurityEventTypeImpl
implements AuditCertificateEventType {
    protected AuditCertificateEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Certificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public byte[] getCertificate() {
        Object object = this.getCertificateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Mandatory
    public void setCertificate(byte[] byArray) throws StatusException {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Certificate failed, the Optional node does not exist");
        }
        uaProperty.setValue(byArray);
    }
}

