/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.prosysopc.ua.types.opcua.client.DataItemTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.EUInformation;
import org.opcfoundation.ua.core.Range;

public abstract class AnalogItemTypeImplBase
extends DataItemTypeImpl
implements AnalogItemType {
    protected AnalogItemTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        Object object = this.getInstrumentRangeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) throws StatusException {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed, the Optional node does not exist");
        }
        uaProperty.setValue(range);
    }

    @Override
    @Mandatory
    public UaProperty getEuRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEuRange() {
        Object object = this.getEuRangeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEuRange(Range range) throws StatusException {
        UaProperty uaProperty = this.getEuRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EuRange failed, the Optional node does not exist");
        }
        uaProperty.setValue(range);
    }

    @Override
    @Optional
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getEngineeringUnits() {
        Object object = this.getEngineeringUnitsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setEngineeringUnits(EUInformation eUInformation) throws StatusException {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed, the Optional node does not exist");
        }
        uaProperty.setValue(eUInformation);
    }
}

