/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AlarmConditionType;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.AcknowledgeableConditionTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AlarmConditionTypeImplBase
extends AcknowledgeableConditionTypeImpl
implements AlarmConditionType {
    protected AlarmConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getInputNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InputNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getInputNode() {
        Object object = this.getInputNodeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setInputNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getInputNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InputNode failed, the Optional node does not exist");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getSuppressedOrShelvedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SuppressedOrShelved");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isSuppressedOrShelved() {
        Object object = this.getSuppressedOrShelvedNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setSuppressedOrShelved(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getSuppressedOrShelvedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SuppressedOrShelved failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getMaxTimeShelvedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeShelved");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeShelved() {
        Object object = this.getMaxTimeShelvedNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeShelved(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMaxTimeShelvedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeShelved failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        Object object = this.getActiveStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getActiveStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting ActiveState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getSuppressedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SuppressedState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getSuppressedState() {
        Object object = this.getSuppressedStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setSuppressedState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getSuppressedStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting SuppressedState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public ShelvedStateMachineType getShelvingStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShelvingState");
        return (ShelvedStateMachineType)this.getComponent(qualifiedName);
    }
}

