/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.types.opcua.AcknowledgeableConditionType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.ConditionTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class AcknowledgeableConditionTypeImplBase
extends ConditionTypeImpl
implements AcknowledgeableConditionType {
    protected AcknowledgeableConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getAckedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AckedState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getAckedState() {
        Object object = this.getAckedStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node AckedState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setAckedState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getAckedStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting AckedState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getConfirmedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfirmedState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConfirmedState() {
        Object object = this.getConfirmedStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConfirmedState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getConfirmedStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting ConfirmedState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    private NodeId aa() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge"));
    }

    @Override
    public void acknowledge(byte[] objectArray, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, localizedText};
        this.callMethod(this.aa(), objectArray);
    }

    public AsyncResult<Object[]> acknowledgeAsync(byte[] objectArray, LocalizedText localizedText) {
        objectArray = new Object[]{objectArray, localizedText};
        return this.callAsync(this.aa(), objectArray);
    }

    private NodeId ab() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm"));
    }

    @Override
    public void confirm(byte[] objectArray, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, localizedText};
        this.callMethod(this.ab(), objectArray);
    }

    public AsyncResult<Object[]> confirmAsync(byte[] objectArray, LocalizedText localizedText) {
        objectArray = new Object[]{objectArray, localizedText};
        return this.callAsync(this.ab(), objectArray);
    }
}

