/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.FiniteStateMachineType;
import com.prosysopc.ua.types.opcua.FiniteStateVariableType;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.ProgramDiagnosticType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.core.ProgramDiagnosticDataType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2391")
public interface ProgramStateMachineType
extends FiniteStateMachineType {
    public static final String CREATABLE = "Creatable";
    public static final String DELETABLE = "Deletable";
    public static final String AUTO_DELETE = "AutoDelete";
    public static final String RECYCLE_COUNT = "RecycleCount";
    public static final String INSTANCE_COUNT = "InstanceCount";
    public static final String MAX_INSTANCE_COUNT = "MaxInstanceCount";
    public static final String MAX_RECYCLE_COUNT = "MaxRecycleCount";
    public static final String FINAL_RESULT_DATA = "FinalResultData";
    public static final String READY = "Ready";
    public static final String RUNNING = "Running";
    public static final String SUSPENDED = "Suspended";
    public static final String HALTED = "Halted";
    public static final String HALTED_TO_READY = "HaltedToReady";
    public static final String READY_TO_RUNNING = "ReadyToRunning";
    public static final String RUNNING_TO_HALTED = "RunningToHalted";
    public static final String RUNNING_TO_READY = "RunningToReady";
    public static final String RUNNING_TO_SUSPENDED = "RunningToSuspended";
    public static final String SUSPENDED_TO_RUNNING = "SuspendedToRunning";
    public static final String SUSPENDED_TO_HALTED = "SuspendedToHalted";
    public static final String SUSPENDED_TO_READY = "SuspendedToReady";
    public static final String READY_TO_HALTED = "ReadyToHalted";
    public static final String CURRENT_STATE = "CurrentState";
    public static final String LAST_TRANSITION = "LastTransition";
    public static final String PROGRAM_DIAGNOSTICS = "ProgramDiagnostics";
    public static final String START = "Start";
    public static final String SUSPEND = "Suspend";
    public static final String RESUME = "Resume";
    public static final String HALT = "Halt";
    public static final String RESET = "Reset";

    @Mandatory
    public UaProperty getDeletableNode();

    @Mandatory
    public Boolean isDeletable();

    @Mandatory
    public void setDeletable(Boolean var1) throws StatusException;

    @Mandatory
    public UaProperty getRecycleCountNode();

    @Mandatory
    public Integer getRecycleCount();

    @Mandatory
    public void setRecycleCount(Integer var1) throws StatusException;

    @Override
    @Mandatory
    public FiniteStateVariableType getCurrentStateNode();

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText var1) throws StatusException;

    @Override
    @Mandatory
    public LocalizedText getCurrentState();

    @Override
    @Mandatory
    public FiniteTransitionVariableType getLastTransitionNode();

    @Override
    @Mandatory
    public void setLastTransition(LocalizedText var1) throws StatusException;

    @Override
    @Mandatory
    public LocalizedText getLastTransition();

    @Optional
    public ProgramDiagnosticType getProgramDiagnosticsNode();

    @Optional
    public void setProgramDiagnostics(ProgramDiagnosticDataType var1) throws StatusException;

    @Optional
    public ProgramDiagnosticDataType getProgramDiagnostics();

    @Optional
    public BaseObjectType getFinalResultDataNode();

    public void start() throws StatusException, ServiceException;

    public void suspend() throws StatusException, ServiceException;

    public void resume() throws StatusException, ServiceException;

    public void halt() throws StatusException, ServiceException;

    public void reset() throws StatusException, ServiceException;
}

