/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public interface FileType
extends BaseObjectType {
    public static final String SIZE = "Size";
    public static final String WRITABLE = "Writable";
    public static final String USER_WRITABLE = "UserWritable";
    public static final String OPEN_COUNT = "OpenCount";
    public static final String OPEN = "Open";
    public static final String CLOSE = "Close";
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String GET_POSITION = "GetPosition";
    public static final String SET_POSITION = "SetPosition";

    @Mandatory
    public UaProperty getSizeNode();

    @Mandatory
    public UnsignedLong getSize();

    @Mandatory
    public void setSize(UnsignedLong var1) throws StatusException;

    @Mandatory
    public UaProperty getWritableNode();

    @Mandatory
    public Boolean isWritable();

    @Mandatory
    public void setWritable(Boolean var1) throws StatusException;

    @Mandatory
    public UaProperty getUserWritableNode();

    @Mandatory
    public Boolean isUserWritable();

    @Mandatory
    public void setUserWritable(Boolean var1) throws StatusException;

    @Mandatory
    public UaProperty getOpenCountNode();

    @Mandatory
    public UnsignedShort getOpenCount();

    @Mandatory
    public void setOpenCount(UnsignedShort var1) throws StatusException;

    public UnsignedInteger open(UnsignedByte var1) throws StatusException, ServiceException;

    public void close(UnsignedInteger var1) throws StatusException, ServiceException;

    public byte[] read(UnsignedInteger var1, Integer var2) throws StatusException, ServiceException;

    public void write(UnsignedInteger var1, byte[] var2) throws StatusException, ServiceException;

    public UnsignedLong getPosition(UnsignedInteger var1) throws StatusException, ServiceException;

    public void setPosition(UnsignedInteger var1, UnsignedLong var2) throws StatusException, ServiceException;
}

