/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.di.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.di.LockingServicesType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class LockingServicesTypeNodeBase
extends BaseObjectTypeNode
implements LockingServicesType {
    protected LockingServicesTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getLockedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Locked");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isLocked() {
        Object object = this.getLockedNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Locked does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setLocked(Boolean bl) {
        UaProperty uaProperty = this.getLockedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Locked failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Locked failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLockingClientNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "LockingClient");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getLockingClient() {
        Object object = this.getLockingClientNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LockingClient does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setLockingClient(String string) {
        UaProperty uaProperty = this.getLockingClientNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LockingClient failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LockingClient failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLockingUserNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "LockingUser");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isLockingUser() {
        Object object = this.getLockingUserNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LockingUser does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setLockingUser(Boolean bl) {
        UaProperty uaProperty = this.getLockingUserNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LockingUser failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LockingUser failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRemainingLockTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RemainingLockTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRemainingLockTime() {
        Object object = this.getRemainingLockTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node RemainingLockTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRemainingLockTime(Double d2) {
        UaProperty uaProperty = this.getRemainingLockTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RemainingLockTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemainingLockTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext object, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object2 = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "InitLock");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onInitLock((ServiceContext)object, (String)variantArray[0].getValue());
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RenewLock");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onRenewLock((ServiceContext)object);
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ExitLock");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onExitLock((ServiceContext)object);
            return new Variant[]{new Variant(object)};
        }
        object2 = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "BreakLock");
        if ((object2 = this.getComponent((QualifiedName)object2)) != null && object2.getNodeId().equals((Object)nodeId)) {
            object = this.onBreakLock((ServiceContext)object);
            return new Variant[]{new Variant(object)};
        }
        return super.callMethod((ServiceContext)object, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public Integer initLock(String string) throws StatusException {
        return this.onInitLock(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    protected abstract Integer onInitLock(ServiceContext var1, String var2) throws StatusException;

    @Override
    public Integer renewLock() throws StatusException {
        return this.onRenewLock(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract Integer onRenewLock(ServiceContext var1) throws StatusException;

    @Override
    public Integer exitLock() throws StatusException {
        return this.onExitLock(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract Integer onExitLock(ServiceContext var1) throws StatusException;

    @Override
    public Integer breakLock() throws StatusException {
        return this.onBreakLock(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract Integer onBreakLock(ServiceContext var1) throws StatusException;
}

