/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.di.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.di.FunctionalGroupType;
import com.prosysopc.ua.types.di.server.UIElementTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class FunctionalGroupTypeNodeBase
extends FolderTypeNode
implements FunctionalGroupType {
    protected FunctionalGroupTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getUiElementNode());
    }

    @Override
    @Optional
    public UIElementTypeNode getUiElementNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "UIElement");
        return (UIElementTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Object getUiElement() {
        Object object = this.getUiElementNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Optional
    public void setUiElement(Object object) {
        UIElementTypeNode uIElementTypeNode = this.getUiElementNode();
        if (uIElementTypeNode == null) {
            throw new RuntimeException("Setting UiElement failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uIElementTypeNode.setValue(object);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UiElement failed unexpectedly", statusException);
        }
    }
}

