/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.di.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.di.DeviceHealthEnumeration;
import com.prosysopc.ua.types.di.DeviceType;
import com.prosysopc.ua.types.di.server.TopologyElementTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class DeviceTypeNodeBase
extends TopologyElementTypeNode
implements DeviceType {
    protected DeviceTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDeviceTypeImageNode());
        this.callAfterCreateIfExists(this.getDocumentationNode());
        this.callAfterCreateIfExists(this.getProtocolSupportNode());
        this.callAfterCreateIfExists(this.getImageSetNode());
    }

    @Override
    @Mandatory
    public UaProperty getSerialNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "SerialNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSerialNumber() {
        Object object = this.getSerialNumberNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SerialNumber does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSerialNumber(String string) {
        UaProperty uaProperty = this.getSerialNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SerialNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SerialNumber failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRevisionCounterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RevisionCounter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getRevisionCounter() {
        Object object = this.getRevisionCounterNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node RevisionCounter does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setRevisionCounter(Integer n2) {
        UaProperty uaProperty = this.getRevisionCounterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RevisionCounter failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RevisionCounter failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getManufacturerNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Manufacturer");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getManufacturer() {
        Object object = this.getManufacturerNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Manufacturer does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setManufacturer(LocalizedText localizedText) {
        UaProperty uaProperty = this.getManufacturerNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Manufacturer failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Manufacturer failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getModelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Model");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getModel() {
        Object object = this.getModelNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Model does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setModel(LocalizedText localizedText) {
        UaProperty uaProperty = this.getModelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Model failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Model failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDeviceManualNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceManual");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getDeviceManual() {
        Object object = this.getDeviceManualNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node DeviceManual does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setDeviceManual(String string) {
        UaProperty uaProperty = this.getDeviceManualNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceManual failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeviceManual failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDeviceRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getDeviceRevision() {
        Object object = this.getDeviceRevisionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node DeviceRevision does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setDeviceRevision(String string) {
        UaProperty uaProperty = this.getDeviceRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceRevision failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeviceRevision failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "SoftwareRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareRevision() {
        Object object = this.getSoftwareRevisionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SoftwareRevision does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareRevision(String string) {
        UaProperty uaProperty = this.getSoftwareRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareRevision failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SoftwareRevision failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getHardwareRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "HardwareRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getHardwareRevision() {
        Object object = this.getHardwareRevisionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node HardwareRevision does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setHardwareRevision(String string) {
        UaProperty uaProperty = this.getHardwareRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HardwareRevision failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HardwareRevision failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDeviceClassNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceClass");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDeviceClass() {
        Object object = this.getDeviceClassNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDeviceClass(String string) {
        UaProperty uaProperty = this.getDeviceClassNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceClass failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeviceClass failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDeviceHealthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceHealth");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DeviceHealthEnumeration getDeviceHealth() {
        Object object = this.getDeviceHealthNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return DeviceHealthEnumeration.valueOf((Integer)object);
    }

    @Override
    @Optional
    public void setDeviceHealth(DeviceHealthEnumeration deviceHealthEnumeration) {
        UaProperty uaProperty = this.getDeviceHealthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceHealth failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue((Object)deviceHealthEnumeration);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DeviceHealth failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public FolderTypeNode getDeviceTypeImageNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceTypeImage");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getDocumentationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Documentation");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getProtocolSupportNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ProtocolSupport");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getImageSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ImageSet");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }
}

