/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.di.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.di.LockingServicesType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class LockingServicesTypeImplBase
extends BaseObjectTypeImpl
implements LockingServicesType {
    protected LockingServicesTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getLockedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Locked");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isLocked() {
        Object object = this.getLockedNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setLocked(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getLockedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Locked failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getLockingClientNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "LockingClient");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getLockingClient() {
        Object object = this.getLockingClientNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setLockingClient(String string) throws StatusException {
        UaProperty uaProperty = this.getLockingClientNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LockingClient failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getLockingUserNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "LockingUser");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isLockingUser() {
        Object object = this.getLockingUserNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setLockingUser(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getLockingUserNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LockingUser failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getRemainingLockTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RemainingLockTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRemainingLockTime() {
        Object object = this.getRemainingLockTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRemainingLockTime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getRemainingLockTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RemainingLockTime failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    private NodeId b() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/DI/", "InitLock"));
    }

    @Override
    public Integer initLock(String objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.b(), objectArray);
        return (Integer)objectArray[0];
    }

    public AsyncResult<Object[]> initLockAsync(String objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.b(), objectArray);
    }

    private NodeId c() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RenewLock"));
    }

    @Override
    public Integer renewLock() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        objectArray = this.callMethod(this.c(), objectArray);
        return (Integer)objectArray[0];
    }

    public AsyncResult<Object[]> renewLockAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.c(), objectArray);
    }

    private NodeId d() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ExitLock"));
    }

    @Override
    public Integer exitLock() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        objectArray = this.callMethod(this.d(), objectArray);
        return (Integer)objectArray[0];
    }

    public AsyncResult<Object[]> exitLockAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.d(), objectArray);
    }

    private NodeId e() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/DI/", "BreakLock"));
    }

    @Override
    public Integer breakLock() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        objectArray = this.callMethod(this.e(), objectArray);
        return (Integer)objectArray[0];
    }

    public AsyncResult<Object[]> breakLockAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.e(), objectArray);
    }
}

