/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.di.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.di.DeviceHealthEnumeration;
import com.prosysopc.ua.types.di.DeviceType;
import com.prosysopc.ua.types.di.client.TopologyElementTypeImpl;
import com.prosysopc.ua.types.opcua.FolderType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class DeviceTypeImplBase
extends TopologyElementTypeImpl
implements DeviceType {
    protected DeviceTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSerialNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "SerialNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSerialNumber() {
        Object object = this.getSerialNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSerialNumber(String string) throws StatusException {
        UaProperty uaProperty = this.getSerialNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SerialNumber failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRevisionCounterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "RevisionCounter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getRevisionCounter() {
        Object object = this.getRevisionCounterNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setRevisionCounter(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getRevisionCounterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RevisionCounter failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getManufacturerNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Manufacturer");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getManufacturer() {
        Object object = this.getManufacturerNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setManufacturer(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getManufacturerNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Manufacturer failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getModelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Model");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getModel() {
        Object object = this.getModelNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setModel(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getModelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Model failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getDeviceManualNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceManual");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getDeviceManual() {
        Object object = this.getDeviceManualNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setDeviceManual(String string) throws StatusException {
        UaProperty uaProperty = this.getDeviceManualNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceManual failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getDeviceRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getDeviceRevision() {
        Object object = this.getDeviceRevisionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setDeviceRevision(String string) throws StatusException {
        UaProperty uaProperty = this.getDeviceRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceRevision failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "SoftwareRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareRevision() {
        Object object = this.getSoftwareRevisionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareRevision(String string) throws StatusException {
        UaProperty uaProperty = this.getSoftwareRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareRevision failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getHardwareRevisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "HardwareRevision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getHardwareRevision() {
        Object object = this.getHardwareRevisionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setHardwareRevision(String string) throws StatusException {
        UaProperty uaProperty = this.getHardwareRevisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HardwareRevision failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDeviceClassNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceClass");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDeviceClass() {
        Object object = this.getDeviceClassNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDeviceClass(String string) throws StatusException {
        UaProperty uaProperty = this.getDeviceClassNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceClass failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDeviceHealthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceHealth");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DeviceHealthEnumeration getDeviceHealth() {
        Object object = this.getDeviceHealthNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return DeviceHealthEnumeration.valueOf((Integer)object);
    }

    @Override
    @Optional
    public void setDeviceHealth(DeviceHealthEnumeration deviceHealthEnumeration) throws StatusException {
        UaProperty uaProperty = this.getDeviceHealthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DeviceHealth failed, the Optional node does not exist");
        }
        uaProperty.setValue((Object)deviceHealthEnumeration);
    }

    @Override
    @Optional
    public FolderType getDeviceTypeImageNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "DeviceTypeImage");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderType getDocumentationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "Documentation");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderType getProtocolSupportNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ProtocolSupport");
        return (FolderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderType getImageSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/DI/", "ImageSet");
        return (FolderType)this.getComponent(qualifiedName);
    }
}

