/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.adi.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.adi.ChemometricModelType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ChemometricModelTypeNodeBase
extends BaseDataVariableTypeNode
implements ChemometricModelType {
    protected ChemometricModelTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getName() {
        Object object = this.getNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Name does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setName(LocalizedText localizedText) {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Name failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCreationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "CreationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCreationDate() {
        Object object = this.getCreationDateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CreationDate does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCreationDate(DateTime dateTime) {
        UaProperty uaProperty = this.getCreationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CreationDate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CreationDate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getModelDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "ModelDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getModelDescription() {
        Object object = this.getModelDescriptionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ModelDescription does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setModelDescription(LocalizedText localizedText) {
        UaProperty uaProperty = this.getModelDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ModelDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ModelDescription failed unexpectedly", statusException);
        }
    }
}

