/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.adi.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.adi.ChemometricModelType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ChemometricModelTypeImplBase
extends BaseDataVariableTypeImpl
implements ChemometricModelType {
    protected ChemometricModelTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getName() {
        Object object = this.getNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setName(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCreationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "CreationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCreationDate() {
        Object object = this.getCreationDateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCreationDate(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getCreationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CreationDate failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getModelDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/ADI/", "ModelDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getModelDescription() {
        Object object = this.getModelDescriptionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setModelDescription(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getModelDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ModelDescription failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }
}

