/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariableType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.VariableTypeAttributes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaVariableTypeNode
extends UaTypeNode
implements UaVariableType {
    private static final Logger logger = LoggerFactory.getLogger(UaVariableTypeNode.class);
    private UaType dD;
    private UnsignedInteger[] dC = null;
    private NodeId eI = Identifiers.BaseDataType;
    private Variant value = Variant.NULL;
    private Integer fj = -2;

    static UnsignedInteger[] a(Integer unsignedIntegerArray) {
        if (unsignedIntegerArray.intValue() > 0) {
            unsignedIntegerArray = new UnsignedInteger[unsignedIntegerArray.intValue()];
            for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
                unsignedIntegerArray[i2] = UnsignedInteger.ZERO;
            }
            return unsignedIntegerArray;
        }
        return null;
    }

    public UaVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        if (this.dC != null) {
            return this.dC;
        }
        return UaVariableTypeNode.a(this.getValueRank());
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new VariableTypeAttributes());
    }

    @Override
    public UaType getDataType() {
        return this.dD;
    }

    @Override
    public NodeId getDataTypeId() {
        return this.eI;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.VariableType;
    }

    @Override
    public DataValue getValue() {
        if (this.value == null) {
            return new DataValue(new StatusCode(StatusCodes.Bad_AttributeIdInvalid));
        }
        return new DataValue(this.value, StatusCode.GOOD, INITIALIZATION_TIME, DateTime.currentTime());
    }

    @Override
    public Integer getValueRank() {
        return this.fj;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.dC = unsignedIntegerArray;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes = (VariableTypeAttributes)nodeAttributes;
        this.setArrayDimensions(nodeAttributes.getArrayDimensions());
        this.setDataTypeId(nodeAttributes.getDataType());
        this.setValue(new DataValue(nodeAttributes.getValue()));
        this.setValueRank(nodeAttributes.getValueRank());
        this.setIsAbstract(nodeAttributes.getIsAbstract());
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setDataType(UaType uaType) {
        this.setDataTypeId(uaType.getNodeId());
        this.dD = uaType;
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
        this.eI = nodeId;
    }

    @Override
    public void setValue(DataValue dataValue) {
        this.value = dataValue == null || dataValue.getValue() == null ? Variant.NULL : dataValue.getValue();
    }

    @Override
    public void setValue(Object object) throws StatusException {
        if (object instanceof DataValue) {
            object = (DataValue)object;
        } else {
            object = object instanceof Variant ? (Variant)object : new Variant(object);
            object = new DataValue((Variant)object);
        }
        this.setValue((DataValue)object);
    }

    @Override
    public void setValueRank(int n2) {
        this.fj = n2;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", DataType=%s, ValueRank=%s, ArrayDimensions=%s, Value=%s", this.eI, this.fj, this.dC, this.value);
    }

    protected VariableTypeAttributes getAttributes(VariableTypeAttributes variableTypeAttributes) {
        super.getAttributes((NodeAttributes)variableTypeAttributes);
        variableTypeAttributes.setArrayDimensions(this.getArrayDimensions());
        variableTypeAttributes.setDataType(this.getDataTypeId());
        variableTypeAttributes.setIsAbstract(this.getIsAbstract());
        variableTypeAttributes.setValue(this.getValue().getValue());
        variableTypeAttributes.setValueRank(this.getValueRank());
        return variableTypeAttributes;
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Value);
        list.add(Attributes.DataType);
        list.add(Attributes.ValueRank);
        list.add(Attributes.ArrayDimensions);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.DataType)) {
            dataValue.setValue(new Variant((Object)this.eI));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.ValueRank)) {
            dataValue.setValue(new Variant((Object)this.fj));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.Value)) {
            dataValue.setValue(this.value);
            dataValue.setSourceTimestamp(INITIALIZATION_TIME);
            dataValue.setSourcePicoseconds(UnsignedShort.ZERO);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.ArrayDimensions)) {
            dataValue.setValue(new Variant((Object)this.dC));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        block11: {
            try {
                if (unsignedInteger.equals((Object)Attributes.Value)) {
                    this.value = object == null ? Variant.NULL : new Variant(object);
                    break block11;
                }
                if (unsignedInteger.equals((Object)Attributes.DataType)) {
                    if (object instanceof NodeId) {
                        this.setDataTypeId((NodeId)object);
                        break block11;
                    }
                    if (object instanceof ExpandedNodeId) {
                        try {
                            this.setDataTypeId(this.getNodeManager().getNamespaceTable().toNodeId((ExpandedNodeId)object));
                            break block11;
                        }
                        catch (ServiceResultException serviceResultException) {
                            throw new StatusException(StatusCodes.Bad_InvalidArgument, (Throwable)serviceResultException);
                        }
                    }
                    throw new StatusException("Cannot set NodeId to the specified value", StatusCodes.Bad_InvalidArgument);
                }
                if (unsignedInteger.equals((Object)Attributes.ValueRank)) {
                    this.fj = (Integer)object;
                    break block11;
                }
                if (unsignedInteger.equals((Object)Attributes.ArrayDimensions)) {
                    this.dC = (UnsignedInteger[])object;
                    break block11;
                }
                super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
                return;
            }
            catch (RuntimeException runtimeException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cannot write attribute " + AttributesUtil.toString((UnsignedInteger)unsignedInteger) + " Variable=" + this.getBrowseName() + " Value=" + object, (Throwable)runtimeException);
                }
                throw new StatusException("Cannot write value", StatusCodes.Bad_InvalidArgument, null, (Throwable)runtimeException);
            }
        }
    }
}

