/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.StructureDataValue;
import com.prosysopc.ua.server.StructureInfo;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.ReflectiveVariable;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.server.nodes.UaVariableTypeNode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.VariableAttributes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class UaVariableNode
extends UaInstanceNode
implements UaVariable {
    private static final Logger logger = LoggerFactory.getLogger(UaVariableNode.class);
    private volatile EnumSet<AccessLevel> do = AccessLevel.READWRITE;
    private volatile UnsignedInteger[] dC = null;
    private volatile UaType dD;
    private volatile boolean dE = false;
    private volatile double dF = -1.0;
    private volatile int dG;
    private volatile EnumSet<AccessLevel> dH = AccessLevel.READWRITE;
    private volatile int dI = -1;

    public UaVariableNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
        this.init();
    }

    public UaVariableNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
        this.init();
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        return super.addProperty(uaProperty);
    }

    @Override
    public EnumSet<AccessLevel> getAccessLevel() {
        return this.do;
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        if (this.dC != null) {
            return this.dC;
        }
        return UaVariableTypeNode.a(this.getValueRank());
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new VariableAttributes());
    }

    @Override
    public UaType getDataType() {
        return this.dD;
    }

    @Override
    public NodeId getDataTypeId() {
        UaType uaType = this.getDataType();
        if (uaType == null) {
            return NodeId.NULL;
        }
        return uaType.getNodeId();
    }

    @Override
    public Boolean getHistorizing() {
        return this.dE;
    }

    @Override
    public Double getMinimumSamplingInterval() {
        return this.dF;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Variable;
    }

    @Override
    public UaProperty[] getProperties() {
        if (this.isPropertyType()) {
            return null;
        }
        return super.getProperties();
    }

    public StatusCode getStatus() {
        return this.getValue().getStatusCode();
    }

    @Override
    public EnumSet<AccessLevel> getUserAccessLevel() {
        return this.dH;
    }

    @Override
    public Integer getValueRank() {
        return this.dI;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals((Object)Attributes.Value)) {
            return this.dH.contains(AccessLevel.CurrentWrite);
        }
        return super.hasUserWriteAccess(unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals((Object)Attributes.Value)) {
            return this.do.contains(AccessLevel.CurrentWrite);
        }
        return super.hasWriteAccess(unsignedInteger);
    }

    public void notifyValueChanging(Object object) {
        this.notifyValueChanging(this.createDataValue(object));
    }

    @Override
    public void setAccessLevel(EnumSet<AccessLevel> enumSet) {
        this.do = enumSet;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        if (!Arrays.equals(this.dC, unsignedIntegerArray)) {
            this.dC = unsignedIntegerArray;
            this.structureChanged();
        }
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes = (VariableAttributes)nodeAttributes;
        this.setArrayDimensions(nodeAttributes.getArrayDimensions());
        this.setDataTypeId(nodeAttributes.getDataType());
        this.setHistorizing(nodeAttributes.getHistorizing());
        this.setMinimumSamplingInterval(nodeAttributes.getMinimumSamplingInterval());
        try {
            this.setValue(new DataValue(nodeAttributes.getValue()));
        }
        catch (StatusException statusException) {
            logger.error("StatusException: ", (Throwable)statusException);
        }
        this.setValueRank(nodeAttributes.getValueRank());
        this.setAccessLevel(AccessLevel.getSet((int)nodeAttributes.getAccessLevel().intValue()));
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setDataType(UaType uaType) {
        if (uaType == null && this.dD == null) {
            return;
        }
        if (uaType == null || !uaType.equals(this.dD)) {
            if (!this.getDataTypeId().equals((Object)Identifiers.BaseDataType)) {
                this.structureChanged();
            }
            this.dD = uaType;
            this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addModelChange(this, ModelChangeType.DataTypeChanged);
        }
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
        nodeId = NodeId.isNull((NodeId)nodeId) ? null : (UaType)this.getNodeManager().getNodeOrExternal(nodeId);
        this.setDataType((UaType)nodeId);
    }

    @Override
    public void setHistorizing(Boolean bl) {
        this.dE = bl;
    }

    @Override
    public void setMinimumSamplingInterval(Double d2) {
        this.dF = d2;
    }

    public void setStatus(StatusCode statusCode) {
        DataValue dataValue = this.getValue();
        if (dataValue != null && dataValue.getStatusCode().equals((Object)statusCode)) {
            return;
        }
        DataValue dataValue2 = new DataValue(statusCode);
        if (dataValue != null) {
            if (!statusCode.isBad()) {
                dataValue2.setValue(dataValue.getValue());
            }
            dataValue2.setServerTimestamp(DateTime.currentTime());
            dataValue2.setSourcePicoseconds(dataValue.getSourcePicoseconds());
            dataValue2.setSourceTimestamp(dataValue.getSourceTimestamp());
        }
        try {
            this.setValue(dataValue2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    public void setTypeDefinition(UaType uaType) {
        this.checkPropertyType(uaType.getNodeId());
        super.setTypeDefinition(uaType);
    }

    @Override
    public void setTypeDefinitionId(ExpandedNodeId expandedNodeId) {
        this.checkPropertyType(expandedNodeId);
        super.setTypeDefinitionId(expandedNodeId);
    }

    @Override
    public void setUserAccessLevel(EnumSet<AccessLevel> enumSet) {
        this.dH = enumSet;
    }

    @Override
    public void setValue(DataValue dataValue) throws StatusException {
        DataValue dataValue2 = this.getValue();
        boolean bl = dataValue instanceof StructureDataValue;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            bl2 = ((StructureDataValue)dataValue).isGoingToRoot();
            bl3 = ((StructureDataValue)dataValue).isGoingToLeaf();
        }
        if (!ObjectUtils.objectEquals((Object)dataValue, (Object)dataValue2)) {
            if (dataValue != null && bl) {
                DataValue dataValue3 = (DataValue)dataValue.clone();
                this.doSetValue(dataValue3);
            } else {
                this.doSetValue(dataValue);
            }
            if (this.dG != 0) {
                StatusCode statusCode = StatusCode.getFromBits((int)(dataValue.getStatusCode().getValue().intValue() | this.dG));
                dataValue = new DataValue(dataValue.getValue(), statusCode, dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setValue: value={} getValue={}", (Object)dataValue, (Object)this.getValue());
            }
            if (!bl3) {
                dataValue = StructureDataValue.from(dataValue, true);
            }
            this.dataChange(Attributes.Value, dataValue2, dataValue);
            this.dG = 0;
            if (!bl2) {
                this.a(dataValue);
            }
        }
    }

    @Override
    public void setValue(Object object) throws StatusException {
        this.updateValue(object);
    }

    @Override
    public void setValueRank(int n2) {
        if (n2 != this.dI) {
            this.dI = n2;
            this.structureChanged();
        }
    }

    @Override
    public String toString() {
        String string = "";
        if (this.dC != null && this.dC.length > 0) {
            string = "ArrayDImensions=" + Arrays.toString(this.dC);
        }
        return String.format("%s DataType=%s, ValueRank=%s%s, MinimumSamplingInterval=%f, AccessLevel=%s, UserAccessLevel=%s, Historizing=%s, Value=%s", super.toString(), this.getDataType(), this.dI, string, this.dF, this.do, this.dH, this.dE, this.getValue());
    }

    public void updateValue(Object object) throws StatusException {
        Variant variant;
        StatusCode statusCode;
        StatusCode statusCode2 = statusCode = object == null ? StatusCode.BAD : StatusCode.GOOD;
        if (object instanceof Variant && (variant = (Variant)object).getValue() == null) {
            statusCode = StatusCode.BAD;
        }
        this.updateValue(object, statusCode, null, null);
    }

    private void init() {
        try {
            this.dD = (UaType)this.getNodeManager().getNode(Identifiers.BaseDataType);
            return;
        }
        catch (Exception exception) {
            logger.error("Could not set the initial DataType of UaVariableNode to BaseDataType", (Throwable)exception);
            return;
        }
    }

    private static UnsignedInteger b(Object object) {
        if (object instanceof UnsignedInteger) {
            return (UnsignedInteger)object;
        }
        if (object instanceof Number) {
            return UnsignedInteger.valueOf((long)((Number)object).intValue());
        }
        throw new ClassCastException("Cannot cast value toUnsignedInteger: " + object);
    }

    private void a(DataValue dataValue) {
        Object object;
        if (dataValue != null && !dataValue.isNull() && this.getDataType() != null && this.getDataType().inheritsFrom(Identifiers.Structure) && (object = dataValue.getValue().getValue()) instanceof Structure) {
            logger.trace("Trying to set values from a Structure to components");
            object = (Structure)object;
            try {
                UaNode[] uaNodeArray = this.getComponents();
                StructureInfo structureInfo = this.getNodeManager().getNodeManagerTable().getStructureInfoCache().getStructureInfo(dataValue.getValue().getCompositeClass());
                for (UaNode uaNode : uaNodeArray) {
                    Object object2;
                    if (!(uaNode instanceof UaVariable) || (object2 = structureInfo.getFieldValue((Structure)object, (uaNode = (UaVariable)uaNode).getBrowseName().getName())) == null) continue;
                    DataValue dataValue2 = (DataValue)dataValue.clone();
                    dataValue2.setValue(new Variant(object2));
                    uaNode.setValue(StructureDataValue.from(dataValue2, false));
                }
                return;
            }
            catch (Exception exception) {
                logger.error("Error while trying to write structure value to up/down parts", (Throwable)exception);
            }
        }
    }

    protected ReflectiveVariable addReflectiveVariable(Object object, NodeId nodeId, String string, int n2, NodeId nodeId2) throws SecurityException, NoSuchMethodException {
        object = new ReflectiveVariable(this.getNodeManager(), nodeId, object, string, Locale.ENGLISH);
        ((BaseNode)object).setBrowseName(new QualifiedName(n2, ((BaseNode)object).getBrowseName().getName()));
        ((UaInstanceNode)object).setTypeDefinitionId(nodeId2);
        if (this.addComponent((UaNode)object) == null) {
            throw new RuntimeException("Component " + ((BaseNode)object).getBrowseName() + " not added to " + this.getClass());
        }
        return object;
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (this.isPropertyType() && !uaReference.getIsInverse(this) && uaReference.getReferenceTypeId().equals((Object)Identifiers.HasProperty)) {
            throw new IllegalArgumentException("Cannot add property nodes to a Property node(BrowseName=" + this.getBrowseName() + " NodeId=" + this.getNodeId());
        }
        return super.beforeAddReference(uaReference);
    }

    protected void checkPropertyType(ExpandedNodeId expandedNodeId) {
        if (this.isPropertyType()) {
            try {
                this.checkPropertyType(this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId));
                return;
            }
            catch (ServiceResultException serviceResultException) {
                throw new IllegalArgumentException("UaProperty must be of type PropertyType", serviceResultException);
            }
        }
    }

    protected void checkPropertyType(NodeId nodeId) {
        if (this.isPropertyType() && !Identifiers.PropertyType.equals((Object)nodeId)) {
            throw new IllegalArgumentException("UaProperty must be of type PropertyType");
        }
    }

    protected DataValue createDataValue(Object object) {
        object = new DataValue(new Variant(object));
        DateTime dateTime = DateTime.currentTime();
        object.setServerTimestamp(dateTime);
        object.setSourceTimestamp(dateTime);
        return object;
    }

    protected abstract void doSetValue(DataValue var1) throws StatusException;

    protected void exposeStructureWithReflectiveVariables(Structure structure, int n2, NodeId nodeId) {
        for (Method method : structure.getClass().getDeclaredMethods()) {
            String string;
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("get") || (string = method.getName().substring(3)).equals("TypeId") || string.equals("XmlEncodeId") || string.equals("BinaryEncodeId")) continue;
            if (Structure.class.isAssignableFrom(method.getReturnType())) {
                try {
                    Structure noSuchMethodException = (Structure)method.invoke((Object)structure, new Object[0]);
                    if (noSuchMethodException != null) {
                        Field field = Identifiers.class.getDeclaredField(method.getReturnType().getSimpleName());
                        NodeId nodeId2 = (NodeId)field.get(null);
                        ReflectiveVariable reflectiveVariable = this.addReflectiveVariable(structure, NodeId.randomGUID((int)this.getNodeManager().getNamespaceIndex()), string, n2, nodeId2);
                        reflectiveVariable.exposeStructureWithReflectiveVariables(noSuchMethodException, n2, nodeId);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("internalStructure == null: {}", (Object)method.getName());
                    continue;
                }
                catch (IllegalAccessException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (SecurityException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (NoSuchFieldException securityException) {
                    throw new RuntimeException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            }
            try {
                this.addReflectiveVariable(structure, NodeId.randomGUID((int)this.getNodeManager().getNamespaceIndex()), string, n2, nodeId);
                logger.debug("{} added", (Object)string);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Failed to create variable for " + structure.getClass() + " component " + string, securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.warn("Failed to create variable for " + structure.getClass() + " component " + string + ": ", (Throwable)noSuchMethodException);
            }
        }
    }

    protected VariableAttributes getAttributes(VariableAttributes variableAttributes) {
        super.getAttributes((NodeAttributes)variableAttributes);
        variableAttributes.setAccessLevel(AccessLevel.getMask(this.getAccessLevel()));
        variableAttributes.setArrayDimensions(this.getArrayDimensions());
        variableAttributes.setDataType(this.getDataTypeId());
        variableAttributes.setHistorizing(this.getHistorizing());
        variableAttributes.setMinimumSamplingInterval(this.getMinimumSamplingInterval());
        variableAttributes.setUserAccessLevel(AccessLevel.getMask(this.getUserAccessLevel()));
        variableAttributes.setValue(this.getValue().getValue());
        variableAttributes.setValueRank(this.getValueRank());
        return variableAttributes;
    }

    @Override
    protected ExpandedNodeId getDefaultTypeDefinition() {
        if (this.isPropertyType()) {
            return new ExpandedNodeId(Identifiers.PropertyType);
        }
        return new ExpandedNodeId(Identifiers.BaseDataVariableType);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Value);
        list.add(Attributes.DataType);
        list.add(Attributes.ValueRank);
        list.add(Attributes.ArrayDimensions);
        list.add(Attributes.AccessLevel);
        list.add(Attributes.UserAccessLevel);
        list.add(Attributes.MinimumSamplingInterval);
        list.add(Attributes.Historizing);
    }

    protected boolean isPropertyType() {
        return UaProperty.class.isAssignableFrom(this.getClass());
    }

    protected void notifyValueChanging(DataValue dataValue) {
        DataValue dataValue2 = this.getValue();
        if (!ObjectUtils.objectEquals((Object)dataValue2.getValue().getValue(), (Object)dataValue.getValue().getValue())) {
            this.fireDataChange(dataValue2, dataValue);
        }
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.DataType)) {
            dataValue.setValue(new Variant((Object)this.getDataTypeId()));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.AccessLevel)) {
            dataValue.setValue(new Variant((Object)AccessLevel.getMask(this.getAccessLevel())));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserAccessLevel)) {
            dataValue.setValue(new Variant((Object)AccessLevel.getMask(this.getUserAccessLevel())));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.MinimumSamplingInterval)) {
            dataValue.setValue(new Variant((Object)this.getMinimumSamplingInterval()));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.Historizing)) {
            dataValue.setValue(new Variant((Object)this.getHistorizing()));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.Value)) {
            unsignedInteger = this.getValue();
            dataValue.setValue(unsignedInteger == null ? null : unsignedInteger.getValue());
            dataValue.setSourceTimestamp(this.getValue().getSourceTimestamp());
            dataValue.setSourcePicoseconds(this.getValue().getSourcePicoseconds());
            dataValue.setServerTimestamp(this.getValue().getServerTimestamp());
            dataValue.setServerPicoseconds(this.getValue().getServerPicoseconds());
            dataValue.setStatusCode(this.getValue().getStatusCode());
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.ValueRank)) {
            dataValue.setValue(new Variant((Object)this.getValueRank()));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.ArrayDimensions)) {
            dataValue.setValue(new Variant((Object)this.getArrayDimensions()));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    protected void semanticsChanged() {
        if (logger.isDebugEnabled()) {
            logger.debug("semanticsChanged: node={}/{}", (Object)this.getNodeId(), (Object)this.getBrowseName());
        }
        this.nodeManager.getNodeManagerTable().getNodeManagerRoot().addSemanticChange(this);
        this.dG |= 0x4000;
    }

    protected void structureChanged() {
        if (logger.isDebugEnabled()) {
            logger.debug("structureChanged: node={}/{}", (Object)this.getNodeId(), (Object)this.getBrowseName());
        }
        this.nodeManager.getNodeManagerTable().getNodeManagerRoot().addSemanticChange(this);
        this.dG |= 0x8000;
    }

    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        DataValue dataValue;
        logger.debug("updateValue: {}", object);
        DateTime dateTime2 = new DateTime();
        UnsignedShort unsignedShort2 = UnsignedShort.valueOf((int)0);
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
            object = dataValue.getValue();
            statusCode = dataValue.getStatusCode();
            dateTime = dataValue.getSourceTimestamp();
            unsignedShort = dataValue.getSourcePicoseconds();
        } else {
            object = object instanceof Variant ? (Variant)object : new Variant(object);
        }
        dataValue = this.getValue();
        logger.debug("updateValue: oldValue={}", (Object)dataValue);
        if (dataValue == null || dataValue.isNull() || !dataValue.getStatusCode().equals((Object)statusCode) || !dataValue.getValue().equals(object) || dateTime != null && !dateTime.equals((Object)this.getValue().getSourceTimestamp())) {
            if (dateTime == null) {
                dateTime = dateTime2;
                unsignedShort = unsignedShort2;
            }
            this.setValue(new DataValue((Variant)object, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2));
            return;
        }
        dataValue.setServerTimestamp(dateTime2);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        block15: {
            try {
                if (unsignedInteger.equals((Object)Attributes.Value)) {
                    this.updateValue(object, statusCode, dateTime, unsignedShort);
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.AccessLevel)) {
                    this.do = object instanceof EnumSet ? (EnumSet)object : AccessLevel.getSet((UnsignedInteger)UaVariableNode.b(object));
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.UserAccessLevel)) {
                    this.dH = object instanceof EnumSet ? (EnumSet)object : AccessLevel.getSet((UnsignedInteger)UaVariableNode.b(object));
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.MinimumSamplingInterval)) {
                    this.dF = (Double)object;
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.Historizing)) {
                    this.dE = (Boolean)object;
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.DataType)) {
                    if (object instanceof NodeId) {
                        this.setDataTypeId((NodeId)object);
                        break block15;
                    }
                    if (object instanceof ExpandedNodeId) {
                        try {
                            this.setDataTypeId(this.getNodeManager().getNamespaceTable().toNodeId((ExpandedNodeId)object));
                            break block15;
                        }
                        catch (ServiceResultException serviceResultException) {
                            throw new StatusException(StatusCodes.Bad_InvalidArgument, (Throwable)serviceResultException);
                        }
                    }
                    throw new StatusException("Cannot set NodeId to the specified value", StatusCodes.Bad_InvalidArgument);
                }
                if (unsignedInteger.equals((Object)Attributes.ValueRank)) {
                    this.dI = (Integer)object;
                    break block15;
                }
                if (unsignedInteger.equals((Object)Attributes.ArrayDimensions)) {
                    this.dC = (UnsignedInteger[])object;
                    break block15;
                }
                super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
                return;
            }
            catch (RuntimeException runtimeException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cannot write attribute " + AttributesUtil.toString((UnsignedInteger)unsignedInteger) + " Variable=" + this.getBrowseName() + " Value=" + object, (Throwable)runtimeException);
                }
                throw new StatusException("Cannot write value", StatusCodes.Bad_InvalidArgument, null, (Throwable)runtimeException);
            }
        }
    }
}

