/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.UaTypeInstanceDeclarationHierarchy;
import com.prosysopc.ua.server.nodes.BaseNode;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaTypeNode
extends BaseNode
implements UaType {
    private static final Logger logger = LoggerFactory.getLogger(UaTypeNode.class);
    private UaTypeInstanceDeclarationHierarchy cT = null;
    private UaType cU;
    protected Class<?> javaClass = null;
    private boolean cV = false;

    protected UaTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    protected UaTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    @Override
    public void addSubType(UaType uaType) {
        this.addReference((UaNode)uaType, Identifiers.HasSubtype, false);
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        UaNode uaNode = super.getComponent(qualifiedName);
        logger.debug("getComponent: type={} component={}", (Object)this.getBrowseName(), (Object)uaNode);
        if (uaNode == null && this.hasSuperType()) {
            uaNode = this.getSuperType().getComponent(qualifiedName);
        }
        return uaNode;
    }

    public synchronized UaTypeInstanceDeclarationHierarchy getInstanceDeclarationHierarchy() {
        if (this.cT == null) {
            this.resetInstanceDeclarationHierarchy();
        }
        return this.cT;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.cV;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public UaType getSuperType() {
        return this.cU;
    }

    @Override
    public boolean hasSuperType() {
        return this.getSuperType() != null;
    }

    @Override
    public boolean inheritsFrom(NodeId nodeId) {
        if (NodeId.isNull((NodeId)nodeId)) {
            return false;
        }
        if (this.getNodeId().equals((Object)nodeId)) {
            return true;
        }
        return this.hasSuperType() && this.getSuperType().inheritsFrom(nodeId);
    }

    @Override
    public boolean inheritsFrom(UaType uaType) {
        if (uaType == null) {
            return false;
        }
        if (this.getNodeId().equals((Object)uaType.getNodeId())) {
            return true;
        }
        return this.hasSuperType() && this.getSuperType().inheritsFrom(uaType);
    }

    public synchronized void resetInstanceDeclarationHierarchy() {
        this.cT = UaTypeInstanceDeclarationHierarchy.fromUaType(this);
    }

    @Override
    public void setIsAbstract(Boolean bl) {
        this.cV = bl;
    }

    @Override
    public void setJavaClass(Class<?> clazz) {
        this.javaClass = clazz;
    }

    @Override
    public void setSuperType(UaType uaType) {
        if (uaType != this.cU) {
            if (uaType == null) {
                throw new NullPointerException("UaTypeNode.setSuperType() cannot take null");
            }
            UaReference uaReference = this.getReference(Identifiers.HasSubtype, true);
            if (uaReference != null) {
                this.deleteReference(uaReference);
            }
            this.cU = uaType;
            this.addReference((UaNode)uaType, Identifiers.HasSubtype, true);
            uaType.addSubType(this);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", IsAbstract=" + this.cV;
    }

    @Override
    protected void afterAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals((Object)Identifiers.HasSubtype)) {
            UaType uaType = (UaType)uaReference.getSourceNode();
            UaType uaType2 = (UaType)uaReference.getTargetNode();
            if (uaReference.getIsInverse(this)) {
                this.setSuperType(uaType);
            } else {
                uaType2.setSuperType(this);
            }
        }
        super.afterAddReference(uaReference);
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals((Object)Identifiers.HasSubtype) && !uaReference.getIsInverse(this)) {
            UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasSubtype, false);
            UaType uaType = (UaType)uaReference.getTargetNode();
            for (UaReference uaReference2 : uaReferenceArray) {
                if (uaReference2.getTargetNode() != uaType) continue;
                return false;
            }
        }
        return super.beforeAddReference(uaReference);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.IsAbstract);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.IsAbstract)) {
            dataValue.setValue(new Variant((Object)this.cV));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.IsAbstract)) {
            this.cV = (Boolean)object;
            return;
        }
        super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
    }
}

