/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaServerReference.class);
    private UaNode bt;
    private final NodeId bu;
    private Boolean bv = null;
    private UaNode bw = null;
    private UaNode bx = null;

    public static UaServerReference getReferenceInstance(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(nodeId, uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(nodeId, uaNode, uaNode2);
    }

    public static UaServerReference getReferenceInstance(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(uaReferenceType.getNodeId(), uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(uaReferenceType, uaNode, uaNode2);
    }

    private static UaServerReference a(NodeId uaReferenceArray, UaNode uaNode, UaNode uaNode2) {
        if (uaReferenceArray == null) {
            throw new NullPointerException("referenceTypeId");
        }
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        if ((uaReferenceArray = uaNode.getReferences((NodeId)uaReferenceArray, false)) != null) {
            for (UaReference uaReference : uaReferenceArray) {
                if (!uaReference.getTargetId().equals((Object)uaNode2.getNodeId())) continue;
                return (UaServerReference)uaReference;
            }
        }
        return null;
    }

    public UaServerReference(NodeId object, UaNode uaNode, UaNode uaNode2) {
        if (object == null) {
            throw new NullPointerException("referenceTypeId");
        }
        this.bu = object;
        object = this;
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        object.bx = uaNode2;
        uaNode2 = uaNode;
        object = this;
        if (uaNode2 == null) {
            throw new NullPointerException("sourceNode");
        }
        object.bw = uaNode2;
    }

    public UaServerReference(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        this(uaReferenceType.getNodeId(), uaNode, uaNode2);
        this.bt = uaReferenceType;
    }

    @Override
    public void delete() {
        this.bw.deleteReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (UaServerReference)object;
        if (this.bx == null ? ((UaServerReference)object).bx != null : this.bx != ((UaServerReference)object).bx) {
            return false;
        }
        if (this.bw == null ? ((UaServerReference)object).bw != null : this.bw != ((UaServerReference)object).bw) {
            return false;
        }
        return !(this.bu == null ? ((UaServerReference)object).bu != null : !this.bu.equals((Object)((UaServerReference)object).bu));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl = !this.bw.getNodeId().equals((Object)nodeId);
        if (bl && !this.bx.getNodeId().equals((Object)nodeId)) {
            throw new IllegalArgumentException("getIsInverse: node is neither targetNode nor sourceNode");
        }
        return bl;
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl = !this.bw.getNodeId().equals((Object)uaNode.getNodeId());
        if (bl && !this.bx.getNodeId().equals((Object)uaNode.getNodeId())) {
            throw new IllegalArgumentException(String.format("getIsInverse: node (%s) is neither targetNode (%s) nor sourceNode (%s); referenceType=%s", uaNode.getNodeId(), this.getTargetId(), this.getSourceId(), this.getReferenceType().getBrowseName()));
        }
        return bl;
    }

    @Override
    public UaReferenceType getReferenceType() {
        if (this.bt == null) {
            try {
                ServerNode serverNode = null;
                if (this.bw instanceof ServerNode) {
                    serverNode = (ServerNode)this.bw;
                } else if (this.bx instanceof ServerNode) {
                    serverNode = (ServerNode)this.bx;
                }
                if (serverNode != null) {
                    this.bt = serverNode.getNodeManager().getNode(this.bu);
                }
            }
            catch (StatusException statusException) {
                logger.debug("ReferenceType " + this.bu + " could not be found");
                return null;
            }
        }
        if (this.bt instanceof UaReferenceType) {
            return (UaReferenceType)this.bt;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.bu;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return new ExpandedNodeId(this.bw.getNodeId());
    }

    @Override
    public UaNode getSourceNode() {
        return this.bw;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return new ExpandedNodeId(this.bx.getNodeId());
    }

    @Override
    public UaNode getTargetNode() {
        return this.bx;
    }

    public int hashCode() {
        int n2 = 31 + (this.bu == null ? 0 : this.bu.hashCode());
        n2 = n2 * 31 + (this.bx == null ? 0 : this.bx.getNodeId().hashCode());
        n2 = n2 * 31 + (this.bw == null ? 0 : this.bw.getNodeId().hashCode());
        return n2;
    }

    public boolean isSymmetric() {
        UaReferenceType uaReferenceType;
        UaServerReference uaServerReference = this;
        if (uaServerReference.bv == null && (uaReferenceType = uaServerReference.getReferenceType()) != null) {
            uaServerReference.bv = uaReferenceType.getSymmetric() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.bv != null && this.bv != false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.getReferenceType();
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        }
        if (!(this.bw instanceof UaExternalNode)) {
            stringBuilder.append(" SourceNode=");
            stringBuilder.append(this.bw.getBrowseName());
        }
        if (!(this.bx instanceof UaExternalNode)) {
            stringBuilder.append(" TargetNode=");
            stringBuilder.append(this.bx.getBrowseName());
        }
        return super.toString() + stringBuilder.toString();
    }
}

