/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.CacheProperty;
import com.prosysopc.ua.server.nodes.CacheVariable;
import com.prosysopc.ua.server.nodes.UaDataTypeNode;
import com.prosysopc.ua.server.nodes.UaMethodNode;
import com.prosysopc.ua.server.nodes.UaObjectNode;
import com.prosysopc.ua.server.nodes.UaObjectTypeNode;
import com.prosysopc.ua.server.nodes.UaReferenceTypeNode;
import com.prosysopc.ua.server.nodes.UaVariableTypeNode;
import com.prosysopc.ua.server.nodes.UaViewNode;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerNodeFactory
implements UaNodeFactory {
    private final Map<NodeClass, Constructor<? extends UaNode>> eR;
    private final NodeManagerUaNode nodeManager;
    private final RegisteredClasses eS;
    private final Map<NodeId, Constructor<? extends UaNode>> eT;
    protected final Logger logger = LoggerFactory.getLogger(UaServerNodeFactory.class);

    public UaServerNodeFactory(NodeManagerUaNode nodeManagerUaNode) {
        this.eR = new HashMap<NodeClass, Constructor<? extends UaNode>>();
        this.eT = new HashMap<NodeId, Constructor<? extends UaNode>>();
        this.eS = nodeManagerUaNode.getServer().getRegisteredClasses();
        try {
            this.registerNodeClass(NodeClass.Object, UaObjectNode.class);
            this.registerNodeClass(NodeClass.Variable, CacheVariable.class);
            this.registerNodeClass(NodeClass.Method, UaMethodNode.class);
            this.registerNodeClass(NodeClass.ObjectType, UaObjectTypeNode.class);
            this.registerNodeClass(NodeClass.VariableType, UaVariableTypeNode.class);
            this.registerNodeClass(NodeClass.ReferenceType, UaReferenceTypeNode.class);
            this.registerNodeClass(NodeClass.DataType, UaDataTypeNode.class);
            this.registerNodeClass(NodeClass.View, UaViewNode.class);
            this.registerTypeDefinition(Identifiers.PropertyType, CacheProperty.class);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new RuntimeException("Error creating default server node factory", uaNodeFactoryException);
        }
        this.nodeManager = nodeManagerUaNode;
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, qualifiedName, localizedText, (NodeId)null);
    }

    @Override
    public UaNode createNode(NodeClass object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        object = this.getConstructor((NodeClass)object, expandedNodeId);
        return this.a((Constructor<? extends UaNode>)object, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, NodeId nodeId2) throws UaNodeFactoryException {
        object = this.getConstructor((NodeClass)object, nodeId2);
        return this.a((Constructor<? extends UaNode>)object, nodeId, qualifiedName, localizedText, nodeId2 == null ? null : new ExpandedNodeId(nodeId2));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, this.a(string), new LocalizedText(string, locale));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, this.a(string), new LocalizedText(string, locale), expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, NodeId nodeId2) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, this.a(string), new LocalizedText(string, locale), nodeId2);
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        return this.getConstructor(nodeClass, expandedNodeId).getDeclaringClass();
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, NodeId nodeId) {
        return this.getConstructor(nodeClass, nodeId).getDeclaringClass();
    }

    @Override
    public void registerNodeClass(NodeClass nodeClass, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.eR.put(nodeClass, UaServerNodeFactory.a(clazz));
    }

    @Override
    public void registerTypeDefinition(NodeId nodeId, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.eT.put(nodeId, UaServerNodeFactory.a(clazz));
    }

    private QualifiedName a(String string) {
        return new QualifiedName(this.nodeManager.getNamespaceIndex(), string);
    }

    private UaNode a(Constructor<? extends UaNode> constructor, NodeId object, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        this.logger.debug("createInstance: " + constructor);
        try {
            object = constructor.newInstance(this.nodeManager, object, qualifiedName, localizedText);
            if (object instanceof UaInstance) {
                ((UaInstance)object).setTypeDefinitionId(expandedNodeId);
            }
            return object;
        }
        catch (Exception exception) {
            this.logger.debug("got following error in UaServerNodeFactory:", (Throwable)exception);
            throw new UaNodeFactoryException("Cannot create a new UaNode instance of class " + constructor.getName(), exception);
        }
    }

    private static Constructor<? extends UaNode> a(Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        try {
            Constructor<? extends UaNode> constructor = clazz.getDeclaredConstructor(NodeManagerUaNode.class, NodeId.class, QualifiedName.class, LocalizedText.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeManagerUaNode, NodeId, QualifiedName, LocalizedText) is not found from class " + clazz.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeManagerUaNode, NodeId, QualifiedName, LocalizedText) is not public or accessible in class " + clazz.getName(), securityException);
        }
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        NodeId nodeId = null;
        if (!ExpandedNodeId.isNull((ExpandedNodeId)expandedNodeId) && expandedNodeId.isLocal()) {
            try {
                nodeId = this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                this.logger.warn("ServiceResultException: ", (Throwable)serviceResultException);
            }
        }
        return this.getConstructor(nodeClass, nodeId);
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, NodeId nodeId) {
        if (nodeId != null) {
            if (this.eT.containsKey(nodeId)) {
                return this.eT.get(nodeId);
            }
            nodeId = this.nodeManager.getNamespaceTable().toExpandedNodeId(nodeId);
            if (this.eS.containsClass((ExpandedNodeId)nodeId)) {
                return UaServerNodeFactory.a(this.eS.getClass((ExpandedNodeId)nodeId));
            }
        }
        return this.eR.get(nodeClass);
    }
}

