/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.EventNotifierClass;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaObjectType;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.nodes.UaCallable;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ObjectAttributes;
import org.opcfoundation.ua.core.StatusCodes;

public class UaObjectNode
extends UaInstanceNode
implements UaObject,
UaCallable {
    private final List<CallableListener> listeners = new CopyOnWriteArrayList<CallableListener>();
    private EnumSet<EventNotifierClass> cn = EventNotifierClass.NONE;

    public UaObjectNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaObjectNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    @Override
    public void addCallListener(CallableListener callableListener) {
        this.listeners.add(callableListener);
    }

    @Override
    public Object[] callMethod(NodeId objectArray, Object ... objectArray2) throws StatusException {
        Variant[] variantArray = new Variant[objectArray2.length];
        StatusCode[] statusCodeArray = new StatusCode[objectArray2.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray2.length];
        for (int i2 = 0; i2 < variantArray.length; ++i2) {
            variantArray[i2] = new Variant(objectArray2[i2]);
        }
        Variant[] variantArray2 = this.callMethod(ServiceContext.INTERNAL_OPERATION_CONTEXT, (NodeId)objectArray, variantArray, statusCodeArray, diagnosticInfoArray);
        objectArray = new Object[variantArray2.length];
        for (int i3 = 0; i3 < variantArray2.length; ++i3) {
            objectArray[i3] = variantArray2[i3].getValue();
        }
        return objectArray;
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        throw new StatusException(StatusCodes.Bad_MethodInvalid);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new ObjectAttributes());
    }

    @Override
    public EnumSet<EventNotifierClass> getEventNotifier() {
        Object object = this.cn.clone();
        UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasEventSource, false);
        UaReference[] uaReferenceArray2 = this.getReferences(Identifiers.HasEventSource, true);
        if (uaReferenceArray.length == 0 && uaReferenceArray2.length == 0) {
            ((AbstractCollection)object).remove((Object)EventNotifierClass.SubscribeToEvents);
        } else {
            ((AbstractCollection)object).add(EventNotifierClass.SubscribeToEvents);
        }
        return object;
    }

    @Override
    public UaProperty getIcon() {
        return this.getProperty(UaObjectType.ICON_PROPERTY);
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Object;
    }

    @Override
    public void removeCallListener(CallableListener callableListener) {
        this.listeners.remove(callableListener);
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setEventNotifier(EventNotifierClass.getSet(((ObjectAttributes)nodeAttributes).getEventNotifier()));
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setEventNotifier(EnumSet<EventNotifierClass> enumSet) {
        this.cn = enumSet;
    }

    @Override
    public void setIcon(UaProperty uaProperty) throws StatusException {
        this.setPropertyValue(UaObjectType.ICON_PROPERTY, uaProperty);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    protected void deleteIfNodeExists(NodeId nodeId) {
        if (this.nodeManager.hasNode(nodeId)) {
            try {
                this.nodeManager.deleteNode(nodeId, true, true);
                return;
            }
            catch (StatusException statusException) {}
        }
    }

    protected NodeAttributes getAttributes(ObjectAttributes objectAttributes) {
        super.getAttributes((NodeAttributes)objectAttributes);
        objectAttributes.setEventNotifier(EventNotifierClass.getMask(this.getEventNotifier()));
        return objectAttributes;
    }

    @Override
    protected ExpandedNodeId getDefaultTypeDefinition() {
        return new ExpandedNodeId(Identifiers.BaseObjectType);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.EventNotifier);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.EventNotifier)) {
            dataValue.setValue(new Variant((Object)EventNotifierClass.getMask(this.getEventNotifier())));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.EventNotifier)) {
            if (object instanceof EnumSet) {
                this.cn = (EnumSet)object;
                return;
            }
            byte by = 0;
            if (object instanceof UnsignedByte) {
                by = ((UnsignedByte)object).byteValue();
            } else if (object instanceof UnsignedInteger) {
                by = ((UnsignedInteger)object).byteValue();
            }
            this.cn = EventNotifierClass.getSet(by);
            return;
        }
        super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
    }
}

