/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Argument;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.MethodAttributes;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.encoding.DecodingException;

public class UaMethodNode
extends BaseNode
implements UaMethod {
    protected static final QualifiedName INPUT_ARGUMENTS = new QualifiedName("InputArguments");
    protected static final QualifiedName OUTPUT_ARGUMENTS = new QualifiedName("OutputArguments");
    private Boolean hb = true;
    private Boolean hc = true;

    public UaMethodNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaMethodNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new MethodAttributes());
    }

    @Override
    public Boolean getExecutable() {
        return this.hb;
    }

    @Override
    public Argument[] getInputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(INPUT_ARGUMENTS));
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Method;
    }

    @Override
    public Argument[] getOutputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(OUTPUT_ARGUMENTS));
    }

    @Override
    public Boolean getUserExecutable() {
        return this.hc;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setExecutable(((MethodAttributes)nodeAttributes).getExecutable());
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setExecutable(Boolean bl) {
        this.hb = bl;
    }

    @Override
    public void setUserExecutable(Boolean bl) {
        this.hc = bl;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private Argument[] a(UaProperty extensionObjectArray) throws MethodArgumentException {
        if (extensionObjectArray == null || extensionObjectArray.getValue().isNull()) {
            return new Argument[0];
        }
        if ((extensionObjectArray = extensionObjectArray.getValue().getValue().getValue()) instanceof Argument[]) {
            return (Argument[])extensionObjectArray;
        }
        try {
            extensionObjectArray = extensionObjectArray;
        }
        catch (ClassCastException classCastException) {
            throw new MethodArgumentException("Property does not contain argument values.");
        }
        int n2 = extensionObjectArray == null ? 0 : extensionObjectArray.length;
        Argument[] argumentArray = new Argument[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                argumentArray[i2] = (Argument)extensionObjectArray[i2].decode(this.nodeManager.getNodeManagerTable().getEncoderContext());
                continue;
            }
            catch (DecodingException decodingException) {
                throw new MethodArgumentException("Cannot decode argument value #" + i2);
            }
        }
        return argumentArray;
    }

    protected NodeAttributes getAttributes(MethodAttributes methodAttributes) {
        super.getAttributes((NodeAttributes)methodAttributes);
        methodAttributes.setExecutable(this.getExecutable());
        methodAttributes.setUserExecutable(this.getUserExecutable());
        return methodAttributes;
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Executable);
        list.add(Attributes.UserExecutable);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.Executable)) {
            dataValue.setValue(new Variant((Object)this.hb));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserExecutable)) {
            dataValue.setValue(new Variant((Object)this.hc));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.Executable)) {
            this.hb = (Boolean)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserExecutable)) {
            this.hc = (Boolean)object;
            return;
        }
        super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
    }
}

