/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.PlainMethod;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaInstanceNode
extends BaseNode
implements UaInstance {
    private static final Logger logger = LoggerFactory.getLogger(UaInstanceNode.class);
    private volatile UaReference hy = null;

    public UaInstanceNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
        this.init();
    }

    public UaInstanceNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
        this.init();
    }

    public UaReference addModellingRule(ModellingRule modellingRule) {
        return this.addReference(modellingRule.getNodeId(), Identifiers.HasModellingRule, false);
    }

    @Override
    public UaType getTypeDefinition() {
        if (this.hy != null) {
            return (UaType)this.hy.getTargetNode();
        }
        return null;
    }

    @Override
    public ExpandedNodeId getTypeDefinitionId() {
        UaType uaType;
        ExpandedNodeId expandedNodeId = this.getDefaultTypeDefinition();
        if (this.supportsTypeDefinitionNode() && (uaType = this.getTypeDefinition()) != null) {
            expandedNodeId = new ExpandedNodeId(uaType.getNodeId());
        }
        return expandedNodeId;
    }

    @Override
    public boolean hasTypeDefinition() {
        return this.hy != null;
    }

    @Override
    public void setTypeDefinition(UaType uaType) {
        this.addReference((UaNode)uaType, Identifiers.HasTypeDefinition, false);
    }

    @Override
    public void setTypeDefinitionId(ExpandedNodeId expandedNodeId) {
        try {
            this.setTypeDefinitionId(this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId));
            return;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
    }

    @Override
    public final void setTypeDefinitionId(NodeId object) {
        if (this.supportsTypeDefinitionNode() && object != null && !object.isNullNodeId()) {
            this.setTypeDefinition((UaType)this.nodeManager.getNodeOrExternal((NodeId)object));
            return;
        }
        object = this;
        if (((UaInstanceNode)object).hy != null) {
            ((BaseNode)object).deleteReference(((UaInstanceNode)object).hy);
            ((UaInstanceNode)object).hy = null;
        }
        this.hy = null;
    }

    @Override
    public String toString() {
        if (!this.hasTypeDefinition()) {
            return super.toString();
        }
        return super.toString() + "; Type={" + this.getTypeDefinition() + "}";
    }

    private void init() {
        this.setTypeDefinitionId(this.getDefaultTypeDefinition());
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals((Object)Identifiers.HasTypeDefinition) && !uaReference.getIsInverse(this)) {
            if (!uaReference.equals(this.hy)) {
                if (this.hy != null) {
                    this.deleteReference(this.hy);
                }
                this.hy = uaReference;
            } else {
                return false;
            }
        }
        return super.beforeAddReference(uaReference);
    }

    protected abstract ExpandedNodeId getDefaultTypeDefinition();

    protected UaMethod registerOverridePlainMethod(String string) {
        UaType uaType = this.getTypeDefinition();
        String string2 = uaType == null ? "null" : uaType.getBrowseName().toString();
        logger.debug("createPlainMethod: name={} typeDefinition={}", (Object)string, (Object)string2);
        QualifiedName qualifiedName = UaInstanceNode.getStandardBrowseName(string);
        UaMethod uaMethod = null;
        if (uaType != null) {
            uaMethod = (UaMethod)uaType.getComponent(qualifiedName);
        }
        if (uaMethod == null) {
            logger.warn("Method {} not found from the type {}", (Object)string, (Object)string2);
            uaMethod = new PlainMethod(this.nodeManager, this.createNodeId(this, string), qualifiedName, UaInstanceNode.getStandardDisplayText(string));
        }
        return uaMethod;
    }

    protected boolean supportsTypeDefinitionNode() {
        return true;
    }
}

