/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.EventListener;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.server.nodes.UaServerReference;
import com.prosysopc.ua.server.nodes.a;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerNode
implements UaNode {
    private static boolean by = true;
    private static final Logger logger = LoggerFactory.getLogger(ServerNode.class);
    protected static final DateTime INITIALIZATION_TIME = DateTime.currentTime();
    protected static final Map<Class<? extends UaNode>, List<UnsignedInteger>> supportedAttributesMap = new HashMap<Class<? extends UaNode>, List<UnsignedInteger>>();
    private List<DataChangeListener> bz;
    private NodeId nodeId;
    private Collection<UaReference> bA;
    protected List<EventListener> eventListeners;
    protected final NodeManagerUaNode nodeManager;

    public static boolean isAddNotifierReferencesToServerObject() {
        return by;
    }

    public static void setAddNotifierReferencesToServerObject(boolean bl) {
        by = bl;
    }

    public ServerNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId) {
        this.nodeManager = nodeManagerUaNode;
        this.nodeId = nodeId;
    }

    @Override
    public UaReference addComponent(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.HasComponent, false);
    }

    public synchronized void addDataChangeListener(DataChangeListener dataChangeListener) {
        if (this.L() == null) {
            this.bz = new CopyOnWriteArrayList<DataChangeListener>();
        }
        this.L().add(dataChangeListener);
    }

    public synchronized void addEventListener(EventListener eventListener) {
        if (this.M() == null) {
            this.eventListeners = new CopyOnWriteArrayList<EventListener>();
        }
        this.M().add(eventListener);
    }

    public UaReference addNewReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.addNewReference(this.nodeManager.getNodeOrExternal(nodeId), nodeId2, bl);
    }

    public UaReference addNewReference(UaNode object, NodeId object2, boolean bl) {
        UaNode uaNode = bl ? object : this;
        UaNode uaNode2 = bl ? this : object;
        object2 = new UaServerReference((NodeId)object2, uaNode, uaNode2);
        this.a((UaReference)object2);
        if (object instanceof ServerNode) {
            object = (ServerNode)object;
            ((ServerNode)object).a((UaReference)object2);
            ((ServerNode)object).getAddressSpace().addNode((UaNode)object);
        }
        if (((UaServerReference)object2).getTargetNode().equals(this)) {
            this.validateHasEventSourceChain((UaReference)object2);
        }
        object = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        ((NodeManagerRoot)object).addModelChange(this, ModelChangeType.ReferenceAdded);
        return object2;
    }

    public UaReference addOrganizes(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.Organizes, false);
    }

    public void addProperties(UaProperty[] uaPropertyArray) {
        for (UaProperty uaProperty : uaPropertyArray) {
            this.addProperty(uaProperty);
        }
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        logger.debug("addProperty: property={}", (Object)uaProperty.getBrowseName());
        return this.addReference((UaNode)uaProperty, Identifiers.HasProperty, false);
    }

    @Override
    public UaReference addReference(NodeId object, NodeId nodeId, boolean bl) {
        object = this.nodeManager.getNodeOrExternal((NodeId)object);
        return this.addReference((UaNode)object, nodeId, bl);
    }

    @Override
    public UaReference addReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        UaNode uaNode2 = bl ? uaNode : this;
        uaNode = bl ? this : uaNode;
        return this.addReference(UaServerReference.getReferenceInstance(nodeId, uaNode2, uaNode));
    }

    public UaReference addReference(UaNode uaNode, UaReferenceType uaReferenceType, boolean bl) {
        UaNode uaNode2 = bl ? uaNode : this;
        uaNode = bl ? this : uaNode;
        return this.addReference(UaServerReference.getReferenceInstance(uaReferenceType, uaNode2, uaNode));
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        for (UaReference uaReference : this.getReferenceList()) {
            ExpandedNodeId expandedNodeId2;
            ExpandedNodeId expandedNodeId3 = bl ? this.getNodeId() : expandedNodeId;
            Object object = expandedNodeId2 = bl ? expandedNodeId : this.getNodeId();
            if (!uaReference.getTargetId().equals((Object)expandedNodeId3) || !uaReference.getSourceId().equals((Object)expandedNodeId2) || !uaReference.getReferenceTypeId().equals((Object)nodeId)) continue;
            return this.doDeleteReference(uaReference);
        }
        return null;
    }

    @Override
    public UaReference deleteReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.deleteReference(new ExpandedNodeId(nodeId), nodeId2, bl);
    }

    @Override
    public UaReference deleteReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        return this.deleteReference(uaNode.getNodeId(), nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        return this.doDeleteReference(uaReference);
    }

    public void deleteReferences(NodeId nodeId) {
        logger.debug("deleteReferences targetNodeId : {}", (Object)nodeId);
        for (UaReference uaReference : this.getReferenceList()) {
            if (!nodeId.equals((Object)uaReference.getTargetId())) continue;
            this.doDeleteReference(uaReference);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (UaNode)object;
        if (NodeId.isNull((NodeId)this.nodeId)) {
            return NodeId.isNull((NodeId)object.getNodeId());
        }
        return this.nodeId.equals((Object)object.getNodeId());
    }

    @Override
    public NodeManagerTable getAddressSpace() {
        return this.nodeManager.getNodeManagerTable();
    }

    @Override
    public UaReference[] getForwardReferences(NodeId ... nodeIdArray) {
        return this.getReferences(false, nodeIdArray);
    }

    @Override
    public UaReference[] getInverseReferences(NodeId ... nodeIdArray) {
        return this.getReferences(true, nodeIdArray);
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeManagerUaNode getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public UaReference getReference(NodeId nodeId, boolean bl) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null) {
            for (UaReference uaReference : collection) {
                if (!NodeId.isNull((NodeId)nodeId) && !uaReference.getReferenceTypeId().equals((Object)nodeId) || uaReference.getIsInverse(this) != bl) continue;
                return uaReference;
            }
        }
        return null;
    }

    @Override
    public UaReference[] getReferences() {
        List<UaReference> list = this.getReferencesAsList(null, new NodeId[0]);
        return list.toArray(new UaReference[0]);
    }

    @Override
    public UaReference[] getReferences(NodeId object, boolean bl) {
        object = this.getReferencesAsList(bl, new NodeId[]{object});
        return object.toArray(new UaReference[object.size()]);
    }

    @Override
    public UnsignedInteger[] getSupportedAttributes() {
        List<UnsignedInteger> list = this.N();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    public int hashCode() {
        int n2 = 31 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n2;
    }

    public boolean isMandatory() {
        return this.a(this, new ArrayList<QualifiedName>());
    }

    @Override
    public UaNode removeComponent(UaNode uaNode) {
        UaReference uaReference = this.deleteReference(uaNode, Identifiers.HasComponent, false);
        if (uaReference == null) {
            return null;
        }
        return uaNode;
    }

    public synchronized void removeDataChangeListener(DataChangeListener dataChangeListener) {
        List<DataChangeListener> list = this.L();
        if (list != null) {
            list.remove(dataChangeListener);
            if (list.isEmpty()) {
                this.bz = null;
            }
        }
    }

    public synchronized void removeEventListener(EventListener eventListener) {
        if (this.M() != null) {
            this.M().remove(eventListener);
            if (this.M().isEmpty()) {
                this.eventListeners = null;
            }
        }
    }

    @Override
    public synchronized void setReferences(UaReference[] uaReferenceArray) {
        this.O();
        this.bA.addAll(Arrays.asList(uaReferenceArray));
    }

    @Override
    public boolean supportsAttribute(UnsignedInteger unsignedInteger) {
        return this.N().contains(unsignedInteger);
    }

    public String toString() {
        return String.format("NodeId=%s, NodeClass=%s", this.nodeId, this.getNodeClass());
    }

    private synchronized void a(UaReference uaReference) {
        if (this.bA == null) {
            this.O();
        }
        this.bA.add(uaReference);
    }

    private synchronized List<DataChangeListener> L() {
        return this.bz;
    }

    private synchronized List<EventListener> M() {
        return this.eventListeners;
    }

    private List<UnsignedInteger> N() {
        List<UnsignedInteger> list = supportedAttributesMap.get(this.getClass());
        if (list == null) {
            list = new ArrayList<UnsignedInteger>();
            this.initSupportedAttributes(list);
            supportedAttributesMap.put(this.getClass(), list);
        }
        return list;
    }

    private void O() {
        this.bA = new ConcurrentSkipListSet<UaReference>();
    }

    private boolean a(UaNode object, List<QualifiedName> object22) {
        while (true) {
            Object object3;
            if (object == null) {
                return false;
            }
            if (object instanceof UaInstance && !(object instanceof UaProperty) && this.a((UaType)(object3 = ((UaInstance)object).getTypeDefinition()), (List<QualifiedName>)object22)) {
                return true;
            }
            UaReference[] uaReferenceArray = object.getReferences(Identifiers.HierarchicalReferences, true);
            object3 = uaReferenceArray;
            object3 = uaReferenceArray;
            int n2 = uaReferenceArray.length;
            if (n2 <= 0) break;
            object3 = object3[0];
            ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
            arrayList.add(object.getBrowseName());
            for (Object object22 : object22) {
                arrayList.add((QualifiedName)object22);
            }
            object22 = arrayList;
            object = ((UaReference)object3).getSourceNode();
        }
        return false;
    }

    private boolean a(UaType nodeIdArray, List<QualifiedName> list) {
        if (nodeIdArray == null) {
            return false;
        }
        if ((nodeIdArray = this.translateBrowsePathToNodeIds(nodeIdArray.getNodeId(), list.toArray(new QualifiedName[0]))).length == 0) {
            return false;
        }
        for (NodeId nodeId : nodeIdArray) {
            try {
                UaNode uaNode = this.getNodeManager().getNodeManagerTable().getNode(nodeId);
                UaReference uaReference = uaNode.getReference(Identifiers.HasModellingRule, false);
                if (uaReference == null || !uaReference.getTargetId().equals((Object)Identifiers.ModellingRule_Mandatory)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected final UaReference addReference(UaReference uaReference) {
        UaReference uaReference2 = this.hasReference(uaReference);
        if (uaReference2 != null) {
            return uaReference2;
        }
        if (!(uaReference instanceof UaServerReference)) {
            throw new IllegalArgumentException("BaseNode.addReference() requires an instance of UaServerReference");
        }
        if (this.beforeAddReference(uaReference)) {
            this.a(uaReference);
        }
        this.afterAddReference(uaReference);
        return uaReference;
    }

    protected void afterAddReference(UaReference uaReference) {
        Object object;
        UaNode uaNode = uaReference.getOppositeNode(this);
        if (!uaReference.getIsInverse(this) && (object = uaReference.getReferenceType()) != null && object.inheritsFrom(Identifiers.HierarchicalReferences) && !(uaNode instanceof UaExternalNode) && !NodeId.isNull((NodeId)uaNode.getNodeId())) {
            uaNode.getAddressSpace().addNode(uaNode);
        }
        if (!(uaReference instanceof a)) {
            uaNode.addReference(this, uaReference.getReferenceTypeId(), uaReference.getIsInverse(uaNode));
        }
        if (uaReference.getTargetNode().equals(this)) {
            this.validateHasEventSourceChain(uaReference);
        }
        object = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        ((NodeManagerRoot)object).addModelChange(this, ModelChangeType.ReferenceAdded);
    }

    protected void afterDeleteReference(UaReference uaReference) {
        NodeManagerRoot nodeManagerRoot = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        nodeManagerRoot.addModelChange(this, ModelChangeType.ReferenceDeleted);
        uaReference.getOppositeNode(this).deleteReference(uaReference);
    }

    protected boolean beforeAddReference(UaReference uaReference) {
        if (!uaReference.getIsInverse(this)) {
            UaNode uaNode = uaReference.getTargetNode();
            if (uaReference.getReferenceTypeId().equals((Object)Identifiers.HasProperty)) {
                if (!(uaNode instanceof UaProperty)) {
                    logger.debug("could not cast to UaReference:{} ..with referenceId: {}", (Object)uaNode, uaReference.getReferenceTypeId().getValue());
                    throw new IllegalArgumentException("Target of HasProperty reference must be a UaProperty");
                }
                return this.doAddProperty((UaProperty)uaNode);
            }
        }
        return true;
    }

    protected void dataChange(UnsignedInteger uaReferenceArray, DataValue dataValue, DataValue dataValue2) {
        this.fireDataChange(dataValue, dataValue2);
        if (this instanceof UaVariable && ((UaVariable)((Object)this)).getAccessLevel().contains(AccessLevel.SemanticChange)) {
            if (dataValue != null && dataValue2 != null && ObjectUtils.equals((Object)dataValue2.getValue(), (Object)dataValue.getValue()) && ObjectUtils.equals((Object)dataValue2.getStatusCode(), (Object)dataValue.getStatusCode()) && ObjectUtils.equals((Object)dataValue2.getSourceTimestamp(), (Object)dataValue.getSourceTimestamp()) && ObjectUtils.equals((Object)dataValue2.getSourcePicoseconds(), (Object)dataValue.getSourcePicoseconds())) {
                return;
            }
            uaReferenceArray = this.getInverseReferences(Identifiers.HasProperty);
            if (uaReferenceArray != null && uaReferenceArray.length != 0) {
                this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().beginSemanticChange();
                for (UaReference uaReference : uaReferenceArray) {
                    UaNode object = uaReference.getSourceNode();
                    this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addSemanticChange(object);
                }
                this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().endSemanticChange();
            }
        }
    }

    protected boolean doAddProperty(UaProperty uaProperty) {
        return true;
    }

    protected UaReference doDeleteReference(UaReference uaReference) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null && collection.remove(uaReference)) {
            this.afterDeleteReference(uaReference);
            return uaReference;
        }
        return null;
    }

    protected void fireDataChange(DataValue dataValue, DataValue dataValue2) {
        List<DataChangeListener> list = this.L();
        if (list != null) {
            for (DataChangeListener dataChangeListener : list) {
                dataChangeListener.onDataChange(this, dataValue, dataValue2);
            }
        }
    }

    protected void fireEvent(EventData eventData, List<ServerNode> list) {
        if (!list.contains(this)) {
            Object object;
            if (logger.isDebugEnabled()) {
                logger.debug("fireEvent: Name={} ID={}", (Object)this.getBrowseName(), (Object)this.getNodeId());
            }
            if ((object = this.M()) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    EventListener eventListener = (EventListener)object.next();
                    eventListener.onEvent(this, eventData);
                }
            }
            list.add(this);
            this.fireEventInParents(eventData, list, Identifiers.HasEventSource, Identifiers.HasNotifier, Identifiers.HasCondition);
            this.getAddressSpace().getNodeManagerRoot().getServerData().fireEvent(eventData, list);
        }
    }

    protected final void fireEventInParents(EventData eventData, List<ServerNode> list, NodeId ... objectArray) {
        for (UaReference uaReference : this.getReferences(true, (NodeId[])objectArray)) {
            if (!(uaReference.getSourceNode() instanceof UaInstanceNode)) continue;
            ((UaInstanceNode)uaReference.getSourceNode()).fireEvent(eventData, list);
        }
    }

    protected QualifiedName getDefaultBrowseName(NodeId nodeId, String string) {
        return new QualifiedName(nodeId == null ? 0 : nodeId.getNamespaceIndex(), string);
    }

    protected synchronized Collection<UaReference> getReferenceList() {
        return this.bA;
    }

    protected UaReference[] getReferences(boolean bl, NodeId ... nodeIdArray) {
        List<UaReference> list = this.getReferencesAsList(bl, nodeIdArray);
        return list.toArray(new UaReference[list.size()]);
    }

    protected List<UaReference> getReferencesAsList(Boolean bl, NodeId ... nodeIdArray) {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null) {
            for (UaReference uaReference : collection) {
                boolean bl2 = this.referenceTypeInherits(uaReference.getReferenceTypeId(), nodeIdArray);
                if (!bl2 || bl != null && uaReference.getIsInverse(this) != bl.booleanValue()) continue;
                arrayList.add(uaReference);
            }
        }
        return arrayList;
    }

    protected List<UaNode> getTargetNodes(NodeId uaReferenceArray) {
        uaReferenceArray = this.getForwardReferences(new NodeId[]{uaReferenceArray});
        ArrayList<UaNode> arrayList = new ArrayList<UaNode>(uaReferenceArray.length);
        for (UaReference uaReference : uaReferenceArray) {
            arrayList.add(uaReference.getTargetNode());
        }
        return arrayList;
    }

    protected UaReference hasReference(UaReference uaReference) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null && collection.contains(uaReference)) {
            return uaReference;
        }
        return null;
    }

    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        list.addAll(Arrays.asList(Attributes.NodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask));
    }

    protected boolean isFalseOrNull(Boolean bl) {
        return bl == null || bl == false;
    }

    protected boolean isMonitoredForEvents(UaObject uaObject) {
        List<EventListener> list = this.M();
        if (list != null) {
            for (EventListener uaReferenceArray : list) {
                if (!uaReferenceArray.isMonitored(uaObject)) continue;
                return true;
            }
        }
        boolean bl = false;
        for (UaReference uaReference : this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition)) {
            if (!((ServerNode)uaReference.getSourceNode()).isMonitoredForEvents(uaObject)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isTrueOrNull(Boolean bl) {
        return bl == null || bl != false;
    }

    protected final boolean isType() {
        return this.getNodeClass().equals((Object)NodeClass.ObjectType) || this.getNodeClass().equals((Object)NodeClass.VariableType) || this.getNodeClass().equals((Object)NodeClass.DataType) || this.getNodeClass().equals((Object)NodeClass.ReferenceType);
    }

    protected boolean referenceTypeInherits(NodeId nodeId, NodeId ... nodeIdArray) {
        try {
            UaReferenceType uaReferenceType = (UaReferenceType)this.nodeManager.getType(nodeId);
            return this.referenceTypeInherits(uaReferenceType, nodeIdArray);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (StatusException statusException) {
            if (nodeIdArray == null || nodeIdArray.length == 0) {
                return true;
            }
            for (NodeId nodeId2 : nodeIdArray) {
                if (!nodeId.equals((Object)nodeId2)) continue;
                return true;
            }
            return false;
        }
    }

    protected boolean referenceTypeInherits(UaReferenceType uaReferenceType, NodeId ... nodeIdArray) {
        if (nodeIdArray == null || nodeIdArray.length == 0) {
            return true;
        }
        for (NodeId nodeId : nodeIdArray) {
            if (uaReferenceType == null || !uaReferenceType.inheritsFrom(nodeId)) continue;
            return true;
        }
        return false;
    }

    protected NodeId[] translateBrowsePathToNodeIds(NodeId nodeId, QualifiedName ... relativePath) {
        BrowsePathTarget[] browsePathTargetArray;
        BrowsePathTarget[] browsePathTargetArray22;
        BrowsePathTarget browsePathTarget = new ArrayList();
        if (relativePath != null) {
            for (BrowsePathTarget[] browsePathTargetArray22 : relativePath) {
                browsePathTarget.add(new RelativePathElement(Identifiers.HierarchicalReferences, Boolean.valueOf(false), Boolean.valueOf(true), (QualifiedName)browsePathTargetArray22));
            }
        }
        RelativePath relativePath2 = new RelativePath(browsePathTarget.toArray(new RelativePathElement[0]));
        ArrayList<RelativePath> arrayList = new ArrayList<RelativePath>();
        try {
            browsePathTargetArray = this.getNodeManager().getNodeManagerTable().translateBrowsePathToNodeIds(nodeId, relativePath2);
        }
        catch (StatusException statusException) {
            browsePathTargetArray22 = statusException;
            if (statusException.getStatusCode().isStatusCode(StatusCodes.Bad_NoMatch)) {
                return new NodeId[0];
            }
            logger.warn("translateBrowsePathToNodeIds failed, startingNode=" + nodeId + " ,path=" + Arrays.toString((Object[])relativePath), (Throwable)browsePathTargetArray22);
            return new NodeId[0];
        }
        catch (Exception exception) {
            logger.warn("translateBrowsePathToNodeIds failed, startingNode=" + nodeId + " ,path=" + Arrays.toString((Object[])relativePath), (Throwable)exception);
            return new NodeId[0];
        }
        browsePathTargetArray22 = browsePathTargetArray;
        int n2 = browsePathTargetArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            browsePathTarget = browsePathTargetArray22[i2];
            if (browsePathTarget.getRemainingPathIndex() != null && !browsePathTarget.getRemainingPathIndex().equals((Object)UnsignedInteger.MAX_VALUE)) continue;
            browsePathTarget = browsePathTarget.getTargetId();
            try {
                relativePath2 = this.getNodeManager().getNamespaceTable().toNodeId((ExpandedNodeId)browsePathTarget);
                arrayList.add(relativePath2);
                continue;
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Could not translate ExpandedNodeId to NodeId: " + browsePathTarget, (Throwable)serviceResultException);
            }
        }
        return arrayList.toArray(new NodeId[0]);
    }

    protected void validateHasEventSourceChain(Set<NodeId> set) {
        if (!set.contains(this.getNodeId())) {
            UaReference uaReference;
            int n2;
            set.add(this.getNodeId());
            logger.trace("validateHasEventSourceChain: node={}", (Object)this);
            UaReference[] uaReferenceArray = this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition);
            UaReference uaReference2 = null;
            UaReference[] uaReferenceArray2 = uaReferenceArray;
            int n3 = uaReferenceArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                uaReference = uaReferenceArray2[n2];
                if (!uaReference.getSourceId().equals((Object)Identifiers.Server)) continue;
                uaReference2 = uaReference;
            }
            if (uaReference2 != null && uaReferenceArray.length > 1) {
                uaReference2.delete();
                uaReferenceArray = this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition);
            }
            uaReferenceArray2 = uaReferenceArray;
            n3 = uaReferenceArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                uaReference = uaReferenceArray2[n2];
                ((ServerNode)uaReference.getSourceNode()).validateHasEventSourceChain(set);
            }
            if (ServerNode.isAddNotifierReferencesToServerObject() && uaReferenceArray.length == 0 && !this.isType() && !this.getNodeId().equals((Object)Identifiers.Server)) {
                logger.debug("validateHasEventSourceChain: addReference from Server to node={}", (Object)this);
                this.addReference(UaServerReference.getReferenceInstance(Identifiers.HasNotifier, this.nodeManager.getNodeOrExternal(Identifiers.Server), (UaNode)this));
            }
        }
    }

    protected void validateHasEventSourceChain(UaReference hashSet) {
        if ((hashSet = (UaType)this.nodeManager.getNodeOrExternal(((UaReference)((Object)hashSet)).getReferenceTypeId())) != null && !(hashSet instanceof UaExternalNode) && hashSet.inheritsFrom(Identifiers.HasEventSource)) {
            hashSet = new HashSet<NodeId>();
            this.validateHasEventSourceChain(hashSet);
        }
    }

    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={}value={}", (Object)unsignedInteger, object);
        if (unsignedInteger.equals((Object)Attributes.NodeId)) {
            this.nodeId = (NodeId)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.NodeClass)) {
            throw new StatusException(StatusCodes.Bad_WriteNotSupported);
        }
        logger.info("writeAttributeValue: Invalid attribute {{}}: {}", this.getClass(), (Object)AttributesUtil.toString((UnsignedInteger)unsignedInteger));
        throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
    }
}

