/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.LoggerFactory;

public class PlainVariable<T>
extends UaVariableNode {
    private static final StatusCode bd = new StatusCode(StatusCodes.Bad_WaitingForInitialData);
    private volatile T eJ;
    private volatile DateTime serverTimestamp;
    private volatile UnsignedShort sourcePicoseconds = UnsignedShort.ZERO;
    private volatile DateTime sourceTimestamp = INITIALIZATION_TIME;
    private volatile StatusCode aj = bd;

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    public final T getCurrentValue() {
        return this.eJ;
    }

    public DateTime getServerTimestamp() {
        return this.serverTimestamp;
    }

    public DateTime getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    @Override
    public StatusCode getStatus() {
        return this.aj;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.eJ == null ? new DataValue(this.aj) : new DataValue(new Variant(this.eJ), this.aj);
        dataValue.setServerTimestamp(this.serverTimestamp);
        dataValue.setSourceTimestamp(this.sourceTimestamp);
        dataValue.setSourcePicoseconds(this.sourcePicoseconds);
        return dataValue;
    }

    public Class<?> getValueClass() {
        return this.eJ.getClass();
    }

    public boolean setCurrentValue(T t) {
        return this.setCurrentValue(t, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t, DateTime dateTime) {
        return this.setCurrentValue(t, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t, StatusCode structureArray, DateTime object, UnsignedShort unsignedShort) {
        boolean bl = !ObjectUtils.objectEquals(t, this.getCurrentValue());
        try {
            this.updateValue(t, (StatusCode)structureArray, (DateTime)object, unsignedShort);
            if (bl) {
                if (NodeId.isNull((NodeId)this.getDataTypeId())) {
                    if (t instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t).getTypeId()));
                    } else if (t.getClass().isArray() && !(structureArray = this.getValue()).isNull() && (object = structureArray.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])structureArray.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].getTypeId()));
                    }
                }
                if (this.getValueRank() == -2) {
                    if (t.getClass().isArray()) {
                        this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                        this.setValueRank(0);
                    } else {
                        this.setValueRank(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.aj = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.eJ = null;
            this.sourceTimestamp = null;
            this.serverTimestamp = DateTime.currentTime();
            return;
        }
        this.eJ = dataValue.isNull() ? null : dataValue.getValue().getValue();
        this.aj = dataValue.getStatusCode();
        this.sourceTimestamp = dataValue.getSourceTimestamp();
        this.sourcePicoseconds = dataValue.getSourcePicoseconds();
        this.serverTimestamp = dataValue.getServerTimestamp();
        if (this.serverTimestamp == null) {
            this.serverTimestamp = DateTime.currentTime();
        }
    }

    @Override
    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        super.updateValue(object, statusCode, dateTime, unsignedShort);
    }

    static {
        LoggerFactory.getLogger(PlainVariable.class);
    }
}

