/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.LoggerFactory;

public class PlainInstanceVariable<T>
extends InstanceVariable {
    private T eJ;
    private DateTime serverTimestamp;
    private UnsignedShort sourcePicoseconds = UnsignedShort.ZERO;
    private DateTime sourceTimestamp = INITIALIZATION_TIME;
    private StatusCode aj = new StatusCode(StatusCodes.Bad_WaitingForInitialData);

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        super(nodeManagerUaNode, nodeId, nodeId2);
    }

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId, uaVariable);
    }

    public final T getCurrentValue() {
        return this.eJ;
    }

    public DateTime getServerTimestamp() {
        return this.serverTimestamp;
    }

    public DateTime getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    @Override
    public StatusCode getStatus() {
        return this.aj;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.eJ == null ? new DataValue(this.aj) : new DataValue(new Variant(this.eJ), this.aj);
        dataValue.setServerTimestamp(this.serverTimestamp);
        dataValue.setSourceTimestamp(this.sourceTimestamp);
        dataValue.setSourcePicoseconds(this.sourcePicoseconds);
        return dataValue;
    }

    public Class<?> getValueClass() {
        if (this.eJ == null) {
            return null;
        }
        return this.eJ.getClass();
    }

    public boolean setCurrentValue(T t) {
        return this.setCurrentValue(t, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t, DateTime dateTime) {
        return this.setCurrentValue(t, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t, StatusCode structureArray, DateTime object, UnsignedShort unsignedShort) {
        boolean bl = !ObjectUtils.objectEquals(t, this.getCurrentValue());
        if (bl) {
            if (object == null) {
                object = DateTime.currentTime();
            }
            try {
                this.setValue(new DataValue(new Variant(t), (StatusCode)structureArray, object, unsignedShort, null, null));
            }
            catch (StatusException statusException) {
                throw new IllegalArgumentException(statusException);
            }
            if (NodeId.isNull((NodeId)this.getDataTypeId())) {
                try {
                    if (t instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t).getTypeId()));
                    } else if (t.getClass().isArray() && !(structureArray = this.getValue()).isNull() && (object = structureArray.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])structureArray.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].getTypeId()));
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (this.getValueRank() == -2) {
                if (t.getClass().isArray()) {
                    this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                    this.setValueRank(0);
                } else {
                    this.setValueRank(-1);
                }
            }
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.aj = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.eJ = null;
            this.sourceTimestamp = DateTime.currentTime();
            this.serverTimestamp = DateTime.currentTime();
            this.aj = StatusCode.BAD;
            return;
        }
        this.eJ = dataValue.isNull() ? null : dataValue.getValue().getValue();
        this.aj = dataValue.getStatusCode();
        this.sourceTimestamp = dataValue.getSourceTimestamp();
        this.sourcePicoseconds = dataValue.getSourcePicoseconds();
        this.serverTimestamp = dataValue.getServerTimestamp();
        if (this.serverTimestamp == null) {
            this.serverTimestamp = DateTime.currentTime();
        }
    }

    static {
        LoggerFactory.getLogger(PlainInstanceVariable.class);
    }
}

