/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FileTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=61")
public class FileFolderType
extends FolderTypeNode {
    private static Logger logger = LoggerFactory.getLogger(FileFolderType.class);
    private final Set<File> cw = new HashSet<File>();
    private File file;
    private String filter;
    private final Map<File, a> map = new ConcurrentSkipListMap<File, a>();
    private boolean writable;

    public static QualifiedName browseNameForFile(NodeManager nodeManager, File file) {
        return FileFolderType.browseNameForFile(nodeManager, file.getName());
    }

    public static QualifiedName browseNameForFile(NodeManager nodeManager, String string) {
        return new QualifiedName(nodeManager.getNamespaceIndex(), string);
    }

    public static NodeId nodeIdForFile(NodeManager nodeManager, File file) {
        return new NodeId(nodeManager.getNamespaceIndex(), file.getPath());
    }

    public FileFolderType(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
        this.initNodeVersion();
    }

    public FileFolderType(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string) {
        this(nodeManagerUaNode, nodeId, new QualifiedName(nodeManagerUaNode.getNamespaceIndex(), string), new LocalizedText(string));
        this.initNodeVersion();
    }

    public boolean addFile(File object) throws StatusException {
        logger.debug("addFile: file={}", object);
        if (((File)object).isDirectory()) {
            return this.a((File)object);
        }
        if (this.contains((File)object)) {
            this.nodeForFile((File)object).updateFileSize();
            return false;
        }
        NodeId nodeId = this.nodeIdForFile((File)object);
        UaNode uaNode = this.nodeManager.findNode(nodeId);
        if (uaNode == null) {
            object = this.nodeManager.createInstance(FileTypeNode.class, nodeId, this.browseNameForFile((File)object), this.displayNameForFile((File)object));
            this.nodeManager.addNode((UaNode)object);
            return this.addFile((FileTypeNode)object);
        }
        if (uaNode instanceof FileTypeNode) {
            return this.addFile((FileTypeNode)uaNode);
        }
        logger.error("Existing node for NodeId {} is not FileTypeNode, node={}", (Object)nodeId, (Object)uaNode);
        return false;
    }

    public boolean addFile(FileTypeNode fileTypeNode) throws StatusException {
        return this.addFile(fileTypeNode, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addFile(FileTypeNode baseObjectTypeNode, boolean bl) throws StatusException {
        BaseObjectTypeNode baseObjectTypeNode2;
        if (((FileTypeNode)baseObjectTypeNode).getFile() == null) {
            File file = new File(this.getFile(), baseObjectTypeNode.getBrowseName().getName());
            if (bl && !file.exists()) {
                file.getParentFile().mkdirs();
                try {
                    file.createNewFile();
                    file.setLastModified(0L);
                }
                catch (IOException iOException) {
                    logger.error("Could not create new file, {}", (Object)file);
                }
            }
            ((FileTypeNode)baseObjectTypeNode).setFile(file);
        }
        if (((FileFolderType)(baseObjectTypeNode = this)).contains((FileTypeNode)(baseObjectTypeNode2 = baseObjectTypeNode))) return false;
        ((FileTypeNode)baseObjectTypeNode2).setCurrentWritable(((FileFolderType)baseObjectTypeNode).isWritable());
        baseObjectTypeNode.addComponent(baseObjectTypeNode2);
        if (((FileFolderType)baseObjectTypeNode).map.put(((FileTypeNode)baseObjectTypeNode2).getFile(), new a((FileFolderType)baseObjectTypeNode, (FileTypeNode)baseObjectTypeNode2)) == null) return false;
        return true;
    }

    public boolean addFolder(FileFolderType fileFolderType) {
        if (!this.contains(fileFolderType)) {
            this.addReference((UaNode)fileFolderType, Identifiers.Organizes, false);
            fileFolderType.initNodeVersion();
            try {
                this.getNodeManager().addNode(fileFolderType);
            }
            catch (StatusException statusException) {
                logger.error("Could not add sub-node to nodemanager", (Throwable)statusException);
            }
            return this.map.put(fileFolderType.getFile(), new a(this, fileFolderType)) != null;
        }
        return false;
    }

    public QualifiedName browseNameForFile(File file) {
        return this.browseNameForFile(file.getName());
    }

    public QualifiedName browseNameForFile(String string) {
        return new QualifiedName(this.getNodeManager().getNamespaceIndex(), string);
    }

    public boolean contains(File file) {
        return this.map.containsKey(file);
    }

    public boolean contains(FileFolderType fileFolderType) {
        return this.map.containsKey(fileFolderType.getFile());
    }

    public boolean contains(FileTypeNode fileTypeNode) {
        return this.map.containsKey(fileTypeNode.getFile());
    }

    public LocalizedText displayNameForFile(File file) {
        return new LocalizedText(file.getName(), LocalizedText.NO_LOCALE);
    }

    public Set<File> getFailedFiles() {
        return this.cw;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean matchesFilter(File file) {
        return this.matchesFilter(file.getName());
    }

    public boolean matchesFilter(String string) {
        if (this.getFilter() == null || this.getFilter().isEmpty()) {
            return true;
        }
        for (String string2 : this.getFilter().split("\\s*,\\s*")) {
            string2 = "^" + string2.replace("?", ".?").replace("*", ".*?") + "$";
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    public FileTypeNode nodeForFile(File object) {
        if ((object = this.map.get(object)) == null) {
            return null;
        }
        return ((a)object).jP;
    }

    public NodeId nodeIdForFile(File file) {
        return new NodeId(this.getNodeManager().getNamespaceIndex(), file.getPath());
    }

    public void refresh() {
        if (logger.isDebugEnabled()) {
            logger.debug("FileFolderType.refresh for folder:" + this.getFile());
        }
        if (this.getFile() != null) {
            NodeManagerRoot nodeManagerRoot = this.getNodeManager().getServer().getNodeManagerRoot();
            nodeManagerRoot.beginModelChange();
            try {
                if (!this.getFile().exists()) {
                    Iterator<Map.Entry<File, a>> iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<File, a> entry = iterator.next();
                        if (entry.getValue().jP != null) {
                            this.removeFile(entry.getValue().jP);
                        }
                        if (entry.getValue().jO != null) {
                            this.removeFolder(entry.getValue().jO);
                        }
                        iterator.remove();
                    }
                } else {
                    ArrayList<File> object3 = new ArrayList<File>();
                    for (File file : this.getFile().listFiles()) {
                        if (!this.matchesFilter(file)) continue;
                        object3.add(file);
                    }
                    Iterator<Map.Entry<File, a>> iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object object = (Map.Entry)iterator.next();
                        if (!object3.contains(object.getKey())) {
                            if (((a)object.getValue()).jP != null) {
                                this.removeFile(((a)object.getValue()).jP);
                            }
                            if (((a)object.getValue()).jO != null) {
                                this.removeFolder(((a)object.getValue()).jO);
                            }
                            iterator.remove();
                            continue;
                        }
                        if (((a)object.getValue()).jP == null) continue;
                        object = ((a)object.getValue()).jP;
                        ((FileTypeNode)object).updateFileSize();
                    }
                    for (File file : object3) {
                        if (this.contains(file) || this.cw.contains(file)) continue;
                        try {
                            this.addFile(file);
                        }
                        catch (StatusException statusException) {
                            this.cw.add(file);
                            logger.warn("Failed to add file in refresh: " + file);
                        }
                    }
                    for (UaReference uaReference : this.getReferences(Identifiers.Organizes, false)) {
                        if (!(uaReference.getTargetNode() instanceof FileFolderType)) continue;
                        ((FileFolderType)uaReference.getTargetNode()).refresh();
                    }
                }
                return;
            }
            finally {
                nodeManagerRoot.endModelChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileTypeNode fileTypeNode) {
        FileTypeNode fileTypeNode2 = fileTypeNode;
        synchronized (fileTypeNode2) {
            if (fileTypeNode.getCurrentOpenCount() != 0) {
                return;
            }
            for (UaReference uaReference : this.getReferences(false, new NodeId[0])) {
                if (!uaReference.getTargetNode().equals(fileTypeNode)) continue;
                try {
                    this.getNodeManager().deleteNode(uaReference.getTargetNode(), true, true);
                }
                catch (StatusException statusException) {
                    logger.error("Could not delete node", (Throwable)statusException);
                }
            }
            this.map.remove(fileTypeNode.getFile());
            return;
        }
    }

    public void removeFolder(FileFolderType fileFolderType) {
        for (UaReference uaReference : this.getReferences(false, new NodeId[0])) {
            if (!uaReference.getTargetNode().equals(fileFolderType)) continue;
            try {
                this.getNodeManager().deleteNode(uaReference.getTargetNode(), true, true);
            }
            catch (StatusException statusException) {
                logger.error("Could not delete node", (Throwable)statusException);
            }
        }
        this.map.remove(fileFolderType.getFile());
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFile(String string) {
        this.setFile(new File(string));
    }

    public void setFilter(String string) {
        this.filter = string;
        this.refresh();
    }

    public void setWritable(boolean bl) {
        this.writable = bl;
    }

    private boolean a(File file) {
        if (logger.isDebugEnabled()) {
            logger.debug("addFolder: file=" + file);
        }
        if (!this.contains(file)) {
            UaNode uaNode;
            NodeId nodeId = this.nodeIdForFile(file);
            try {
                uaNode = this.nodeManager.getNode(nodeId);
                if (!(uaNode instanceof FileFolderType)) {
                    logger.error("A NodeId exists for the folder " + file + " already and it is not of type FileFolderType");
                    return false;
                }
                uaNode = (FileFolderType)uaNode;
            }
            catch (StatusException statusException) {
                uaNode = new FileFolderType(this.getNodeManager(), nodeId, this.browseNameForFile(file), this.displayNameForFile(file));
            }
            ((FileFolderType)uaNode).setFile(file);
            return this.addFolder((FileFolderType)uaNode);
        }
        return false;
    }

    private final class a {
        public final FileFolderType jO;
        public final FileTypeNode jP;

        public a(FileFolderType fileFolderType, FileFolderType fileFolderType2) {
            this.jO = fileFolderType2;
            this.jP = null;
        }

        public a(FileFolderType fileFolderType, FileTypeNode fileTypeNode) {
            this.jO = null;
            this.jP = fileTypeNode;
        }
    }
}

