/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackVariable
extends UaVariableNode {
    private static final Logger logger = LoggerFactory.getLogger(CallbackVariable.class);
    private DateTime ak = null;
    protected UaVariableCallback callback;

    public CallbackVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public CallbackVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    public UaVariableCallback getCallback() {
        return this.callback;
    }

    @Override
    public DataValue getValue() {
        if (this.callback != null) {
            try {
                Object object = this.callback.getValue();
                object = this.createDataValue(object);
                object.setServerTimestamp(DateTime.currentTime());
                CallbackVariable callbackVariable = this;
                if (callbackVariable.ak == null) {
                    callbackVariable.ak = DateTime.currentTime();
                }
                object.setSourceTimestamp(callbackVariable.ak);
                return object;
            }
            catch (StatusException statusException) {
                logger.error("StatusException: ", (Throwable)statusException);
                return new DataValue(statusException.getStatusCode());
            }
        }
        return null;
    }

    public void setCallback(UaVariableCallback uaVariableCallback) {
        this.callback = uaVariableCallback;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (this.callback != null) {
            this.callback.setValue(dataValue.getValue().getValue());
            this.ak = DateTime.currentTime();
        }
    }

    @Override
    protected void notifyValueChanging(DataValue dataValue) {
        super.notifyValueChanging(dataValue);
        this.ak = dataValue.getServerTimestamp();
    }
}

