/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackInstanceVariable
extends InstanceVariable {
    private static final Logger logger = LoggerFactory.getLogger(CallbackInstanceVariable.class);
    private DateTime sourceTimestamp = INITIALIZATION_TIME;
    protected UaVariableCallback callback;

    public CallbackInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        super(nodeManagerUaNode, nodeId, nodeId2);
    }

    public CallbackInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId, uaVariable);
    }

    public UaVariableCallback getCallback() {
        return this.callback;
    }

    @Override
    public DataValue getValue() {
        if (this.callback != null) {
            try {
                Object object = this.callback.getValue();
                object = object == null ? new DataValue(StatusCode.BAD) : new DataValue(new Variant(object));
                object.setServerTimestamp(DateTime.currentTime());
                object.setSourceTimestamp(this.sourceTimestamp);
                return object;
            }
            catch (StatusException statusException) {
                logger.error("StatusException: ", (Throwable)statusException);
                return new DataValue(statusException.getStatusCode());
            }
        }
        return null;
    }

    public void setCallback(UaVariableCallback uaVariableCallback) {
        this.callback = uaVariableCallback;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (this.callback != null) {
            this.callback.setValue(dataValue.getValue().getValue());
            this.sourceTimestamp = DateTime.currentTime();
        }
    }
}

