/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.LocalizedTextMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.CacheProperty;
import com.prosysopc.ua.server.nodes.CallbackInstanceProperty;
import com.prosysopc.ua.server.nodes.CallbackInstanceVariable;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import com.prosysopc.ua.server.nodes.PlainInstanceProperty;
import com.prosysopc.ua.server.nodes.PlainInstanceVariable;
import com.prosysopc.ua.server.nodes.PlainProperty;
import com.prosysopc.ua.server.nodes.PlainVariable;
import com.prosysopc.ua.server.nodes.ReflectiveInstanceProperty;
import com.prosysopc.ua.server.nodes.ReflectiveInstanceVariable;
import com.prosysopc.ua.server.nodes.ReflectiveProperty;
import com.prosysopc.ua.server.nodes.ReflectiveVariable;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.server.nodes.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNode
extends ServerNode {
    public static final QualifiedName NODE_VERSION_PROPERTY_NAME = new QualifiedName("NodeVersion");
    private static Map<Class<? extends BaseNode>, Map<String, NodeId>> jl = new HashMap<Class<? extends BaseNode>, Map<String, NodeId>>();
    private static final Logger logger = LoggerFactory.getLogger(BaseNode.class);
    private static Map<String, QualifiedName> jm;
    private static Map<String, LocalizedText> jn;
    private volatile QualifiedName cC;
    private volatile LocalizedTextMap cD = null;
    private volatile LocalizedTextMap cE = null;
    private volatile EnumSet<WriteAccess> cG = WriteAccess.NONE;
    private volatile EnumSet<WriteAccess> cH = WriteAccess.NONE;
    private Map<QualifiedName, UaProperty> cF = null;

    public static void setAccessLevelRecursively(UaNode uaReferenceArray, EnumSet<AccessLevel> enumSet, NodeId ... nodeIdArray) {
        if (uaReferenceArray instanceof UaVariable) {
            ((UaVariable)uaReferenceArray).setAccessLevel(enumSet);
        }
        if (nodeIdArray.length == 0) {
            nodeIdArray = new NodeId[]{Identifiers.Aggregates};
        }
        for (UaReference uaReference : uaReferenceArray.getForwardReferences(nodeIdArray)) {
            BaseNode.setAccessLevelRecursively(uaReference.getTargetNode(), enumSet, nodeIdArray);
        }
    }

    private static Map<String, NodeId> c(Class<? extends BaseNode> clazz) {
        return jl.get(clazz);
    }

    private static Map<String, NodeId> d(Class<? extends BaseNode> clazz) {
        Map<String, NodeId> map = BaseNode.c(clazz);
        if (map == null) {
            logger.debug("Creating InstanceProperties for {}", clazz);
            map = new HashMap<String, NodeId>();
            jl.put(clazz, map);
            if (BaseNode.class.isAssignableFrom(clazz.getSuperclass())) {
                Object object = clazz.getSuperclass();
                if ((object = BaseNode.d(object)) != null) {
                    logger.debug("Adding entries from the superMap {}", clazz);
                    map.putAll((Map<String, NodeId>)object);
                }
            }
        }
        return map;
    }

    protected static QualifiedName getStandardBrowseName(String string) {
        QualifiedName qualifiedName;
        if (jm == null) {
            jm = new HashMap<String, QualifiedName>();
        }
        if ((qualifiedName = jm.get(string)) == null) {
            qualifiedName = new QualifiedName(string);
            jm.put(string, qualifiedName);
        }
        return qualifiedName;
    }

    protected static LocalizedText getStandardDisplayText(String string) {
        LocalizedText localizedText;
        if (jn == null) {
            jn = new HashMap<String, LocalizedText>();
        }
        if ((localizedText = jn.get(string)) == null) {
            localizedText = new LocalizedText(string, Locale.ENGLISH);
            jn.put(string, localizedText);
        }
        return localizedText;
    }

    public BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        this(nodeManagerUaNode, nodeId);
        this.cC = qualifiedName;
        this.setDisplayName(localizedText);
    }

    public BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        this(nodeManagerUaNode, nodeId);
        this.cC = this.getDefaultBrowseName(nodeId, string);
        this.setDisplayName(new LocalizedText(string, locale));
    }

    protected BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId) {
        super(nodeManagerUaNode, nodeId);
    }

    public NodeId createNodeId(UaNode uaNode, String string) {
        return this.nodeManager.createNodeId(uaNode, string);
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        if (this.cF != null && nodeId.equals((Object)Identifiers.HasProperty) && !bl) {
            try {
                UaNode uaNode = this.getNodeManager().getNode(expandedNodeId);
                this.cF.remove(uaNode.getBrowseName());
            }
            catch (StatusException statusException) {
                throw new IllegalArgumentException(statusException);
            }
        }
        return super.deleteReference(expandedNodeId, nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        UaNode uaNode;
        UaReference uaReference2 = super.deleteReference(uaReference);
        if (this.cF != null && uaReference.getReferenceTypeId().equals((Object)Identifiers.HasProperty) && (uaNode = uaReference.getTargetNode()) != null && this.cF.remove(uaNode.getBrowseName()) != null) {
            uaReference2 = uaReference;
        }
        return uaReference2;
    }

    @Override
    public abstract NodeAttributes getAttributes();

    @Override
    public QualifiedName getBrowseName() {
        return this.cC;
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        for (UaReference uaReference : this.getReferences(Identifiers.HasComponent, false)) {
            UaNode object = uaReference.getTargetNode();
            if (object == null || !qualifiedName.equals((Object)object.getBrowseName())) continue;
            return object;
        }
        return null;
    }

    @Override
    public UaNode[] getComponents() {
        NodeId nodeId = Identifiers.HasComponent;
        return this.getTargetNodes(nodeId).toArray(new UaNode[0]);
    }

    @Override
    public LocalizedText getDescription() {
        return this.getDescription(null);
    }

    public LocalizedText getDescription(Locale locale) {
        if (this.cD != null) {
            return this.cD.getLocalizedText(locale);
        }
        return null;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.getDisplayName(null);
    }

    public LocalizedText getDisplayName(Locale locale) {
        if (this.cE != null) {
            return this.cE.getLocalizedText(locale);
        }
        return null;
    }

    @Override
    public UaMethod getMethod(QualifiedName qualifiedName) {
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public NodeClass getNodeClass() {
        return NodeClass.Unspecified;
    }

    @Override
    public UaProperty getNodeVersion() {
        return this.getProperty(NODE_VERSION_PROPERTY_NAME);
    }

    public String getNodeVersionValue() {
        UaProperty uaProperty = this.getNodeVersion();
        uaProperty = uaProperty == null ? null : uaProperty.getValue();
        if (uaProperty == null || uaProperty.isNull()) {
            return null;
        }
        return uaProperty.getValue().getValue().toString();
    }

    @Override
    public UaProperty[] getProperties() {
        Collection<UaProperty> collection = this.b(new ArrayList<UaReference>());
        if (collection != null) {
            return collection.toArray(new UaProperty[0]);
        }
        return null;
    }

    @Override
    public UaProperty getProperty(QualifiedName uaReferenceArray) {
        UaReference[] uaReferenceArray2;
        block5: {
            if (uaReferenceArray == null) {
                return null;
            }
            logger.debug("getProperty:{}", (Object)uaReferenceArray);
            ReflectiveInstanceProperty reflectiveInstanceProperty = this.a((QualifiedName)uaReferenceArray);
            if (reflectiveInstanceProperty != null) {
                return reflectiveInstanceProperty;
            }
            if (this.cF != null) {
                return this.cF.get(uaReferenceArray);
            }
            NodeId nodeId = Identifiers.HasProperty;
            reflectiveInstanceProperty = uaReferenceArray;
            uaReferenceArray = this;
            uaReferenceArray = uaReferenceArray.getForwardReferences(nodeId);
            int n2 = uaReferenceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                UaReference[] uaReferenceArray3 = uaReferenceArray[i2];
                if (!reflectiveInstanceProperty.equals(uaReferenceArray3.getTargetNode().getBrowseName())) continue;
                uaReferenceArray2 = uaReferenceArray3;
                break block5;
            }
            uaReferenceArray2 = uaReferenceArray = null;
        }
        if (uaReferenceArray2 != null) {
            return (UaProperty)uaReferenceArray.getTargetNode();
        }
        return null;
    }

    public DataValue getPropertyValue(QualifiedName qualifiedName) throws StatusException, IllegalArgumentException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        return uaProperty.getValue();
    }

    @Override
    public EnumSet<WriteAccess> getUserWriteMask() {
        return this.cG;
    }

    @Override
    public EnumSet<WriteAccess> getWriteMask() {
        return this.cH;
    }

    public boolean hasProperty(QualifiedName qualifiedName) {
        return this.getProperty(qualifiedName) != null;
    }

    public boolean hasTypeDefinition() {
        return false;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        return WriteAccess.hasAccessToAttribute(this.cG, unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        return WriteAccess.hasAccessToAttribute(this.cH, unsignedInteger);
    }

    public void incNodeVersion() throws NumberFormatException {
        String string = this.getNodeVersionValue();
        if (string != null) {
            string = Integer.valueOf(Integer.parseInt(string) + 1).toString();
            logger.debug("incNodeVersion: node={} nodeVersion={}", (Object)this.getNodeId(), (Object)string);
            this.setNodeVersionValue(string);
        }
    }

    public void initNodeVersion() {
        if (this.getNodeVersionValue() == null) {
            this.setNodeVersionValue("1");
        }
    }

    @Override
    public DataValue readAttribute(UnsignedInteger unsignedInteger) {
        DataValue dataValue = new DataValue();
        this.readAttribute(unsignedInteger, dataValue, null);
        return dataValue;
    }

    @Override
    public final void readAttribute(UnsignedInteger object, DataValue dataValue, Locale locale) {
        try {
            Locale locale2 = locale;
            DataValue dataValue2 = dataValue;
            locale = object;
            object = this;
            if (locale.equals(Attributes.DisplayName)) {
                dataValue2.setValue(new Variant((Object)((BaseNode)object).getDisplayName(locale2)));
            } else if (locale.equals(Attributes.Description)) {
                dataValue2.setValue(new Variant((Object)((BaseNode)object).getDescription(locale2)));
            } else {
                ((BaseNode)object).readAttributeValue((UnsignedInteger)locale, dataValue2);
            }
            if (dataValue2.getServerTimestamp() == null) {
                dataValue2.setServerTimestamp(new DateTime());
            }
            return;
        }
        catch (StatusException statusException) {
            dataValue.setStatusCode(statusException.getStatusCode());
            return;
        }
    }

    @Override
    public UaProperty removeProperty(QualifiedName object) {
        if (this.cF != null) {
            object = this.getProperty((QualifiedName)object);
            this.deleteReference((UaNode)object, Identifiers.HasProperty, false);
            return object;
        }
        return null;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            logger.warn("dataValue=null");
            this.writeAttributeValue(unsignedInteger, null, StatusCode.BAD, null, null);
            return;
        }
        Object object = dataValue.getStatusCode().isBad() || dataValue.isNull() ? null : dataValue.getValue().getValue();
        this.writeAttributeValue(unsignedInteger, object, dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds());
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setDescription(nodeAttributes.getDescription());
    }

    @Override
    public void setBrowseName(QualifiedName qualifiedName) {
        this.cC = qualifiedName;
    }

    @Override
    public void setDescription(LocalizedText localizedText) {
        if (localizedText == null) {
            localizedText = LocalizedText.NULL;
        }
        if (this.cD == null) {
            this.cD = new LocalizedTextMap(localizedText);
            return;
        }
        this.cD.setLocalizedText(localizedText);
    }

    @Override
    public void setDisplayName(LocalizedText localizedText) {
        if (this.cE == null) {
            this.cE = new LocalizedTextMap(localizedText);
            return;
        }
        this.cE.setLocalizedText(localizedText);
    }

    public void setNodeVersionValue(String string) {
        try {
            this.setPropertyValue(NODE_VERSION_PROPERTY_NAME, string);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CacheProperty cacheProperty = new CacheProperty(this.nodeManager, this.createNodeId(this, NODE_VERSION_PROPERTY_NAME.getName()), NODE_VERSION_PROPERTY_NAME, new LocalizedText(NODE_VERSION_PROPERTY_NAME.getName(), Locale.ENGLISH));
            if (this.addProperty(cacheProperty) == null) {
                throw new IllegalArgumentException("Cannot add NodeVersion property to node " + this);
            }
            cacheProperty.setDataTypeId(Identifiers.String);
            this.setNodeVersionValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void setPropertyValue(QualifiedName qualifiedName, Object object) throws StatusException, IllegalArgumentException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        if (object instanceof DataValue) {
            qualifiedName = (DataValue)object;
        } else {
            qualifiedName = object instanceof Variant ? (Variant)object : new Variant(object);
            qualifiedName = new DataValue((Variant)qualifiedName);
        }
        uaProperty.setValue((DataValue)qualifiedName);
    }

    @Override
    public void setUserWriteMask(EnumSet<WriteAccess> enumSet) {
        this.cG = enumSet;
    }

    @Override
    public void setWriteMask(EnumSet<WriteAccess> enumSet) {
        this.cH = enumSet;
    }

    @Override
    public String toString() {
        return super.toString() + ", BrowseName=" + this.cC;
    }

    @Override
    public final boolean writeAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (!this.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not supported by node type '%s'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), this.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
        if (!this.hasWriteAccess(unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not writable in node '%s(ID=%s)' WriteMask=%s", AttributesUtil.toString((UnsignedInteger)unsignedInteger), this.getClass(), this.getNodeId(), this.getWriteMask()), StatusCodes.Bad_NotWritable);
        }
        try {
            this.setAttribute(unsignedInteger, dataValue);
        }
        catch (ClassCastException classCastException) {
            throw new StatusException("Write failed", StatusCodes.Bad_TypeMismatch);
        }
        return true;
    }

    private ReflectiveInstanceProperty a(QualifiedName qualifiedName) {
        NodeId nodeId = BaseNode.c(this.getClass());
        if (nodeId != null) {
            nodeId = nodeId.get(qualifiedName.getName());
            logger.debug("getProperty: id={}", (Object)nodeId);
            if (nodeId != null) {
                try {
                    return this.createReflectiveInstanceProperty(qualifiedName.getName(), nodeId);
                }
                catch (Exception exception) {
                    logger.error("BaseNode.getInstanceProperty() Exception: ", (Throwable)exception);
                }
            }
        }
        return null;
    }

    private Collection<UaProperty> b(List<UaReference> arrayList) {
        Object object = this;
        if ((object = BaseNode.c(object.getClass())) != null) {
            logger.debug("getPropertiesAsList: instanceProperties.size()={}", (Object)object.size());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (UaReference object2 : arrayList) {
                QualifiedName qualifiedName = object2.getTargetNode().getBrowseName();
                if (qualifiedName.getNamespaceIndex() != 0) continue;
                arrayList2.add(qualifiedName.getName());
            }
            arrayList = new ArrayList<UaProperty>();
            for (Map.Entry entry : object.entrySet()) {
                object = (String)entry.getKey();
                if (arrayList2.contains(object)) continue;
                NodeId nodeId = (NodeId)entry.getValue();
                try {
                    ReflectiveInstanceProperty reflectiveInstanceProperty = this.createReflectiveInstanceProperty((String)object, nodeId);
                    if (reflectiveInstanceProperty.getValue().isNull() && !reflectiveInstanceProperty.isMandatory()) continue;
                    arrayList.add(reflectiveInstanceProperty);
                }
                catch (Exception exception) {
                    logger.error("While creating instanceProperty " + (String)object + " id=" + nodeId, (Throwable)exception);
                }
            }
            if (this.cF != null) {
                arrayList.addAll(this.cF.values());
            }
            logger.debug("getPropertiesAsList: p={}", arrayList);
            return arrayList;
        }
        if (this.cF != null) {
            return this.cF.values();
        }
        return null;
    }

    protected <T> PlainProperty<T> addPlainProperty(NodeId object, String string) {
        object = new PlainProperty(this.nodeManager, (NodeId)object, string, LocalizedText.NO_LOCALE);
        this.addProperty((UaProperty)object);
        return object;
    }

    protected <T> PlainVariable<T> addPlainVariable(NodeId object, String string) {
        object = new PlainVariable(this.nodeManager, (NodeId)object, string, LocalizedText.NO_LOCALE);
        this.addComponent((UaNode)object);
        return object;
    }

    protected void assertTypeSupport(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected void assertTypeSupport(NodeId nodeId) {
        if (nodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected NodeId createNodeId(UaNode uaNode, String string, int n2) {
        return this.nodeManager.createNodeId(uaNode, string, n2);
    }

    protected ReflectiveInstanceProperty createReflectiveInstanceProperty(String string, NodeId nodeId) throws SecurityException, NoSuchMethodException, StatusException {
        boolean bl = this.isChildOfType();
        NodeId nodeId2 = bl ? nodeId : this.createNodeId(this, string);
        return this.createReflectiveInstanceProperty(string, nodeId, nodeId2);
    }

    protected ReflectiveInstanceProperty createReflectiveInstanceProperty(String object, NodeId nodeId, NodeId nodeId2) throws SecurityException, NoSuchMethodException, StatusException {
        object = new ReflectiveInstanceProperty(this.nodeManager, nodeId2, (Object)this, (String)object, nodeId);
        ((ServerNode)object).addReference(new a(Identifiers.HasProperty, (UaNode)this, (UaNode)object));
        return object;
    }

    @Override
    protected boolean doAddProperty(UaProperty uaProperty) {
        if (uaProperty != null) {
            logger.debug("doAddProperty: {}", (Object)uaProperty.getBrowseName());
            if (this.hasProperty(uaProperty.getBrowseName())) {
                logger.warn("Property exists, but adding a new reference! " + this.getBrowseName() + " - " + uaProperty.getBrowseName());
                return false;
            }
            if (this.cF == null) {
                this.cF = new ConcurrentHashMap<QualifiedName, UaProperty>(2, 0.9f, 1);
            }
            this.cF.put(uaProperty.getBrowseName(), uaProperty);
            return false;
        }
        return false;
    }

    protected NodeAttributes getAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes.setDescription(this.getDescription());
        nodeAttributes.setDisplayName(this.getDisplayName());
        return nodeAttributes;
    }

    @Override
    protected List<UaReference> getReferencesAsList(Boolean bl, NodeId ... object) {
        List<UaReference> list;
        Object object2;
        List<UaReference> list2 = super.getReferencesAsList(bl, (NodeId)object);
        if (this.isFalseOrNull(bl) && this.referenceTypeInherits(Identifiers.HasProperty, (NodeId)object) && (object2 = (object = this).b(list = list2)) != null) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                UaProperty uaProperty = (UaProperty)object2.next();
                list.add(new a(Identifiers.HasProperty, (UaNode)object, (UaNode)uaProperty));
            }
        }
        logger.debug("getReferencesAsList({}): list={}", (Object)bl, list2);
        return list2;
    }

    @Override
    protected UaReference hasReference(UaReference object) {
        if (((UaReference)object).getReferenceTypeId().equals((Object)Identifiers.HasProperty) && !((UaReference)object).getIsInverse(this) && this.hasProperty(((UaReference)object).getTargetNode().getBrowseName())) {
            Object object2 = ((UaReference)object).getTargetNode().getBrowseName();
            object = this;
            if ((object2 = ((BaseNode)object).getProperty((QualifiedName)object2)) == null) {
                return null;
            }
            return new a(Identifiers.HasProperty, (UaNode)object, (UaNode)object2);
        }
        return super.hasReference((UaReference)object);
    }

    protected boolean isChildOfType() {
        return false;
    }

    protected void readAttributeValue(UnsignedInteger object, DataValue dataValue) throws StatusException {
        if (object.equals((Object)Attributes.NodeId)) {
            dataValue.setValue(new Variant((Object)this.getNodeId()));
            return;
        }
        if (object.equals((Object)Attributes.NodeClass)) {
            object = this.getNodeClass().getValue();
            dataValue.setValue(new Variant(object));
            return;
        }
        if (object.equals((Object)Attributes.BrowseName)) {
            dataValue.setValue(new Variant((Object)this.getBrowseName()));
            return;
        }
        if (object.equals((Object)Attributes.DisplayName)) {
            dataValue.setValue(new Variant((Object)this.getDisplayName()));
            return;
        }
        if (object.equals((Object)Attributes.Description)) {
            dataValue.setValue(new Variant((Object)this.getDescription()));
            return;
        }
        if (object.equals((Object)Attributes.WriteMask)) {
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(this.getWriteMask())));
            return;
        }
        if (object.equals((Object)Attributes.UserWriteMask)) {
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(this.getUserWriteMask())));
            return;
        }
        throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
    }

    protected CallbackInstanceProperty registerCallbackProperty(String object, NodeId nodeId, NodeId nodeId2, UaVariableCallback uaVariableCallback) throws StatusException {
        object = new CallbackInstanceProperty(this.nodeManager, this.createNodeId(this, (String)object), nodeId2);
        ((InstanceVariable)object).setDataTypeId(nodeId);
        ((CallbackInstanceVariable)object).setCallback(uaVariableCallback);
        this.addProperty((UaProperty)object);
        return object;
    }

    protected <T> PlainInstanceProperty<T> registerPlainInstanceProperty(String object, NodeId nodeId, NodeId nodeId2) throws StatusException {
        object = this.createNodeId(this, (String)object);
        object = new PlainInstanceProperty(this.nodeManager, (NodeId)object, nodeId);
        ((InstanceVariable)object).setDataTypeId(nodeId2);
        if (this.addProperty((UaProperty)object) == null) {
            throw new RuntimeException("Property " + ((InstanceVariable)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainInstanceProperty: {}", (Object)((InstanceVariable)object).getBrowseName());
        return object;
    }

    protected <T> PlainInstanceProperty<T> registerPlainInstanceProperty(String object, NodeId nodeId, T t) throws StatusException {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t.getClass());
        object = this.registerPlainInstanceProperty((String)object, nodeId, (T)uaDataType.getNodeId());
        ((PlainInstanceVariable)object).setCurrentValue(t);
        return object;
    }

    protected <T> PlainProperty<T> registerPlainProperty(String object, NodeId nodeId) {
        NodeId nodeId2 = this.createNodeId(this, (String)object);
        object = new PlainProperty(this.nodeManager, nodeId2, BaseNode.getStandardBrowseName((String)object), BaseNode.getStandardDisplayText((String)object));
        ((UaVariableNode)object).setDataTypeId(nodeId);
        if (this.addProperty((UaProperty)object) == null) {
            throw new RuntimeException("Variable " + ((BaseNode)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainProperty: {}", (Object)((BaseNode)object).getBrowseName());
        return object;
    }

    protected <T> PlainProperty<T> registerPlainProperty(String object, T t) {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t.getClass());
        object = this.registerPlainProperty((String)object, (T)uaDataType.getNodeId());
        ((PlainVariable)object).setCurrentValue(t);
        return object;
    }

    protected <T> PlainVariable<T> registerPlainVariable(String object, NodeId nodeId, NodeId nodeId2) {
        NodeId nodeId3 = this.createNodeId(this, (String)object);
        object = new PlainVariable(this.nodeManager, nodeId3, (String)object, Locale.ENGLISH);
        ((BaseNode)object).setBrowseName(new QualifiedName(0, ((BaseNode)object).getBrowseName().getName()));
        ((UaInstanceNode)object).setTypeDefinitionId(nodeId);
        ((UaVariableNode)object).setDataTypeId(nodeId2);
        if (this.addComponent((UaNode)object) == null) {
            throw new RuntimeException("Variable " + ((BaseNode)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainVariable: {}", (Object)((BaseNode)object).getBrowseName());
        return object;
    }

    protected <T> PlainVariable<T> registerPlainVariable(String object, NodeId nodeId, T t) {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t.getClass());
        object = this.registerPlainVariable((String)object, nodeId, (T)uaDataType.getNodeId());
        ((PlainVariable)object).setCurrentValue(t);
        return object;
    }

    protected void registerReflectiveInstanceProperty(String string, NodeId nodeId, NodeId nodeId2) throws IllegalArgumentException {
        try {
            try {
                this.getNodeManager().getNode(nodeId);
                BaseNode.d(this.getClass()).put(string, nodeId);
            }
            catch (StatusException statusException) {
                this.registerReflectiveProperty(nodeId, string, nodeId2);
                return;
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    protected ReflectiveInstanceVariable registerReflectiveInstanceVariable(NodeId object, String string, NodeId nodeId, NodeId nodeId2) throws SecurityException, NoSuchMethodException, StatusException {
        if (this.addComponent((UaNode)(object = new ReflectiveInstanceVariable(this.nodeManager, (NodeId)object, (Object)this, string, nodeId))) == null) {
            throw new RuntimeException("Component " + ((InstanceVariable)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveInstanceVariable: {}", (Object)((InstanceVariable)object).getBrowseName());
        return object;
    }

    protected ReflectiveProperty registerReflectiveProperty(NodeId object, String string, NodeId nodeId) throws SecurityException, NoSuchMethodException {
        object = new ReflectiveProperty(this.nodeManager, (NodeId)object, this, string, Locale.ENGLISH);
        ((UaVariableNode)object).setDataTypeId(nodeId);
        if (this.addProperty((UaProperty)object) == null) {
            throw new RuntimeException("Property " + ((BaseNode)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveVariable: {}", (Object)((BaseNode)object).getBrowseName());
        return object;
    }

    protected ReflectiveVariable registerReflectiveVariable(NodeId object, String string, NodeId nodeId) throws SecurityException, NoSuchMethodException {
        object = new ReflectiveVariable(this.nodeManager, (NodeId)object, this, string, Locale.ENGLISH);
        ((UaVariableNode)object).setDataTypeId(nodeId);
        if (this.addComponent((UaNode)object) == null) {
            throw new RuntimeException("Component " + ((BaseNode)object).getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveVariable: {}", (Object)((BaseNode)object).getBrowseName());
        return object;
    }

    protected void setAccessLevelRecursively(EnumSet<AccessLevel> enumSet) {
        BaseNode.setAccessLevelRecursively(this, enumSet, new NodeId[0]);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={}value={}", (Object)unsignedInteger, object);
        if (unsignedInteger.equals((Object)Attributes.BrowseName)) {
            this.cC = (QualifiedName)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.DisplayName)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.Description)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.WriteMask)) {
            if (object == null) {
                this.cH = WriteAccess.NONE;
                return;
            }
            if (object.getClass().equals(EnumSet.class)) {
                this.cH = (EnumSet)object;
                return;
            }
            this.cH = WriteAccess.getSet((UnsignedInteger)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserWriteMask)) {
            if (object == null) {
                this.cG = WriteAccess.NONE;
                return;
            }
            if (object.getClass().equals(EnumSet.class)) {
                this.cG = (EnumSet)object;
                return;
            }
            this.cG = WriteAccess.getSet((UnsignedInteger)object);
            return;
        }
        super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
    }
}

