/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.compliance;

import com.prosysopc.ua.server.compliance.CommonComplianceInfo;
import java.util.EnumSet;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.core.Identifiers;

public enum StaticData implements CommonComplianceInfo
{
    VARIANT("Variant", Identifiers.BaseDataType, Boolean.TRUE),
    BOOLEAN("Boolean", Identifiers.Boolean, Boolean.TRUE),
    BYTE("Byte", Identifiers.Byte, UnsignedByte.valueOf((int)0)),
    BYTE_STRING("ByteString", Identifiers.ByteString, new byte[]{0}),
    DATE_TIME("DateTime", Identifiers.DateTime, DateTime.currentTime()),
    DOUBLE("Double", Identifiers.Double, 0.0),
    FLOAT("Float", Identifiers.Float, Float.valueOf(0.0f)),
    GUID("GUID", Identifiers.Guid, UUID.randomUUID()),
    INT16("Int16", Identifiers.Int16, (short)0),
    INT32("Int32", Identifiers.Int32, 0),
    INT64("Int64", Identifiers.Int64, 0L),
    SBYTE("SByte", Identifiers.SByte, (byte)0),
    STRING("String", Identifiers.String, "TestString"),
    UINT16("UInt16", Identifiers.UInt16, UnsignedShort.valueOf((int)0)),
    UINT32("UInt32", Identifiers.UInt32, UnsignedInteger.valueOf((long)0L)),
    UINT64("UInt64", Identifiers.UInt64, UnsignedLong.valueOf((long)0L)),
    XML_ELEMENT("XmlElement", Identifiers.XmlElement, new XmlElement("<testElement />")),
    DURATION("Duration", Identifiers.Duration, 0.0),
    QUALIFIED_NAME("QualifiedName", Identifiers.QualifiedName, QualifiedName.DEFAULT_BINARY_ENCODING),
    LOCALIZED_TEXT("LocalizedText", Identifiers.LocalizedText, LocalizedText.english((String)"Test Text")),
    NODE_ID("NodeId", Identifiers.NodeId, Identifiers.NodeId),
    IMAGE("Image", Identifiers.Image, null),
    IMAGE_JPG("ImageJPG", Identifiers.ImageJPG, null),
    IMAGE_BMP("ImageBMP", Identifiers.ImageBMP, null),
    IMAGE_PNG("ImagePNG", Identifiers.ImagePNG, null),
    IMAGE_GIF("ImageGIF", Identifiers.ImageGIF, null),
    INTEGER("Integer", Identifiers.Integer, 1),
    LOCALE_ID("LocaleId", Identifiers.LocaleId, "en"),
    NUMBER("Number", Identifiers.Number, 1),
    UINTEGER("UInteger", Identifiers.UInteger, UnsignedInteger.valueOf((long)0L)),
    TIME("Time", Identifiers.Time, "10:10:10.100"),
    UTC_TIME("UtcTime", Identifiers.UtcTime, DateTime.currentTime()),
    ENUMERATION("Enumeration", Identifiers.Enumeration, null),
    VARIANT_ARRAY("Variant", Identifiers.BaseDataType, new Variant[]{new Variant((Object)Boolean.TRUE), new Variant((Object)Boolean.TRUE), new Variant((Object)Boolean.TRUE), new Variant((Object)Boolean.TRUE), new Variant((Object)Boolean.TRUE), new Variant((Object)Boolean.TRUE)}),
    LOCALIZED_TEXT_ARRAY("LocalizedText", Identifiers.LocalizedText, new LocalizedText[]{LocalizedText.english((String)"Text1"), LocalizedText.english((String)"Text2"), LocalizedText.english((String)"Text3"), LocalizedText.english((String)"Text4"), LocalizedText.english((String)"Text5"), LocalizedText.english((String)"Text6")}),
    QUALIFIED_NAME_ARRAY("QualifiedName", Identifiers.QualifiedName, new QualifiedName[]{QualifiedName.DEFAULT_BINARY_ENCODING, QualifiedName.DEFAULT_XML_ENCODING, QualifiedName.DEFAULT_BINARY_ENCODING, QualifiedName.DEFAULT_XML_ENCODING, QualifiedName.DEFAULT_BINARY_ENCODING, QualifiedName.DEFAULT_XML_ENCODING}),
    BOOLEAN_ARRAY("Boolean", Identifiers.Boolean, new Boolean[]{true, false, true, false, false}),
    BYTE_ARRAY("Byte", Identifiers.Byte, new UnsignedByte[]{UnsignedByte.valueOf((int)1), UnsignedByte.valueOf((int)2), UnsignedByte.valueOf((int)3), UnsignedByte.valueOf((int)4), UnsignedByte.valueOf((int)5)}),
    BYTE_STRING_ARRAY("ByteString", Identifiers.ByteString, new byte[][]{{1, 2, 3}, {2, 3, 4}, {3, 4, 5}, {4, 5, 6}, {5, 6, 7}}),
    DATA_TIME_ARRAY("DateTime", Identifiers.DateTime, new DateTime[]{DateTime.currentTime(), DateTime.currentTime(), DateTime.currentTime(), DateTime.currentTime(), DateTime.currentTime()}),
    DOUBLE_ARRAY("Double", Identifiers.Double, new Double[]{1.0, 2.0, 3.0, 4.0, 5.0}),
    DURATION_ARRAY("Duration", Identifiers.Duration, new Double[]{1.0, 2.0, 3.0, 4.0, 5.0}),
    FLOAT_ARRAY("Float", Identifiers.Float, new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)}),
    GUID_ARRAY("GUIDArray", Identifiers.Guid, new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()}),
    INT16_ARRAY("Int16", Identifiers.Int16, new Short[]{(short)1, (short)2, (short)3, (short)4, (short)5}),
    INT32_ARRAY("Int32", Identifiers.Int32, new Integer[]{1, 2, 3, 4, 5}),
    INT64_ARRAY("Int64", Identifiers.Int64, new Long[]{1L, 2L, 3L, 4L, 5L}),
    SBYTE_ARRAY("SByte", Identifiers.SByte, new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5}),
    STRING_ARRAY("String", Identifiers.String, new String[]{"testString1", "testString2", "testString3", "testString4", "testString5"}),
    UINT16_ARRAY("UInt16", Identifiers.UInt16, new UnsignedShort[]{UnsignedShort.valueOf((int)1), UnsignedShort.valueOf((int)2), UnsignedShort.valueOf((int)3), UnsignedShort.valueOf((int)4), UnsignedShort.valueOf((int)5)}),
    UINT32_ARRAY("UInt32", Identifiers.UInt32, new UnsignedInteger[]{UnsignedInteger.valueOf((long)1L), UnsignedInteger.valueOf((long)2L), UnsignedInteger.valueOf((long)3L), UnsignedInteger.valueOf((long)4L), UnsignedInteger.valueOf((long)5L)}),
    UINT64_ARRAY("UInt64", Identifiers.UInt64, new UnsignedLong[]{UnsignedLong.valueOf((long)1L), UnsignedLong.valueOf((long)2L), UnsignedLong.valueOf((long)3L), UnsignedLong.valueOf((long)4L), UnsignedLong.valueOf((long)5L)}),
    XML_ELEMENT_ARRAY("XmlElement", Identifiers.XmlElement, new XmlElement[]{new XmlElement("<testElement1 />"), new XmlElement("<testElement2 />"), new XmlElement("<testElement3 />"), new XmlElement("<testElement4 />"), new XmlElement("<testElement5 />")});

    public static final EnumSet<StaticData> DATA_ITEMS;
    public static final EnumSet<StaticData> STATIC_DATAS;
    public static final EnumSet<StaticData> ANALOG_ARRAY_ITEMS;
    public static final EnumSet<StaticData> STATIC_DATA_ARRAYS;
    private String cj;
    private NodeId ah;
    private Object initialValue;

    private StaticData(String string2, NodeId nodeId, Object object) {
        this.cj = string2;
        this.ah = nodeId;
        this.initialValue = object;
    }

    public final String getDataTypeName() {
        return this.cj;
    }

    @Override
    public final NodeId getDataTypeId() {
        return this.ah;
    }

    @Override
    public final Object getInitialValue() {
        return this.initialValue;
    }

    @Override
    public final String getBaseName() {
        return this.cj;
    }

    static {
        DATA_ITEMS = EnumSet.of(BOOLEAN, new StaticData[]{BYTE, BYTE_STRING, DATE_TIME, DOUBLE, FLOAT, GUID, INT16, INT32, INT64, SBYTE, STRING, UINT16, UINT32, UINT64, XML_ELEMENT});
        STATIC_DATAS = EnumSet.of(VARIANT, new StaticData[]{BOOLEAN, BYTE, UINT16, UINT32, UINT64, SBYTE, INT16, INT32, INT64, FLOAT, DOUBLE, DURATION, STRING, BYTE_STRING, LOCALIZED_TEXT, QUALIFIED_NAME, GUID, NODE_ID, DATE_TIME, XML_ELEMENT, IMAGE, IMAGE_JPG, IMAGE_PNG, IMAGE_BMP, IMAGE_GIF, LOCALE_ID, NUMBER, INTEGER, UINTEGER, TIME, UTC_TIME, ENUMERATION});
        ANALOG_ARRAY_ITEMS = EnumSet.of(BOOLEAN_ARRAY, new StaticData[]{BYTE_ARRAY, UINT16_ARRAY, UINT32_ARRAY, UINT64_ARRAY, SBYTE_ARRAY, INT16_ARRAY, INT32_ARRAY, INT64_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, DURATION_ARRAY, STRING_ARRAY, BYTE_STRING_ARRAY, DATA_TIME_ARRAY, GUID_ARRAY, XML_ELEMENT_ARRAY});
        STATIC_DATA_ARRAYS = EnumSet.of(VARIANT_ARRAY, new StaticData[]{BOOLEAN_ARRAY, BYTE_ARRAY, BYTE_STRING_ARRAY, DATA_TIME_ARRAY, DOUBLE_ARRAY, FLOAT_ARRAY, GUID_ARRAY, INT16_ARRAY, INT32_ARRAY, INT64_ARRAY, SBYTE_ARRAY, STRING_ARRAY, LOCALIZED_TEXT_ARRAY, QUALIFIED_NAME_ARRAY, UINT16_ARRAY, UINT32_ARRAY, UINT64_ARRAY, XML_ELEMENT_ARRAY});
    }
}

