/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.compliance;

import com.prosysopc.ua.EventNotifierClass;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.compliance.NonUaNodeDataItem;
import com.prosysopc.ua.server.compliance.StaticData;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonUaNodeComplianceNodeManager
extends NodeManager {
    private static final Logger logger = LoggerFactory.getLogger(NonUaNodeComplianceNodeManager.class);
    private final ExpandedNodeId in;
    private final ExpandedNodeId io;
    private final NonUaNodeIoManager ip;
    private final Map<String, NonUaNodeDataItem> map = new ConcurrentHashMap<String, NonUaNodeDataItem>();
    private final Map<String, Collection<MonitoredDataItem>> iq = new ConcurrentHashMap<String, Collection<MonitoredDataItem>>();

    public NonUaNodeComplianceNodeManager(UaServer object, String object22) {
        super((UaServer)((Object)object), (String)object22);
        this.io = new ExpandedNodeId(null, this.getNamespaceIndex(), (Object)"NonUaNodeDataItemType");
        this.in = new ExpandedNodeId(null, this.getNamespaceIndex(), (Object)"NonUaNodeComplianceTest");
        try {
            this.getNodeManagerTable().getNodeManagerRoot().getObjectsFolder().addReference(this.getNamespaceTable().toNodeId(this.in), Identifiers.Organizes, false);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
        for (StaticData staticData : StaticData.STATIC_DATAS) {
            NonUaNodeDataItem nonUaNodeDataItem = new NonUaNodeDataItem(this, staticData.getBaseName());
            nonUaNodeDataItem.setDataType(staticData.getDataTypeId());
            nonUaNodeDataItem.setValue(staticData.getInitialValue());
            this.map.put(nonUaNodeDataItem.getName(), nonUaNodeDataItem);
        }
        this.ip = new NonUaNodeIoManager(this, this);
    }

    public NonUaNodeIoManager getNonUaNodeIoManager() {
        return this.ip;
    }

    @Override
    public NodeId getVariableDataType(NodeId nodeId, UaValueNode uaValueNode) throws StatusException {
        if (nodeId == null) {
            nodeId = uaValueNode.getNodeId();
        }
        return this.j(nodeId).getDataType();
    }

    @Override
    public boolean hasNode(NodeId object) {
        if (this.map.containsKey(object = (String)object.getValue())) {
            return true;
        }
        return ((String)object).equals("NonUaNodeComplianceTest") || ((String)object).equals("NonUaNodeDataItemType");
    }

    public void notifyMonitoredDataItems(NonUaNodeDataItem nonUaNodeDataItem) {
        Collection<MonitoredDataItem> collection = this.iq.get(nonUaNodeDataItem.getName());
        if (collection != null) {
            for (MonitoredDataItem monitoredDataItem : collection) {
                DataValue dataValue = new DataValue();
                nonUaNodeDataItem.getDataValue(dataValue);
                monitoredDataItem.notifyDataChange(dataValue);
            }
        }
    }

    private NonUaNodeDataItem j(NodeId nodeId) {
        return this.map.get(nodeId.getValue());
    }

    private String b(ExpandedNodeId object) {
        String string = object.getValue().toString();
        if (this.getNamespaceTable().nodeIdEquals((ExpandedNodeId)object, this.io)) {
            string = "NonUaNodeDataItemType";
        }
        if (this.getNamespaceTable().nodeIdEquals((ExpandedNodeId)object, this.in)) {
            string = "NonUaNodeComplianceTest";
        } else {
            Object object2 = object;
            object = this;
            object = ((NonUaNodeComplianceNodeManager)object).map.get(object2 = (String)object2.getValue());
            if (object != null) {
                string = ((NonUaNodeDataItem)object).getName();
            }
        }
        return string;
    }

    @Override
    protected void afterCreateMonitoredDataItem(ServiceContext object, Subscription collection, MonitoredDataItem monitoredDataItem) {
        object = monitoredDataItem.getNodeId().getValue();
        collection = this.iq.get(object);
        if (collection == null) {
            collection = new CopyOnWriteArrayList<MonitoredDataItem>();
            this.iq.put((String)object, collection);
        }
        collection.add(monitoredDataItem);
        logger.debug("afterCreateMonitoredDataItem: nodeId=" + monitoredDataItem.getNodeId() + " c.size()=" + collection.size());
    }

    @Override
    protected void deleteMonitoredItem(ServiceContext object, Subscription collection, MonitoredItem monitoredItem) throws StatusException {
        object = monitoredItem.getNodeId().getValue();
        collection = this.iq.get(object);
        if (collection != null) {
            logger.debug("deleteMonitoredItem: collection size=" + collection.size());
            collection.remove(monitoredItem);
            if (collection.isEmpty()) {
                this.iq.remove(object);
                logger.debug("deleteMonitoredItem: monitoredItems size=" + this.iq.size());
            }
        }
    }

    @Override
    protected QualifiedName getBrowseName(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        return new QualifiedName(this.getNamespaceIndex(), this.b(expandedNodeId));
    }

    @Override
    protected LocalizedText getDisplayName(ExpandedNodeId expandedNodeId, UaNode uaNode, Locale locale) {
        return new LocalizedText(this.b(expandedNodeId), LocalizedText.NO_LOCALE);
    }

    @Override
    protected NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (this.getNamespaceTable().nodeIdEquals(expandedNodeId, this.io)) {
            return NodeClass.VariableType;
        }
        if (this.getNamespaceTable().nodeIdEquals(expandedNodeId, this.in)) {
            return NodeClass.Object;
        }
        return NodeClass.Variable;
    }

    @Override
    protected NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        return this.getNodeClass(this.getNamespaceTable().toExpandedNodeId(nodeId), uaNode);
    }

    @Override
    protected UaReference[] getReferences(NodeId nodeId, UaNode object) {
        try {
            if (nodeId.equals((Object)this.getNamespaceTable().toNodeId(this.io))) {
                return new UaReference[]{new NonUaNodeMyReference(this, new ExpandedNodeId(Identifiers.BaseDataVariableType), this.io, Identifiers.HasSubtype)};
            }
            if (nodeId.equals((Object)this.getNamespaceTable().toNodeId(this.in))) {
                UaReference[] uaReferenceArray = new UaReference[this.map.size() + 2];
                UaReference[] uaReferenceArray2 = uaReferenceArray;
                uaReferenceArray[0] = new NonUaNodeMyReference(this, new ExpandedNodeId(Identifiers.ObjectsFolder), this.in, Identifiers.Organizes);
                uaReferenceArray2[1] = new NonUaNodeMyReference(this, this.in, this.getTypeDefinition(this.getNamespaceTable().toExpandedNodeId(nodeId), (UaNode)object), Identifiers.HasTypeDefinition);
                int n2 = 2;
                for (NonUaNodeDataItem nonUaNodeDataItem : this.map.values()) {
                    uaReferenceArray2[n2] = new NonUaNodeMyReference(this, this.in, new ExpandedNodeId(null, this.getNamespaceIndex(), (Object)nonUaNodeDataItem.getName()), Identifiers.HasComponent);
                    ++n2;
                }
                return uaReferenceArray2;
            }
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
        NonUaNodeDataItem nonUaNodeDataItem = this.j(nodeId);
        if (nonUaNodeDataItem == null) {
            return null;
        }
        nodeId = new ExpandedNodeId(null, this.getNamespaceIndex(), (Object)nonUaNodeDataItem.getName());
        return new UaReference[]{new NonUaNodeMyReference(this, this.in, (ExpandedNodeId)nodeId, Identifiers.HasComponent), new NonUaNodeMyReference(this, (ExpandedNodeId)nodeId, this.io, Identifiers.HasTypeDefinition)};
    }

    @Override
    protected ExpandedNodeId getTypeDefinition(ExpandedNodeId expandedNodeId, UaNode object) {
        object = this.map.get(expandedNodeId.getValue());
        if (object != null) {
            return this.getNamespaceTable().toExpandedNodeId(((NonUaNodeDataItem)object).getDataType());
        }
        if (this.getNamespaceTable().nodeIdEquals(expandedNodeId, this.io)) {
            return null;
        }
        if (this.getNamespaceTable().nodeIdEquals(expandedNodeId, this.in)) {
            return this.getNamespaceTable().toExpandedNodeId(Identifiers.FolderType);
        }
        return this.io;
    }

    public class NonUaNodeMyReference
    extends UaReference {
        private final NodeId bu;
        private final ExpandedNodeId eE;
        private final ExpandedNodeId eF;
        private /* synthetic */ NonUaNodeComplianceNodeManager eO;

        public NonUaNodeMyReference(NonUaNodeComplianceNodeManager nonUaNodeComplianceNodeManager, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, NodeId nodeId) {
            this.eO = nonUaNodeComplianceNodeManager;
            this.eE = expandedNodeId;
            this.eF = expandedNodeId2;
            this.bu = nodeId;
        }

        public NonUaNodeMyReference(NonUaNodeComplianceNodeManager nonUaNodeComplianceNodeManager, NodeId nodeId, NodeId nodeId2, NodeId nodeId3) {
            this(nonUaNodeComplianceNodeManager, nonUaNodeComplianceNodeManager.getNamespaceTable().toExpandedNodeId(nodeId), nonUaNodeComplianceNodeManager.getNamespaceTable().toExpandedNodeId(nodeId2), nodeId3);
        }

        @Override
        public void delete() {
            throw new RuntimeException("StatusCodes.Bad_NotImplemented");
        }

        @Override
        public boolean getIsInverse(NodeId nodeId) {
            try {
                if (nodeId.equals((Object)this.eO.getNamespaceTable().toNodeId(this.eE))) {
                    return false;
                }
                if (nodeId.equals((Object)this.eO.getNamespaceTable().toNodeId(this.eF))) {
                    return true;
                }
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
            throw new RuntimeException("not a source nor target");
        }

        @Override
        public boolean getIsInverse(UaNode uaNode) {
            return this.getIsInverse(uaNode.getNodeId());
        }

        @Override
        public UaReferenceType getReferenceType() {
            try {
                return (UaReferenceType)this.eO.getNodeManagerTable().getNode(this.getReferenceTypeId());
            }
            catch (StatusException statusException) {
                throw new RuntimeException(statusException);
            }
        }

        @Override
        public NodeId getReferenceTypeId() {
            return this.bu;
        }

        @Override
        public ExpandedNodeId getSourceId() {
            return this.eE;
        }

        @Override
        public UaNode getSourceNode() {
            return null;
        }

        @Override
        public ExpandedNodeId getTargetId() {
            return this.eF;
        }

        @Override
        public UaNode getTargetNode() {
            return null;
        }
    }

    public class NonUaNodeIoManager
    extends IoManager {
        private /* synthetic */ NonUaNodeComplianceNodeManager eO;

        public NonUaNodeIoManager(NonUaNodeComplianceNodeManager nonUaNodeComplianceNodeManager, NodeManager nodeManager) {
            this.eO = nonUaNodeComplianceNodeManager;
            super(nodeManager);
        }

        @Override
        protected void readNonValue(ServiceContext object, Object object2, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
            object = this.eO.getNamespaceTable().toExpandedNodeId(nodeId);
            if (unsignedInteger.equals((Object)Attributes.NodeId)) {
                object = nodeId;
            } else if (unsignedInteger.equals((Object)Attributes.BrowseName)) {
                object = this.eO.getBrowseName((ExpandedNodeId)object, uaNode);
            } else if (unsignedInteger.equals((Object)Attributes.DisplayName)) {
                object = this.eO.getDisplayName((ExpandedNodeId)object, uaNode, null);
            } else if (unsignedInteger.equals((Object)Attributes.Description)) {
                object = null;
            } else if (unsignedInteger.equals((Object)Attributes.NodeClass)) {
                object = this.eO.getNodeClass((ExpandedNodeId)object, uaNode);
            } else if (unsignedInteger.equals((Object)Attributes.WriteMask)) {
                object = UnsignedInteger.ZERO;
            } else if (unsignedInteger.equals((Object)Attributes.DataType)) {
                object = this.eO.j(nodeId).getDataType();
            } else if (unsignedInteger.equals((Object)Attributes.ValueRank)) {
                object = -1;
            } else if (unsignedInteger.equals((Object)Attributes.ArrayDimensions)) {
                object = null;
            } else if (unsignedInteger.equals((Object)Attributes.AccessLevel)) {
                object = AccessLevel.getMask((Collection)AccessLevel.READWRITE);
            } else if (unsignedInteger.equals((Object)Attributes.Historizing)) {
                object = false;
            } else if (unsignedInteger.equals((Object)Attributes.EventNotifier) && "NonUaNodeComplianceTest".equals(nodeId.getValue())) {
                object = EventNotifierClass.getMask(EventNotifierClass.NONE);
            } else {
                throw new StatusException(new StatusCode(StatusCodes.Bad_AttributeIdInvalid));
            }
            dataValue.setValue(new Variant(object));
            dataValue.setServerTimestamp(DateTime.currentTime());
        }

        @Override
        protected void readValue(ServiceContext object, Object object2, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
            object = this.eO.j(nodeId);
            if (object == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
            }
            ((NonUaNodeDataItem)object).getDataValue(dataValue);
            IoManager.applyIndexRangeToReadValue(dataValue, numericRange);
        }

        @Override
        protected boolean writeValue(ServiceContext object, Object object2, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
            object = this.eO.j(nodeId);
            if (object == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
            }
            object2 = new DataValue();
            ((NonUaNodeDataItem)object).getDataValue((DataValue)object2);
            object2 = IoManager.applyIndexRangeToWriteValue((DataValue)object2, dataValue, numericRange);
            ((NonUaNodeDataItem)object).setValue(object2.getValue().getValue(), dataValue.getStatusCode());
            return true;
        }
    }
}

