/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.compliance;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeBuilderConfiguration;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.compliance.AnalogData;
import com.prosysopc.ua.server.compliance.CommonComplianceInfo;
import com.prosysopc.ua.server.compliance.MultiState;
import com.prosysopc.ua.server.compliance.StaticData;
import com.prosysopc.ua.server.compliance.TwoState;
import com.prosysopc.ua.server.compliance.a;
import com.prosysopc.ua.server.nodes.CacheVariable;
import com.prosysopc.ua.server.nodes.UaObjectNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.prosysopc.ua.types.opcua.DataItemType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.MultiStateDiscreteType;
import com.prosysopc.ua.types.opcua.TwoStateDiscreteType;
import java.util.EnumSet;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.EUInformation;
import org.opcfoundation.ua.core.Identifiers;

public class ComplianceNodeManager
extends NodeManagerUaNode {
    private FolderType gw;
    private FolderType gx;
    private FolderType gy;
    private FolderType gz;
    private FolderType gA;
    private FolderType gB;
    private UaObject gC;
    private FolderType gD;
    private FolderType gE;
    private FolderType gF;
    private FolderType gG;

    public ComplianceNodeManager(UaServer object, String iterator) {
        super((UaServer)object, (String)((Object)iterator));
        try {
            UaNode uaNode;
            Object object2;
            Enum enum_;
            object = this;
            ComplianceNodeManager object42 = object;
            ((ComplianceNodeManager)object).gC = object42.getServer().getNodeManagerRoot().getObjectsFolder();
            object42.gE = object42.a("ComplianceNodes", object42.gC);
            object42.gF = object42.a("StaticVariables", object42.gE);
            object42.gD = object42.a("StaticArrayVariables", object42.gE);
            object42.gz = object42.a("DataItems", object42.gE);
            object42.gy = object42.a("AnalogItems", object42.gE);
            object42.gx = object42.a("AnalogItemArrays", object42.gE);
            object42.gw = object42.a("AccessLevels", object42.gE);
            object42.gG = object42.a("TwoStateItems", object42.gE);
            object42.gB = object42.a("MultiStateItems", object42.gE);
            for (StaticData staticData : StaticData.STATIC_DATAS) {
                enum_ = staticData;
                Object object3 = object;
                object2 = ComplianceNodeManager.a((CommonComplianceInfo)((Object)enum_), "");
                uaNode = new CacheVariable((NodeManagerUaNode)object3, super.e((String)object2), (String)object2, Locale.ENGLISH);
                ((UaVariableNode)uaNode).setValue(new DataValue(new Variant(enum_.getInitialValue()), StatusCode.GOOD, new DateTime(), new DateTime()));
                ComplianceNodeManager.a((UaVariable)uaNode, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object3).gF);
            }
            for (StaticData staticData : StaticData.STATIC_DATA_ARRAYS) {
                enum_ = staticData;
                Object object4 = object;
                object2 = ComplianceNodeManager.a((CommonComplianceInfo)((Object)enum_), "Array");
                uaNode = ((ServiceManagerBase)object4).getServer().getNodeManagerRoot().getType(enum_.getDataTypeId());
                object2 = new CacheVariable((NodeManagerUaNode)object4, super.e((String)object2), (String)object2, Locale.ENGLISH);
                ((UaVariableNode)object2).setTypeDefinition((UaType)uaNode);
                ((UaVariableNode)object2).setValueRank(1);
                ((UaVariableNode)object2).setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                ((UaVariableNode)object2).setValue(new DataValue(new Variant(enum_.getInitialValue()), StatusCode.GOOD, new DateTime(), new DateTime()));
                ComplianceNodeManager.a((UaVariable)object2, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object4).gD);
            }
            for (StaticData staticData : StaticData.DATA_ITEMS) {
                enum_ = staticData;
                Object object5 = object;
                object2 = new NodeBuilderConfiguration();
                ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.DataItemType_Definition));
                uaNode = ((NodeManagerUaNode)object5).createNodeBuilder(DataItemType.class, (UaNodeBuilderConfiguration)object2).setName(((StaticData)enum_).getDataTypeName() + "DataItem").build();
                uaNode.setDefinition("Test definition of type " + ((StaticData)enum_).getDataTypeName());
                uaNode.setValue(ComplianceNodeManager.c(((StaticData)enum_).getInitialValue()));
                ComplianceNodeManager.a((UaVariable)uaNode, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object5).gz);
            }
            for (AnalogData analogData : AnalogData.ANALOG_ITEMS) {
                enum_ = analogData;
                Object object6 = object;
                object2 = new NodeBuilderConfiguration();
                ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.AnalogItemType_EngineeringUnits));
                ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.DataItemType_Definition));
                if (((AnalogData)enum_).getInstrumentRange() != null) {
                    ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.AnalogItemType_InstrumentRange));
                }
                uaNode = ((NodeManagerUaNode)object6).createNodeBuilder(AnalogItemType.class, (UaNodeBuilderConfiguration)object2).setName(((AnalogData)enum_).getDataTypeName() + "AnalogItem").build();
                uaNode.setDefinition("Test definition of type " + ((AnalogData)enum_).getDataTypeName());
                uaNode.setEngineeringUnits(new EUInformation("http://www.opcfoundation.org/UA/units/un/cefact", Integer.valueOf(5067858), new LocalizedText("m", Locale.ENGLISH), new LocalizedText("metre", Locale.ENGLISH)));
                uaNode.setEuRange(((AnalogData)enum_).getEURange());
                if (((AnalogData)enum_).getInstrumentRange() != null) {
                    uaNode.setInstrumentRange(((AnalogData)enum_).getInstrumentRange());
                }
                uaNode.setValue(new DataValue(new Variant(((AnalogData)enum_).getInitialValue()), StatusCode.GOOD, new DateTime(), new DateTime()));
                ComplianceNodeManager.a((UaVariable)uaNode, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object6).gy);
            }
            for (AnalogData analogData : AnalogData.ANALOG_ITEM_ARRAYS) {
                enum_ = analogData;
                Object object7 = object;
                object2 = new NodeBuilderConfiguration();
                ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.AnalogItemType_EngineeringUnits));
                ((NodeBuilderConfiguration)object2).addOptional(ComplianceNodeManager.d(Identifiers.DataItemType_Definition));
                uaNode = ((NodeManagerUaNode)object7).createNodeBuilder(AnalogItemType.class, (UaNodeBuilderConfiguration)object2).setName(((AnalogData)enum_).getDataTypeName() + "AnalogItemArray").build();
                uaNode.setDefinition("Test definition of type " + ((AnalogData)enum_).getDataTypeName() + " as array");
                uaNode.setValueRank(1);
                uaNode.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                uaNode.setEngineeringUnits(new EUInformation("http://www.opcfoundation.org/UA/units/un/cefact", Integer.valueOf(5067858), new LocalizedText("m", Locale.ENGLISH), new LocalizedText("metre", Locale.ENGLISH)));
                uaNode.setEuRange(((AnalogData)enum_).getEURange());
                uaNode.setValue(new DataValue(new Variant(((AnalogData)enum_).getInitialValue()), StatusCode.GOOD, new DateTime(), new DateTime()));
                ComplianceNodeManager.a((UaVariable)uaNode, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object7).gx);
            }
            ((ComplianceNodeManager)object).gA = ((NodeManagerUaNode)object).createNodeBuilder(FolderType.class).setName("DeepFolder").build();
            ((ComplianceNodeManager)object).gE.addReference(((ComplianceNodeManager)object).gA, Identifiers.Organizes, false);
            super.a(((ComplianceNodeManager)object).gA, 1, 20);
            super.a("AccessLevelCurrentReadWrite", AccessLevel.READWRITE, AccessLevel.READWRITE);
            super.a("AccessLevelCurrentRead", AccessLevel.READONLY, AccessLevel.READONLY);
            super.a("AccessLevelCurrentWrite", AccessLevel.WRITEONLY, AccessLevel.WRITEONLY);
            super.a("AccessLevelCurrentReadNotUser", AccessLevel.READONLY, AccessLevel.NONE);
            super.a("AccessLevelCurrentWriteNotUser", AccessLevel.WRITEONLY, AccessLevel.NONE);
            for (TwoState twoState : TwoState.TWOSTATE_ITEMS) {
                enum_ = twoState;
                Object object8 = object;
                object2 = ((NodeManagerUaNode)object8).createNodeBuilder(TwoStateDiscreteType.class).setName(((TwoState)enum_).getName()).build();
                object2.setTrueState(new LocalizedText(((TwoState)enum_).getTrueState(), ((NodeManager)object8).getDefaultLocale()));
                object2.setFalseState(new LocalizedText(((TwoState)enum_).getFalseState(), ((NodeManager)object8).getDefaultLocale()));
                object2.setValue(ComplianceNodeManager.c(((TwoState)enum_).getInitialValue()));
                ComplianceNodeManager.a((UaVariable)object2, (CommonComplianceInfo)((Object)enum_), ((ComplianceNodeManager)object8).gG);
            }
            for (MultiState multiState : MultiState.MULTISTATE_ITEMS) {
                super.a(multiState);
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize Compliance nodes", exception);
        }
    }

    private void a(UaNode object, int n2, int n3) {
        while (n2 <= n3) {
            Object object2 = String.format("DeepObject%02d", n2);
            object2 = new UaObjectNode((NodeManagerUaNode)this, new NodeId(this.getNamespaceIndex(), (String)object2), (String)object2, this.getDefaultLocale());
            this.addNodeAndReference((UaNode)object, (UaNode)object2, Identifiers.Organizes);
            ++n2;
            object = object2;
        }
    }

    private void a(String object, EnumSet<AccessLevel> enumSet, EnumSet<AccessLevel> enumSet2) throws StatusException {
        NodeId nodeId = new NodeId(this.getNamespaceIndex(), (String)object);
        UaType uaType = this.getServer().getNodeManagerRoot().getType(Identifiers.Int32);
        object = new CacheVariable((NodeManagerUaNode)this, nodeId, (String)object, Locale.ENGLISH);
        ((UaVariableNode)object).setDataType(uaType);
        ((UaVariableNode)object).setValueRank(1);
        ((UaVariableNode)object).setValue(new DataValue(new Variant((Object)0), StatusCode.GOOD, new DateTime(), new DateTime()));
        ((UaVariableNode)object).setAccessLevel(enumSet);
        ((UaVariableNode)object).setUserAccessLevel(enumSet2);
        this.gw.addReference((UaNode)object, Identifiers.HasComponent, false);
    }

    private FolderType a(String object, UaObject uaObject) throws UaInstantiationException, NodeBuilderException {
        object = this.createNodeBuilder(FolderType.class).setName((String)object).build();
        uaObject.addReference((UaNode)object, Identifiers.Organizes, false);
        return object;
    }

    private void a(MultiState multiState) throws StatusException, UaInstantiationException, NodeBuilderException {
        MultiStateDiscreteType multiStateDiscreteType = this.createNodeBuilder(MultiStateDiscreteType.class).setName(multiState.getName()).build();
        String[] stringArray = multiState.getStates();
        LocalizedText[] localizedTextArray = new LocalizedText[stringArray.length];
        for (int i2 = 0; i2 < localizedTextArray.length; ++i2) {
            localizedTextArray[i2] = new LocalizedText(stringArray[i2], this.getDefaultLocale());
        }
        multiStateDiscreteType.setValue(ComplianceNodeManager.c(multiState.getInitialValue()));
        multiStateDiscreteType.setEnumStrings(localizedTextArray);
        ComplianceNodeManager.a(multiStateDiscreteType, multiState, this.gB);
    }

    private NodeId e(String string) {
        return new NodeId(this.getNamespaceIndex(), string);
    }

    private static String a(CommonComplianceInfo commonComplianceInfo, String string) {
        return commonComplianceInfo.getBaseName() + string;
    }

    private static DataValue c(Object object) {
        return new DataValue(new Variant(object), StatusCode.GOOD, DateTime.currentTime(), UnsignedShort.ZERO, DateTime.currentTime(), UnsignedShort.ZERO);
    }

    private static void a(UaVariable uaVariable, CommonComplianceInfo commonComplianceInfo, FolderType folderType) throws StatusException {
        EnumSet<WriteAccess> enumSet = WriteAccess.getSupportedWriteAccess(a.a(uaVariable.getNodeClass()));
        enumSet.remove((Object)WriteAccess.NodeId);
        enumSet.remove((Object)WriteAccess.NodeClass);
        enumSet.remove((Object)WriteAccess.ArrayDimensions);
        enumSet.remove((Object)WriteAccess.AccessLevel);
        enumSet.remove((Object)WriteAccess.UserAccessLevel);
        enumSet.remove((Object)WriteAccess.BrowseName);
        enumSet.remove((Object)WriteAccess.DataType);
        enumSet.remove((Object)WriteAccess.WriteMask);
        enumSet.remove((Object)WriteAccess.UserWriteMask);
        uaVariable.setWriteMask(enumSet);
        uaVariable.setUserWriteMask(enumSet);
        if (!(commonComplianceInfo instanceof TwoState) && !(commonComplianceInfo instanceof MultiState)) {
            uaVariable.setDataTypeId(commonComplianceInfo.getDataTypeId());
        }
        folderType.addReference(uaVariable, Identifiers.HasComponent, false);
    }

    private static ExpandedNodeId d(NodeId nodeId) {
        return new ExpandedNodeId(NamespaceTable.OPCUA_NAMESPACE, nodeId.getValue());
    }
}

