/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.BrowsePath;
import com.prosysopc.ua.server.InstanceDeclaration;
import com.prosysopc.ua.server.InstanceDeclarationHierarchy;
import com.prosysopc.ua.server.InstantiationStrategy;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTypeInstanceDeclarationHierarchy {
    private static final Logger logger = LoggerFactory.getLogger(UaTypeInstanceDeclarationHierarchy.class);
    private final InstanceDeclaration eM;
    private InstantiationStrategy ja = null;
    private final Map<QualifiedName, UaTypeInstanceDeclarationHierarchy> map = new HashMap<QualifiedName, UaTypeInstanceDeclarationHierarchy>();
    private final HashSet<BrowsePath> jb = new HashSet();
    private final UaTypeNode jc;

    public static UaTypeInstanceDeclarationHierarchy fromUaType(UaTypeNode uaTypeNode) {
        InstanceDeclarationHierarchy instanceDeclarationHierarchy = uaTypeNode.getNodeManager().getNodeManagerTable().getInstanceDeclarationHierarchyCache().getForType(uaTypeNode);
        return new UaTypeInstanceDeclarationHierarchy(uaTypeNode, instanceDeclarationHierarchy.getRoot());
    }

    private UaTypeInstanceDeclarationHierarchy(UaTypeNode uaTypeNode, InstanceDeclaration instanceDeclaration) {
        this.jc = uaTypeNode;
        this.eM = instanceDeclaration;
        this.expand();
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(BrowsePath ... browsePathArray) {
        for (BrowsePath browsePath : browsePathArray) {
            this.jb.add(browsePath);
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(NodeId ... nodeIdArray) {
        if (nodeIdArray != null) {
            for (NodeId nodeId : nodeIdArray) {
                UaNode uaNode = this.jc.getNodeManager().getNodeManagerTable().findNode(nodeId);
                if (uaNode != null) {
                    this.addOptionalNodes(uaNode.getBrowseName());
                    continue;
                }
                logger.error("Could not find UaNode for NodeId " + nodeId);
            }
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(QualifiedName ... qualifiedNameArray) {
        if (qualifiedNameArray != null) {
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.addOptionalNodes(new BrowsePath(qualifiedName));
            }
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(String ... stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            for (String string : stringArray) {
                this.addOptionalNodes(new QualifiedName(string));
            }
        }
        return this;
    }

    public InstanceDeclaration getInstanceDeclaration() {
        return this.eM;
    }

    public InstantiationStrategy getInstantiationStrategy() {
        return this.ja;
    }

    public Collection<UaTypeInstanceDeclarationHierarchy> getNextLevel() {
        return this.map.values();
    }

    public void overrideInstantiationStrategy(BrowsePath browsePath, InstantiationStrategy instantiationStrategy) {
        if (browsePath == null || browsePath.isEmpty()) {
            throw new IllegalArgumentException("BrowsePath given is null");
        }
        if (browsePath.getSize() == 1) {
            this.ja = instantiationStrategy;
            return;
        }
        UaTypeInstanceDeclarationHierarchy uaTypeInstanceDeclarationHierarchy = this.map.get(browsePath.getFirst());
        if (uaTypeInstanceDeclarationHierarchy == null) {
            throw new IllegalArgumentException("No UaTypeInstanceDeclaration found for BrowsePath given");
        }
        uaTypeInstanceDeclarationHierarchy.overrideInstantiationStrategy(browsePath.removeFirst(), instantiationStrategy);
    }

    public void overrideInstantiationStrategy(NodeId object, InstantiationStrategy instantiationStrategy) {
        try {
            object = this.jc.getNodeManager().getNodeManagerTable().getNode((NodeId)object);
            this.overrideInstantiationStrategy(object.getBrowseName(), instantiationStrategy);
            return;
        }
        catch (StatusException statusException) {
            logger.error("Could not override instantiation strategy", (Throwable)statusException);
            return;
        }
    }

    public void overrideInstantiationStrategy(QualifiedName qualifiedName, InstantiationStrategy instantiationStrategy) {
        this.overrideInstantiationStrategy(new BrowsePath(qualifiedName), instantiationStrategy);
    }

    public void overrideInstantiationStrategy(String string, InstantiationStrategy instantiationStrategy) {
        this.overrideInstantiationStrategy(new QualifiedName(string), instantiationStrategy);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.ja = instantiationStrategy;
    }

    private void expand() {
        for (InstanceDeclaration instanceDeclaration : this.eM.getNextDeclarations()) {
            QualifiedName qualifiedName = instanceDeclaration.getNode().getBrowseName();
            this.map.put(qualifiedName, new UaTypeInstanceDeclarationHierarchy(this.jc, instanceDeclaration));
        }
    }
}

