/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CodegenModel;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.server.AttributeServiceHandler;
import com.prosysopc.ua.server.NodeManagementServiceHandler;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SessionServiceHandler;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.SubscriptionServiceHandler;
import com.prosysopc.ua.server.UaServerException;
import com.prosysopc.ua.server.UaServerListener;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.server.d;
import com.prosysopc.ua.server.f;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.prosysopc.ua.types.opcua.server.InformationModel;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.FindServersRequest;
import org.opcfoundation.ua.core.FindServersResponse;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.RegisterServerRequest;
import org.opcfoundation.ua.core.RegisterServerResponse;
import org.opcfoundation.ua.core.RegisteredServer;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.https.HttpsServer;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UaServer
extends UaApplication {
    private static final EnumSet<AccessLevel> READONLY = EnumSet.of(AccessLevel.CurrentRead);
    static Logger logger = LoggerFactory.getLogger(UaServer.class);
    private Set<InetAddress> fP = null;
    private final Map<UaApplication.Protocol, Set<InetAddress>> fQ = new HashMap<UaApplication.Protocol, Set<InetAddress>>();
    private boolean fR = true;
    private final AtomicReference<DiscoveryServer> fS = new AtomicReference<Object>(null);
    private UaAddress fT = null;
    private long fU = 10L;
    private boolean fV = false;
    private EndpointConfiguration endpointConfiguration = EndpointConfiguration.defaults();
    private List<EndpointDescription> fW;
    private boolean fX = true;
    private volatile boolean fY = true;
    private final Set<String> fZ = new HashSet<String>();
    private HttpsSettings httpsSettings = new HttpsSettings();
    private int ga = 10;
    private boolean initialized = false;
    private final Map<UaApplication.Protocol, Integer> gb = new TreeMap<UaApplication.Protocol, Integer>();
    private volatile boolean running;
    private final Server server = Server.createServerApplication();
    private String serverName = "";
    private final Map<UaApplication.Protocol, String> gc = new TreeMap<UaApplication.Protocol, String>();
    private boolean gd;
    private boolean ge = true;
    private boolean gf = true;
    private boolean gg = false;
    private final List<UserTokenPolicy> userTokenPolicies = new ArrayList<UserTokenPolicy>();
    private UserValidator gh;
    protected ApplicationIdentity applicationIdentity;
    protected ServiceHandler attributeServiceHandler;
    protected Set<String> discoveryUris;
    protected Set<String> httpsUris;
    protected UaServerListener listener;
    protected NodeManagerRoot nodeManagerRoot;
    protected NodeManagerTable nodeManagerTable;
    protected NodeManagerUaServer nodeManagerUaServer;
    protected NodeManagementServiceHandler nodeServiceHandler;
    protected SecurityMode[] securityModes = SecurityMode.ALL;
    protected Set<String> serverUris;
    protected SessionManager sessionManager;
    protected final SessionManagerListener sessionManagerListener = new d(this);
    protected SessionServiceHandler sessionServiceHandler;
    protected SubscriptionManager subscriptionManager;
    protected SubscriptionServiceHandler subscriptionServiceHandler;
    private a gi;
    private Timer gj = null;

    public static UnsignedByte getEndpointSecurityLevel(SecurityMode object) {
        int n2 = (object.getMessageSecurityMode().getValue() - 1) * 3;
        object = object.getSecurityPolicy().getPolicyUri();
        int n3 = 0;
        if (((String)object).equals("http://opcfoundation.org/UA/SecurityPolicy#None") || ((String)object).equals("http://opcfoundation.org/UA-Profile/Securitypolicy/None")) {
            n3 = 0;
        } else if (((String)object).equals("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15") || ((String)object).equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic128Rsa15")) {
            n3 = 1;
        } else if (((String)object).equals("http://opcfoundation.org/UA/SecurityPolicy#Basic256") || ((String)object).equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic128Rsa15")) {
            n3 = 2;
        }
        return UnsignedByte.valueOf((int)(n2 * n3));
    }

    protected static RegisteredServer toRegisteredServer(String string, boolean bl, UaServer uaServer) {
        uaServer = uaServer.getApplicationIdentity().getApplicationDescription();
        logger.debug("toRegisteredServer: d={}", (Object)uaServer);
        string = new RegisteredServer(uaServer.getApplicationUri(), uaServer.getProductUri(), new LocalizedText[]{uaServer.getApplicationName()}, uaServer.getApplicationType(), uaServer.getGatewayServerUri(), uaServer.getDiscoveryUrls(), string, Boolean.valueOf(bl));
        return string;
    }

    public UaServer() {
        this.registerModel(InformationModel.MODEL);
        ArrayList<Class<? extends UaInstance>> arrayList = new ArrayList<Class<? extends UaInstance>>();
        arrayList.add(BaseVariableTypeNode.class);
        arrayList.add(BaseObjectTypeNode.class);
        this.registerClasses(arrayList);
    }

    public void addEndpoint(String string, SecurityMode securityMode, UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException("Cannot define endpoints when running");
        }
        userTokenPolicyArray = userTokenPolicyArray.length > 0 ? userTokenPolicyArray : this.getUserTokenPolicies();
        this.fW.add(new EndpointDescription(string, this.getApplicationIdentity().getApplicationDescription(), this.getApplicationIdentity().getCertificate().getEncoded(), securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), userTokenPolicyArray, null, UaServer.getEndpointSecurityLevel(securityMode)));
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(" [");
            for (UserTokenPolicy userTokenPolicy : userTokenPolicyArray) {
                stringBuilder.append(userTokenPolicy.getTokenType());
                stringBuilder.append(",");
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
            logger.debug("Endpoint added: {} {} {}", new Object[]{string, securityMode, stringBuilder});
        }
    }

    public String[] addEndpointHost(String string) throws UaServerException {
        int n2;
        int n3;
        String string2;
        if (this.serverUris == null) {
            throw new RuntimeException("Cannot call addEndpointHost() before UaServer.init() is called");
        }
        int n4 = this.getPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n4 > 0) {
            string2 = UaServer.formatUri(UaApplication.Protocol.OpcTcp, string, n4, this.getServerName(UaApplication.Protocol.OpcTcp));
            this.serverUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                SecurityMode[] securityModeArray = this.securityModes;
                n3 = this.securityModes.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    SecurityMode securityMode = securityModeArray[i2];
                    this.addEndpoint(string2, securityMode, this.getUserTokenPolicies());
                }
            }
            if (this.getServerName(UaApplication.Protocol.OpcTcp) != null) {
                this.discoveryUris.add(UaServer.formatUri(UaApplication.Protocol.OpcTcp, string, n4, null));
            }
        }
        if ((n2 = this.getPort(UaApplication.Protocol.Https)) > 0) {
            string2 = UaServer.formatUri(UaApplication.Protocol.Https, string, n2, this.getServerName(UaApplication.Protocol.Https));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.Https) != null) {
                this.discoveryUris.add(UaServer.formatUri(UaApplication.Protocol.Https, string, n2, null));
            }
        }
        if ((n3 = this.getPort(UaApplication.Protocol.Http)) > 0) {
            string2 = UaServer.formatUri(UaApplication.Protocol.Http, string, n3, this.getServerName(UaApplication.Protocol.Http));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.Http) != null) {
                this.discoveryUris.add(UaServer.formatUri(UaApplication.Protocol.Http, string, n3, null));
            }
        }
        this.fZ.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addLocale(Locale locale) throws UaServerException {
        this.c("Locales");
        this.server.getApplication().addLocale(locale);
    }

    public void addServiceHandler(Object object) {
        logger.debug("addServiceHandler {}: {}", (Object)this.server, object);
        this.server.addServiceHandler(object);
    }

    public void addToServerArray(String string) throws StatusException {
        this.getAddressSpace().getServerTable().add(-1, string);
        this.updateServerArray();
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.c("UserTokenPolicies");
        if (!this.userTokenPolicies.contains(userTokenPolicy)) {
            this.userTokenPolicies.add(userTokenPolicy);
        }
    }

    public synchronized void close() {
        if (this.initialized) {
            try {
                if (this.running) {
                    this.shutdown(0, "");
                }
                this.aF();
                this.nodeManagerTable.close();
                this.server.close();
                System.out.println("UaServer closed.");
                return;
            }
            finally {
                this.initialized = false;
            }
        }
    }

    @Override
    public NodeManagerTable getAddressSpace() {
        return this.nodeManagerTable;
    }

    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public ServiceHandler getAttributeServiceHandler() {
        return this.attributeServiceHandler;
    }

    public Set<InetAddress> getBindAddresses() {
        if (this.fP == null) {
            try {
                return EndpointUtil.getInetAddresses((boolean)this.isEnableIPv6());
            }
            catch (SocketException socketException) {
                logger.warn("Cannot initialize bindAddresses", (Throwable)socketException);
                return null;
            }
        }
        return this.fP;
    }

    public Set<InetAddress> getBindAddresses(UaApplication.Protocol object) {
        if ((object = this.fQ.get(object)) != null) {
            return object;
        }
        return this.getBindAddresses();
    }

    public UaAddress getDiscoveryServerAddress() {
        return this.fT;
    }

    public long getDiscoveryServerRegistrationPeriod() {
        return this.fU;
    }

    public String getDiscoveryServerUrl() {
        if (this.fT == null) {
            return "";
        }
        if (this.fT.getAddress() == null) {
            return "";
        }
        return this.fT.getAddress();
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.server.getEncoderContext();
    }

    public EndpointDescription getEndpoint(String string, SecurityMode securityMode) {
        for (EndpointDescription endpointDescription : this.fW) {
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals((Object)securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            return endpointDescription;
        }
        return null;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public EndpointDescription[] getEndpoints() {
        return this.server.getEndpointDescriptions();
    }

    public EndpointDescription[] getEndpoints(String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : this.getEndpoints()) {
            if (!endpointDescription.getEndpointUrl().equals(string)) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public String[] getHostNames() {
        if (this.fZ.isEmpty()) {
            try {
                this.getServerUris();
            }
            catch (UaServerException uaServerException) {}
        }
        return this.fZ.toArray(new String[this.fZ.size()]);
    }

    public HttpsSettings getHttpsSettings() {
        return this.httpsSettings;
    }

    public int getHttpsWorkerThreadCount() {
        return this.ga;
    }

    public UaServerListener getListener() {
        return this.listener;
    }

    public Locale[] getLocales() {
        return this.server.getApplication().getLocales();
    }

    public NodeManagementServiceHandler getNodeManagementServiceHandler() {
        return this.nodeServiceHandler;
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.nodeManagerRoot;
    }

    @Deprecated
    public UaAddressSpace getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public NodeManagerUaServer getNodeManagerUaServer() {
        return this.nodeManagerUaServer;
    }

    public int getPort() {
        return this.getPort(UaApplication.Protocol.OpcTcp);
    }

    public int getPort(UaApplication.Protocol protocol) {
        if (this.gb.containsKey((Object)protocol)) {
            return this.gb.get((Object)protocol);
        }
        return 0;
    }

    public SecurityMode[] getSecurityModes() {
        return this.securityModes;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerName(UaApplication.Protocol protocol) {
        if (this.gc.containsKey((Object)protocol)) {
            return this.gc.get((Object)protocol);
        }
        return this.getServerName();
    }

    public String[] getServerUris() throws UaServerException {
        if (this.serverUris == null) {
            this.serverUris = new HashSet<String>();
            this.discoveryUris = new HashSet<String>();
            this.httpsUris = new HashSet<String>();
            String string = ApplicationIdentity.getActualHostName();
            this.addEndpointHost(string);
            this.serverUris.addAll(this.httpsUris);
        }
        return this.serverUris.toArray(new String[this.serverUris.size()]);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SessionServiceHandler getSessionServiceHandler() {
        return this.sessionServiceHandler;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public SubscriptionServiceHandler getSubscriptionServiceHandler() {
        return this.subscriptionServiceHandler;
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[this.userTokenPolicies.size()]);
    }

    public synchronized void init() throws UaServerException {
        if (!this.initialized) {
            if (this.applicationIdentity == null) {
                throw new NullPointerException("ApplicationIdentity must be defined before calling init or start");
            }
            if (this.fY) {
                this.aG();
            }
            this.aI();
            this.aH();
            if (this.fY) {
                this.initServiceHandlers();
            } else {
                try {
                    this.nodeServiceHandler.init();
                }
                catch (UaNodeFactoryException uaNodeFactoryException) {
                    throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
                }
                catch (StatusException statusException) {
                    throw new UaServerException("Failed to initialize UaServer", statusException);
                }
            }
            try {
                UaServer uaServer = this;
                BuildInfoTypeNode buildInfoTypeNode = uaServer.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
                if (buildInfoTypeNode.getProductUri() == null) {
                    buildInfoTypeNode.setProductUri(uaServer.getApplicationIdentity().getApplicationDescription().getProductUri());
                }
                if (buildInfoTypeNode.getProductName() == null) {
                    buildInfoTypeNode.setProductName(uaServer.getApplicationIdentity().getApplicationDescription().getApplicationName().getText());
                }
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to initialize UaServer, e");
            }
            if (this.fY) {
                try {
                    this.addToServerArray(this.applicationIdentity.getApplicationDescription().getApplicationUri());
                }
                catch (StatusException statusException) {
                    throw new UaServerException("Failed to add server to server array.", statusException);
                }
            }
            try {
                this.updateServerArray();
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to initialize UaServer", statusException);
            }
            this.aK();
            this.registerServer(false);
            this.initialized = true;
            this.fY = false;
        }
    }

    public boolean isDiscoveryEndpointEnabled() {
        return this.fR;
    }

    public boolean isEnableIPv6() {
        return this.fV;
    }

    public boolean isFailOnBindError() {
        return this.fX;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Deprecated
    public boolean isUseAllIpAddresses() {
        return this.gd;
    }

    @Deprecated
    public boolean isUseCanonicalHostName() {
        return this.ge;
    }

    @Deprecated
    public boolean isUseHostName() {
        return this.gf;
    }

    @Deprecated
    public boolean isUseLocalhost() {
        return this.gg;
    }

    public void registerAndLoadModel(CodegenModel codegenModel, URI uRI) throws SAXException, IOException, ModelException, ServiceException {
        this.registerModel(codegenModel);
        this.getAddressSpace().loadModel(uRI);
    }

    public boolean registerServer(boolean bl) {
        if (this.isDiscoveryEndpointEnabled()) {
            this.getDiscoveryServer().registerServer(this, null, bl);
            if (!this.getDiscoveryServerUrl().isEmpty()) {
                try {
                    String string = bl ? "online" : "offline";
                    this.registerServer(this.getDiscoveryServerUrl(), bl);
                    logger.info("Registered server {} to DiscoveryServerUrl={}", (Object)string, (Object)this.getDiscoveryServerUrl());
                    if (this.listener != null) {
                        this.listener.onRegisterServer(this.getDiscoveryServerUrl(), bl);
                    }
                    return true;
                }
                catch (UaServerException uaServerException) {
                    this.logRegisterServerError(this.getDiscoveryServerUrl(), bl, uaServerException);
                }
            }
        }
        return false;
    }

    public void registerServer(String object, boolean bl) throws UaServerException {
        UaServer uaServer;
        if (!bl) {
            uaServer = this;
            if (uaServer.gj != null) {
                uaServer.gj.cancel();
                uaServer.gj = null;
                logger.debug("discoveryRegistrationTimer canceled");
            }
        }
        if (this.applicationIdentity.getCertificate().getCertificate() == null) {
            throw new UaServerException("Application Certificate not defined when calling registerServer");
        }
        uaServer = UaServer.toRegisteredServer(null, bl, this);
        try {
            object = new UaClient((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UaServerException("Invalid URI", uRISyntaxException);
        }
        ApplicationIdentity applicationIdentity = this.getApplicationIdentity();
        ((UaClient)object).setApplicationIdentity(applicationIdentity);
        ((UaClient)object).setSecurityMode(SecurityMode.BASIC128RSA15_SIGN_ENCRYPT);
        ((UaClient)object).setTimeout(10000L);
        String string = bl ? "online" : "offline";
        try {
            ((UaClient)object).sessionlessRequest((ServiceRequest)new RegisterServerRequest(null, (RegisteredServer)uaServer));
            if (logger.isDebugEnabled()) {
                logger.debug("Registered server ({}) to Discovery Server at {}", (Object)string, (Object)((UaClient)object).getEndpoint().getEndpointUrl());
            }
            return;
        }
        catch (ServerConnectionException serverConnectionException) {
            throw new UaServerException("Could not register server (" + string + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serverConnectionException);
        }
        catch (ServiceException serviceException) {
            throw new UaServerException("Could not register server (" + string + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serviceException);
        }
    }

    public void removeEndpoint(String string, SecurityMode securityMode) {
        for (int i2 = this.fW.size() - 1; i2 >= 0; --i2) {
            EndpointDescription endpointDescription = this.fW.get(i2);
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals((Object)securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            this.fW.remove(i2);
        }
    }

    public void removeLocale(Locale locale) throws UaServerException {
        this.c("Locales");
        this.server.getApplication().removeLocale(locale);
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.c("UserTokenPolicies");
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        if (applicationIdentity == null) {
            throw new NullPointerException("identity must be defined");
        }
        if (applicationIdentity.getApplicationDescription() == null) {
            throw new IllegalArgumentException("identity's ApplicationDescription must be defined");
        }
        this.applicationIdentity = applicationIdentity;
    }

    public void setBindAddresses(UaApplication.Protocol protocol, Set<InetAddress> set) {
        this.fQ.put(protocol, set);
        this.aJ();
    }

    public void setBindAddresses(Set<InetAddress> set) {
        this.fP = set;
    }

    public void setDiscoveryEndpointEnabled(boolean bl) {
        this.fR = bl;
    }

    public void setDiscoveryServerAddress(UaAddress uaAddress) {
        this.fT = uaAddress;
    }

    public void setDiscoveryServerRegistrationPeriod(long l2) {
        this.fU = l2;
    }

    public void setDiscoveryServerUrl(String string) throws URISyntaxException {
        if (string == null || string.isEmpty()) {
            this.fT = null;
            return;
        }
        this.fT = new UaAddress(string);
    }

    public void setEnableIPv6(boolean bl) {
        this.fV = bl;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration : EndpointConfiguration.defaults();
    }

    public void setFailOnBindError(boolean bl) {
        this.fX = bl;
    }

    public void setHttpsSecurityPolicies(HttpsSecurityPolicy ... httpsSecurityPolicyArray) throws UaServerException {
        this.d("HttpsSecurityPolicies");
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.httpsSettings = httpsSettings;
    }

    public void setHttpsWorkerThreadCount(int n2) {
        this.ga = n2;
    }

    public void setListener(UaServerListener uaServerListener) {
        this.listener = uaServerListener;
    }

    public void setPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.OpcTcp, n2);
    }

    public void setPort(UaApplication.Protocol protocol, int n2) throws UaServerException {
        this.d("Port");
        this.gb.put(protocol, n2);
        this.aJ();
    }

    public void setSecurityModes(SecurityMode[] securityModeArray) throws UaServerException {
        this.d("SecurityModes");
        this.securityModes = securityModeArray;
    }

    public void setServerName(UaApplication.Protocol protocol, String string) throws UaServerException {
        this.d("ServerName");
        if (string == null) {
            this.gc.remove((Object)protocol);
        } else {
            this.gc.put(protocol, string);
        }
        this.aJ();
    }

    public void setServerName(String string) throws UaServerException {
        this.d("ServerName");
        if (string == null) {
            this.serverName = "";
            return;
        }
        this.serverName = string;
    }

    @Deprecated
    public void setUseAllIpAddresses(boolean bl) {
        this.gd = bl;
    }

    @Deprecated
    public void setUseCanonicalHostName(boolean bl) {
        this.ge = bl;
    }

    @Deprecated
    public void setUseHostName(boolean bl) {
        this.gf = bl;
    }

    @Deprecated
    public void setUseLocalhost(boolean bl) throws UaServerException {
        this.d("UseLocalhost");
        this.gg = bl;
    }

    public void setUserTokenPolicies(UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        this.d("UserTokenPolicies");
        this.userTokenPolicies.clear();
        this.userTokenPolicies.addAll(Arrays.asList(userTokenPolicyArray));
    }

    public void setUserValidator(UserValidator userValidator) {
        this.gh = userValidator;
    }

    public void shutdown(int n2, LocalizedText localizedText) {
        this.shutdown(n2, localizedText, true);
    }

    public synchronized void shutdown(int n2, LocalizedText localizedText, boolean bl) {
        if (this.initialized) {
            logger.info("Shutdown: Delay (s)={}; Reason={}", (Object)n2, (Object)localizedText);
            this.registerServer(false);
            this.getNodeManagerRoot().shutdown(n2, localizedText);
            logger.debug("Sleeping {} seconds", (Object)n2);
            try {
                Thread.sleep(n2 * 1000);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Shutdown interrupted", (Throwable)interruptedException);
            }
            try {
                if (this.subscriptionManager != null) {
                    this.subscriptionManager.close();
                }
                this.sessionManager.close();
            }
            finally {
                this.running = false;
            }
            if (bl) {
                this.close();
            }
        }
    }

    public void shutdown(int n2, String string) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE));
    }

    public void shutdown(int n2, String string, boolean bl) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE), bl);
    }

    public synchronized void start() throws UaServerException {
        if (!this.isRunning()) {
            this.init();
            this.running = true;
            try {
                UaServer uaServer = this;
                try {
                    uaServer.sessionManager.start();
                    uaServer.subscriptionManager.start();
                    uaServer.nodeServiceHandler.start();
                }
                catch (StatusException statusException) {
                    throw new UaServerException("Failed to start all managers", statusException);
                }
                catch (UaNodeFactoryException uaNodeFactoryException) {
                    throw new UaServerException("Failed to start all managers", uaNodeFactoryException);
                }
                uaServer = this;
                uaServer.getAddressSpace().getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setFieldsFromEndpointConfiguration(uaServer.endpointConfiguration);
                uaServer = this;
                for (EndpointDescription endpointDescription : uaServer.fW) {
                    String string = endpointDescription.getEndpointUrl();
                    uaServer.b(string);
                }
                this.aK();
                this.registerServer(true);
                uaServer = this;
                long l2 = TimeUnit.MINUTES.toMillis(uaServer.getDiscoveryServerRegistrationPeriod());
                if (uaServer.gj == null && uaServer.isDiscoveryEndpointEnabled() && !uaServer.getDiscoveryServerUrl().isEmpty() && l2 > 0L) {
                    uaServer.gj = new Timer("DiscoveryRegistrationTimer");
                    uaServer.gi = new a(uaServer, uaServer.getDiscoveryServerUrl());
                    uaServer.gj.schedule((TimerTask)uaServer.gi, l2, l2);
                    logger.debug("discoveryRegistrationTimer scheduled: period={}", (Object)l2);
                }
                return;
            }
            catch (UaServerException uaServerException) {
                this.close();
                this.running = false;
                throw uaServerException;
            }
        }
    }

    private void b(String string) throws UaServerException {
        if (!this.server.hasEndpoint(string)) {
            try {
                URI uRI;
                HttpsServer httpsServer;
                if (string.startsWith("http")) {
                    httpsServer = this.server.getApplication().getOrCreateHttpsServer();
                    httpsServer.getHttpsSettings().readFrom(this.httpsSettings);
                    if (httpsServer.getWorkerThreadCount() != this.getHttpsWorkerThreadCount()) {
                        httpsServer.setWorkerThreadCount(this.getHttpsWorkerThreadCount());
                    }
                }
                httpsServer = new Endpoint(string, string.startsWith("http") ? SecurityMode.NON_SECURE : this.securityModes);
                httpsServer.setEndpointConfiguration(this.endpointConfiguration);
                logger.info("Server endpoint: {}", (Object)httpsServer);
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new UaServerException("Invalid URI: " + string, uRISyntaxException);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object = this.getBindAddresses(UaApplication.Protocol.parseProtocol(uRI.getScheme()));
                if (object == null) {
                    throw new UaServerException("BindAddresses not available.");
                }
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2;
                    Object object3 = (InetAddress)object.next();
                    if (!this.fV && object3 instanceof Inet6Address) continue;
                    Object object4 = object3 instanceof Inet6Address ? "%s://[%s]:%d" : "%s://%s:%d";
                    int n2 = uRI.getPort();
                    if (n2 == -1) {
                        logger.debug("Cannot parse host using URI. Diverting to custom parser");
                        object2 = string.split("/+");
                        if (((String[])object2).length < 2) {
                            throw new UaServerException("Invalid URI: " + string);
                        }
                        String string2 = object2[0];
                        String[] stringArray = object2[1].split(":");
                        try {
                            n2 = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = UriUtil.defaultPort((String)string2);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n2 = UriUtil.defaultPort((String)string2);
                        }
                    }
                    object2 = String.format((String)object4, uRI.getScheme(), ((InetAddress)object3).getHostAddress(), n2);
                    this.server.bind((String)object2, (Endpoint)httpsServer);
                    arrayList.add(((InetAddress)object3).getHostAddress() + ":" + n2);
                    if (this.isDiscoveryEndpointEnabled()) {
                        String string3 = string;
                        object4 = object2;
                        object3 = this;
                        try {
                            string3 = ((UaServer)object3).getDiscoveryUriOf(string3);
                            if (logger.isDebugEnabled()) {
                                logger.debug("bindDiscoveryEndpoint: discoveryUriString={}", (Object)string3);
                                logger.debug("bindDiscoveryEndpoint: discovery bindings={}", (Object)Arrays.toString(((UaServer)object3).getDiscoveryServer().getBindings()));
                                logger.debug("bindDiscoveryEndpoint: server bindings={}", (Object)Arrays.toString(((UaServer)object3).server.getBindings()));
                            }
                            if ((string3 = !((UaServer)object3).getDiscoveryServer().hasEndpoint(string3) && !((UaServer)object3).server.hasEndpoint(string3) ? new Endpoint(string3, new SecurityMode[]{SecurityMode.NONE}) : ((UaServer)object3).getDiscoveryServer().getEndpointByUri(string3)) == null) continue;
                            ((UaServer)object3).getDiscoveryServer().bind((String)object4, (Endpoint)string3);
                            logger.debug("Discovery endpoint bound to {}", object4);
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                        continue;
                    }
                    logger.debug("Skipping binding DiscoveryEndpoint because isDiscoveryEndpointEnabled is false");
                }
                logger.info("Endpoint bound to: {}", arrayList);
                return;
            }
            catch (ServiceResultException serviceResultException) {
                if (this.fX) {
                    this.server.close();
                    throw new UaServerException("Failed to initialize server endpoint: " + string, serviceResultException);
                }
                logger.error("Failed to initialize server endpoint: " + string, (Throwable)serviceResultException);
            }
        }
    }

    private void c(String string) throws UaServerException {
        if (this.initialized) {
            throw new UaServerException(String.format("Cannot configure %s after the server is initialized.", string));
        }
    }

    private void d(String string) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException(String.format("Cannot change %s when running", string));
        }
    }

    private void aF() {
        for (UserTokenPolicy userTokenPolicy : this.server.getUserTokenPolicies()) {
            this.server.removeUserTokenPolicy(userTokenPolicy);
        }
    }

    private void aG() {
        Application application = this.server.getApplication();
        application.setApplicationName(this.applicationIdentity.getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        application.setProductUri(this.applicationIdentity.getApplicationDescription().getProductUri());
        KeyPair[] keyPairArray = this.applicationIdentity.getCertificates();
        if (keyPairArray != null) {
            for (KeyPair keyPair : keyPairArray) {
                application.addApplicationInstanceCertificate(keyPair);
                logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(keyPair.getCertificate().getEncodedThumbprint()));
            }
        } else {
            application.addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
            logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(this.applicationIdentity.getKeys().getCertificate().getEncodedThumbprint()));
        }
        application.getHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        application.getOpctcpSettings().setCertificateValidator((CertificateValidator)this.getCertificateValidator());
        for (KeyPair keyPair : this.applicationIdentity.getSoftwareCertificates()) {
            application.addSoftwareCertificate((SignedSoftwareCertificate)keyPair);
        }
    }

    private void aH() throws UaServerException {
        this.fW = new ArrayList<EndpointDescription>();
        logger.debug("initEndpoints: SecurityModes={} httpsSecurityPolicies={}", (Object)Arrays.toString(this.securityModes), (Object)Arrays.toString(this.getHttpsSecurityPolicies()));
        for (String string : this.getServerUris()) {
            logger.debug("uri: {}", (Object)string);
            SecurityMode[] securityModeArray = string.startsWith("http") ? SecurityMode.NON_SECURE : this.securityModes;
            try {
                for (SecurityMode securityMode : securityModeArray) {
                    this.addEndpoint(string, securityMode, this.getUserTokenPolicies());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.server.close();
                throw new UaServerException("Failed to initialize server endpoint: " + string, illegalArgumentException);
            }
        }
    }

    private void aI() throws UaServerException {
        if (this.userTokenPolicies.isEmpty()) {
            throw new UaServerException("No UserTokenPolicies defined");
        }
        this.aF();
        for (UserTokenPolicy userTokenPolicy : this.userTokenPolicies) {
            this.server.addUserTokenPolicy(userTokenPolicy);
        }
    }

    private static void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    private void aJ() {
        this.serverUris = null;
        this.fZ.clear();
    }

    private void aK() {
        Object[] objectArray = this;
        objectArray = this.getServer().getEndpointDescriptions();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = objectArray[i2].getEndpointUrl();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        logger.debug("getApplicationDiscoveryUrls: urls={}", arrayList);
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        this.getApplicationIdentity().getApplicationDescription().setDiscoveryUrls((String[])objectArray);
        this.getServer().getApplication().getApplicationDescription().setDiscoveryUrls((String[])objectArray);
        if (logger.isDebugEnabled()) {
            logger.debug("updateApplicationDescription: applicationDescription={}", (Object)this.getApplicationIdentity().getApplicationDescription());
        }
    }

    protected AttributeServiceHandler createAttributeServiceHandler() {
        return new AttributeServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected NodeManager createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager = null;
        if (this.getListener() != null) {
            nodeManager = this.getListener().onCreateNewNodeManager(serviceContext, string);
        }
        if (nodeManager == null) {
            nodeManager = new NodeManagerUaNode(this, string);
        }
        return nodeManager;
    }

    protected NodeManagementServiceHandler createNodeManagementServiceHandler() {
        return new NodeManagementServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected SessionManager createSessionManager() {
        SessionManager sessionManager = new SessionManager(this);
        return sessionManager;
    }

    protected SessionServiceHandler createSessionServiceHandler() {
        return new SessionServiceHandler(this.sessionManager);
    }

    protected SubscriptionManager createSubscriptionManager() {
        return new SubscriptionManager(this.sessionManager, this.nodeManagerTable);
    }

    protected SubscriptionServiceHandler createSubscriptionServiceHandler() {
        return new SubscriptionServiceHandler(this.subscriptionManager);
    }

    protected DiscoveryServer getDiscoveryServer() {
        DiscoveryServer discoveryServer = this.fS.get();
        if (discoveryServer != null) {
            return discoveryServer;
        }
        discoveryServer = new DiscoveryServer(this, this.server.getApplication());
        try {
            this.server.getApplication().getOrCreateOpcTcpServer().discoveryServer = discoveryServer;
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("Cannot assign discoveryServer");
        }
        this.fS.compareAndSet(null, discoveryServer);
        return this.fS.get();
    }

    protected String getDiscoveryUriOf(String object) throws URISyntaxException {
        object = new URI((String)object);
        object = new URI(((URI)object).getScheme(), null, ((URI)object).getHost(), ((URI)object).getPort(), null, null, null).toString();
        return object;
    }

    protected int getHttpsPort() {
        return this.getPort(UaApplication.Protocol.Https);
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected Server getServer() {
        return this.server;
    }

    protected void initServiceHandlers() throws UaServerException {
        if (this.isDiscoveryEndpointEnabled()) {
            this.addServiceHandler((Object)this.getDiscoveryServer());
        }
        this.sessionManager = this.createSessionManager();
        this.sessionManager.addListener(this.sessionManagerListener);
        this.sessionServiceHandler = this.createSessionServiceHandler();
        this.addServiceHandler(this.sessionServiceHandler);
        this.nodeManagerTable = new NodeManagerTable(this);
        this.nodeManagerRoot = new NodeManagerRoot(this);
        this.nodeManagerTable.addNodeManager(0, this.nodeManagerRoot);
        this.nodeServiceHandler = this.createNodeManagementServiceHandler();
        this.addServiceHandler(this.nodeServiceHandler);
        this.attributeServiceHandler = this.createAttributeServiceHandler();
        this.addServiceHandler(this.attributeServiceHandler);
        this.subscriptionManager = this.createSubscriptionManager();
        this.subscriptionServiceHandler = this.createSubscriptionServiceHandler();
        this.addServiceHandler(this.subscriptionServiceHandler);
        this.nodeManagerUaServer = new NodeManagerUaServer(this, this, this.applicationIdentity.getApplicationDescription().getApplicationUri());
        try {
            this.nodeServiceHandler.init();
            return;
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize UaServer", statusException);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
        }
    }

    protected void logRegisterServerError(String string, boolean bl, UaServerException uaServerException) {
        String string2 = uaServerException.getCause() == null ? "" : " Cause: " + uaServerException.getCause().getMessage();
        boolean bl2 = false;
        if (this.listener != null) {
            bl2 = this.listener.onRegisterServerError(string, bl, uaServerException);
        }
        if (!bl2) {
            logger.warn(uaServerException.getMessage() + string2);
        }
    }

    protected void setHttpsPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.Https, n2);
    }

    protected void updateNamespaceArray() {
        this.getNodeManagerRoot().getServerData().updateNamespaceArray();
    }

    protected void updateServerArray() throws StatusException {
        this.getNodeManagerRoot().getServerData().updateServerArray();
    }

    protected void validateUserError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.gh);
        if (this.gh != null) {
            try {
                this.gh.onValidationError(session, userIdentityToken, exception);
                return;
            }
            catch (RuntimeException runtimeException) {
                UaServer.listenerError("userValidationError", this.gh, runtimeException);
            }
        }
    }

    protected boolean validateUserIdentity(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.gh);
        if (this.gh != null) {
            try {
                return this.gh.onValidate(session, serverUserIdentity);
            }
            catch (RuntimeException runtimeException) {
                UaServer.listenerError("validateUserIdentity", this.gh, runtimeException);
            }
        }
        return true;
    }

    static /* synthetic */ StatusCode a(UaServer uaServer, ApplicationIdentity applicationIdentity) {
        return uaServer.validateApplicationCertificate(applicationIdentity);
    }

    private final class a
    extends TimerTask {
        private final String fi;
        private /* synthetic */ UaServer cB;

        public a(UaServer uaServer, String string) {
            this.cB = uaServer;
            this.fi = string;
        }

        @Override
        public final void run() {
            long l2 = 5L;
            while (l2 > 0L && System.currentTimeMillis() - this.scheduledExecutionTime() < TimeUnit.MINUTES.toMillis(this.cB.getDiscoveryServerRegistrationPeriod())) {
                try {
                    this.cB.registerServer(this.fi, true);
                    l2 = 0L;
                }
                catch (UaServerException uaServerException) {
                    try {
                        this.cB.logRegisterServerError(this.fi, true, uaServerException);
                        logger.debug("Retrying to register server in {} seconds", (Object)l2);
                        long l3 = System.currentTimeMillis();
                        do {
                            TimeUnit.SECONDS.sleep(1L);
                        } while (this.cB.isRunning() && System.currentTimeMillis() - l3 < l2 * 1000L);
                        l2 = this.cB.isRunning() ? Math.min(2L * l2, TimeUnit.MINUTES.toSeconds(this.cB.getDiscoveryServerRegistrationPeriod())) : 0L;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("DiscoveryRegistrationTask interrupted");
                        l2 = 0L;
                    }
                }
            }
            logger.debug("DiscoveryRegistrationTask end");
        }
    }

    public class NodeManagerUaServer
    extends NodeManagerUaNode {
        private final IoManagerListener cO;
        private /* synthetic */ UaServer cB;

        public NodeManagerUaServer(UaServer uaServer, UaServer uaServer2, String string) {
            this.cB = uaServer;
            super(uaServer2, string);
            this.cO = new f(this);
            this.getIoManager().addListeners(this.cO);
        }

        @Override
        protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            return super.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
        }

        @Override
        protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
            super.addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
        }

        @Override
        protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            super.deleteNode(serviceContext, nodeId, bl);
        }

        @Override
        protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
            super.deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }

        protected EnumSet<AccessLevel> getAccessLevelForSecurityDiagnostics(ServiceContext serviceContext) {
            if (this.cB.listener != null && this.cB.listener.onAllowReadSecurityDiagnostics(serviceContext)) {
                return READONLY;
            }
            return AccessLevel.NONE;
        }
    }

    public class DiscoveryServer
    extends Server {
        private final Logger logger;
        private final Map<String, RegisteredServer> dk;
        private /* synthetic */ UaServer cB;

        public DiscoveryServer(UaServer uaServer, Application application) {
            this.cB = uaServer;
            super(application);
            this.logger = LoggerFactory.getLogger(DiscoveryServer.class);
            this.dk = new ConcurrentHashMap<String, RegisteredServer>(2, 1.0f, 2);
            this.addServiceHandler((Object)this);
        }

        public RegisteredServer[] getRegisteredServers() {
            return this.dk.values().toArray(new RegisteredServer[this.dk.size()]);
        }

        public final void onFindServers(EndpointServiceRequest<FindServersRequest, FindServersResponse> endpointServiceRequest) throws ServiceFaultException {
            this.logger.debug("onFindServers");
            FindServersResponse findServersResponse = new FindServersResponse();
            ArrayList<ApplicationDescription> arrayList = new ArrayList<ApplicationDescription>();
            FindServersRequest findServersRequest = (FindServersRequest)endpointServiceRequest.getRequest();
            String string = findServersRequest.getEndpointUrl();
            this.logger.debug("endpointUrl={}", (Object)string);
            List<String> list = Arrays.asList(findServersRequest.getServerUris());
            this.logger.debug("serverUris={}", list);
            this.logger.debug("registeredServers={}", this.dk.values());
            for (RegisteredServer registeredServer : this.dk.values()) {
                if (!registeredServer.getIsOnline().booleanValue() || !list.isEmpty() && !list.contains(registeredServer.getServerUri())) continue;
                List<LocalizedText> list2 = Arrays.asList(registeredServer.getServerNames());
                LocalizedText localizedText = list2.get(0);
                block1: for (String string2 : findServersRequest.getLocaleIds()) {
                    for (LocalizedText localizedText2 : list2) {
                        if (!string2.equals(localizedText2.getLocale().getLanguage())) continue;
                        localizedText = localizedText2;
                        continue block1;
                    }
                }
                ArrayList arrayList2 = new ArrayList();
                if (string != null) {
                    for (String string2 : registeredServer.getDiscoveryUrls()) {
                        if (!string2.contains(string)) continue;
                        arrayList2.add(string2);
                    }
                }
                if (arrayList2.isEmpty()) {
                    for (String string3 : registeredServer.getDiscoveryUrls()) {
                        if (string3.contains("localhost")) continue;
                        arrayList2.add(string3);
                    }
                }
                arrayList.add(new ApplicationDescription(registeredServer.getServerUri(), registeredServer.getProductUri(), localizedText, registeredServer.getServerType(), registeredServer.getGatewayServerUri(), null, arrayList2.toArray(new String[arrayList2.size()])));
            }
            this.logger.debug("servers={}", arrayList);
            findServersResponse.setServers(arrayList.toArray(new ApplicationDescription[arrayList.size()]));
            ResponseHeader responseHeader = new ResponseHeader(DateTime.currentTime(), findServersRequest.getRequestHeader().getRequestHandle(), null, null, this.getApplication().getLocaleIds(), null);
            findServersResponse.setResponseHeader(responseHeader);
            endpointServiceRequest.sendResponse((ServiceResponse)findServersResponse);
        }

        public final void onRegisterServer(EndpointServiceRequest<RegisterServerRequest, RegisterServerResponse> endpointServiceRequest) throws ServiceFaultException {
            RegisteredServer registeredServer = ((RegisterServerRequest)endpointServiceRequest.getRequest()).getServer();
            this.dk.put(registeredServer.getServerUri(), registeredServer);
            this.logger.debug("onRegisterServer: server={} isOnline={}", (Object)registeredServer.getServerUri(), (Object)registeredServer.getIsOnline());
            registeredServer = new RegisterServerResponse();
            endpointServiceRequest.sendResponse((ServiceResponse)registeredServer);
        }

        public void registerServer(UaServer uaServer, String string, boolean bl) {
            boolean bl2 = this.ah();
            uaServer = UaServer.toRegisteredServer(string, bl, uaServer);
            this.dk.put(uaServer.getServerUri(), (RegisteredServer)uaServer);
            this.logger.debug("registerServer: server={} isOnline={}", (Object)uaServer, (Object)bl);
            if (bl2 && !this.ah()) {
                this.logger.debug("No Online Servers: closing the internal Discovery Server");
                this.close();
                this.cB.fS.set(null);
            }
        }

        private boolean ah() {
            for (RegisteredServer registeredServer : this.dk.values()) {
                if (!registeredServer.getIsOnline().booleanValue()) continue;
                return true;
            }
            return false;
        }
    }
}

