/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.InstantiationParameters;
import com.prosysopc.ua.server.InstantiationStrategy;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStateVariableInstantiationStrategy
implements InstantiationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TwoStateVariableInstantiationStrategy.class);
    private final Boolean ez;
    private final String eA;
    private final String eB;

    public TwoStateVariableInstantiationStrategy(String string, String string2, boolean bl) {
        this.eB = string;
        this.eA = string2;
        this.ez = bl;
    }

    @Override
    public UaNode createInstance(InstantiationParameters object) {
        logger.debug("Creating TwoStateVariable");
        UaNode uaNode = ((InstantiationParameters)object).getInstanceDeclaration().getNode();
        object = ((InstantiationParameters)object).getNodeManager().createInstance(TwoStateVariableTypeNode.class, ((InstantiationParameters)object).getNodeId(), uaNode.getBrowseName(), uaNode.getDisplayName());
        ((TwoStateVariableTypeNode)object).setTrueState(this.eB, LocalizedText.NO_LOCALE);
        ((TwoStateVariableTypeNode)object).setFalseState(this.eA, LocalizedText.NO_LOCALE);
        ((TwoStateVariableTypeNode)object).setId(this.ez);
        return object;
    }

    @Override
    public boolean createsCompleteHierarchy() {
        return true;
    }
}

