/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.BrowsePath;
import com.prosysopc.ua.server.ExternalReferenceDeclaration;
import com.prosysopc.ua.server.InternalReferenceDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opcfoundation.ua.core.Identifiers;

public class TemporaryInstanceDeclaration {
    private final Set<BrowsePath> bp = new HashSet<BrowsePath>();
    private final Set<ExternalReferenceDeclaration> bq = new HashSet<ExternalReferenceDeclaration>();
    private final Set<InternalReferenceDeclaration> kn = new HashSet<InternalReferenceDeclaration>();
    private final UaNode node;

    public TemporaryInstanceDeclaration(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        this(temporaryInstanceDeclaration.getNode(), temporaryInstanceDeclaration.getPrimaryPath());
        this.bp.addAll(temporaryInstanceDeclaration.bp);
        this.bq.addAll(temporaryInstanceDeclaration.bq);
        this.kn.addAll(temporaryInstanceDeclaration.kn);
    }

    public TemporaryInstanceDeclaration(UaNode uaNode, BrowsePath browsePath) {
        this.node = uaNode;
        this.bp.add(browsePath);
    }

    public void addBrowsePath(BrowsePath browsePath) {
        this.bp.add(browsePath);
    }

    public void addReference(ExternalReferenceDeclaration externalReferenceDeclaration) {
        this.bq.add(externalReferenceDeclaration);
    }

    public void addReference(InternalReferenceDeclaration internalReferenceDeclaration) {
        this.kn.add(internalReferenceDeclaration);
    }

    public boolean equals(Object object) {
        if (object instanceof TemporaryInstanceDeclaration) {
            object = (TemporaryInstanceDeclaration)object;
            return this.node.getNodeId().equals((Object)((TemporaryInstanceDeclaration)object).node.getNodeId());
        }
        return super.equals(object);
    }

    public Set<BrowsePath> getBrowsePaths() {
        return Collections.unmodifiableSet(this.bp);
    }

    public Set<ExternalReferenceDeclaration> getExternalReferences() {
        return Collections.unmodifiableSet(this.bq);
    }

    public UaReference[] getForwardHierarchicalReferences() {
        return this.node.getForwardReferences(Identifiers.Aggregates);
    }

    public UaReference[] getForwardNonHierarchicalReferences() {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.node.getForwardReferences(Identifiers.NonHierarchicalReferences, Identifiers.HasEventSource, Identifiers.Organizes)) {
            arrayList.add(uaReference);
        }
        return arrayList.toArray(new UaReference[0]);
    }

    public Set<InternalReferenceDeclaration> getInternalReferences() {
        return Collections.unmodifiableSet(this.kn);
    }

    public UaNode getNode() {
        return this.node;
    }

    public BrowsePath getPrimaryPath() {
        return this.bp.iterator().next();
    }

    public int hashCode() {
        return this.node.getNodeId().hashCode();
    }

    public boolean hasPath(BrowsePath browsePath) {
        return this.bp.contains(browsePath);
    }

    public void merge(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        this.bp.addAll(temporaryInstanceDeclaration.bp);
        this.bq.addAll(temporaryInstanceDeclaration.bq);
        this.kn.addAll(temporaryInstanceDeclaration.kn);
    }

    public String toString() {
        return this.getPrimaryPath().toString();
    }
}

