/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.core.CreateMonitoredItemsRequest;
import org.opcfoundation.ua.core.CreateMonitoredItemsResponse;
import org.opcfoundation.ua.core.CreateSubscriptionRequest;
import org.opcfoundation.ua.core.CreateSubscriptionResponse;
import org.opcfoundation.ua.core.DeleteMonitoredItemsRequest;
import org.opcfoundation.ua.core.DeleteMonitoredItemsResponse;
import org.opcfoundation.ua.core.DeleteSubscriptionsRequest;
import org.opcfoundation.ua.core.DeleteSubscriptionsResponse;
import org.opcfoundation.ua.core.ModifyMonitoredItemsRequest;
import org.opcfoundation.ua.core.ModifyMonitoredItemsResponse;
import org.opcfoundation.ua.core.ModifySubscriptionRequest;
import org.opcfoundation.ua.core.ModifySubscriptionResponse;
import org.opcfoundation.ua.core.MonitoredItemCreateRequest;
import org.opcfoundation.ua.core.MonitoredItemCreateResult;
import org.opcfoundation.ua.core.MonitoredItemModifyRequest;
import org.opcfoundation.ua.core.MonitoredItemModifyResult;
import org.opcfoundation.ua.core.MonitoredItemServiceSetHandler;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.PublishRequest;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.RepublishRequest;
import org.opcfoundation.ua.core.RepublishResponse;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.SetMonitoringModeRequest;
import org.opcfoundation.ua.core.SetMonitoringModeResponse;
import org.opcfoundation.ua.core.SetPublishingModeRequest;
import org.opcfoundation.ua.core.SetPublishingModeResponse;
import org.opcfoundation.ua.core.SetTriggeringRequest;
import org.opcfoundation.ua.core.SetTriggeringResponse;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.SubscriptionServiceSetHandler;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.TransferResult;
import org.opcfoundation.ua.core.TransferSubscriptionsRequest;
import org.opcfoundation.ua.core.TransferSubscriptionsResponse;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionServiceHandler
extends ServiceHandler
implements MonitoredItemServiceSetHandler,
SubscriptionServiceSetHandler {
    private static Logger logger = LoggerFactory.getLogger(SubscriptionServiceHandler.class);
    private final ConcurrentHashMap<Session, LinkedBlockingQueue<a>> gO = new ConcurrentHashMap();
    private final ConcurrentHashMap<Session, Thread> gP = new ConcurrentHashMap();
    private final SessionManagerListener sessionManagerListener = new com.prosysopc.ua.server.b(this);
    private final a gQ = new a(this, null, null, null);
    private final SubscriptionManager subscriptionManager;

    public SubscriptionServiceHandler(SubscriptionManager subscriptionManager) {
        super(subscriptionManager.getSessionManager(), subscriptionManager.getNodeManagerTable());
        this.subscriptionManager = subscriptionManager;
        subscriptionManager.getSessionManager().addListener(this.sessionManagerListener);
    }

    public int getMaxMonitoredItemsPerCall() {
        return this.getOperationLimits().getMaxMonitoredItemsPerCall().intValue();
    }

    public final void onCreateMonitoredItems(EndpointServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateMonitoredItemsRequest createMonitoredItemsRequest = (CreateMonitoredItemsRequest)endpointServiceRequest.getRequest();
        CreateMonitoredItemsResponse createMonitoredItemsResponse = new CreateMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        ArrayList<ReadValueId> arrayList = new ArrayList<ReadValueId>();
        ArrayList<MonitoredDataItem> arrayList2 = new ArrayList<MonitoredDataItem>();
        try {
            serviceContext = this.validateRequest((ServiceRequest)createMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.createMonitoredItems(serviceContext, createMonitoredItemsRequest, createMonitoredItemsResponse, arrayList, arrayList2);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)createMonitoredItemsResponse, serviceException);
        }
        createMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)createMonitoredItemsRequest, (ServiceResponse)createMonitoredItemsResponse, serviceContext, createMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)createMonitoredItemsResponse);
    }

    public final void onCreateSubscription(EndpointServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateSubscriptionRequest createSubscriptionRequest = (CreateSubscriptionRequest)endpointServiceRequest.getRequest();
        CreateSubscriptionResponse createSubscriptionResponse = new CreateSubscriptionResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)createSubscriptionRequest, endpointServiceRequest.getChannel());
            this.createSubscription(serviceContext, createSubscriptionRequest, createSubscriptionResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)createSubscriptionResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)createSubscriptionRequest, (ServiceResponse)createSubscriptionResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)createSubscriptionResponse);
    }

    public final void onDeleteMonitoredItems(EndpointServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteMonitoredItemsRequest deleteMonitoredItemsRequest = (DeleteMonitoredItemsRequest)endpointServiceRequest.getRequest();
        DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = new DeleteMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)deleteMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.deleteMonitoredItems(serviceContext, deleteMonitoredItemsRequest, deleteMonitoredItemsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)deleteMonitoredItemsResponse, serviceException);
        }
        deleteMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)deleteMonitoredItemsRequest, (ServiceResponse)deleteMonitoredItemsResponse, serviceContext, deleteMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)deleteMonitoredItemsResponse);
    }

    public final void onDeleteSubscriptions(EndpointServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteSubscriptionsRequest deleteSubscriptionsRequest = (DeleteSubscriptionsRequest)endpointServiceRequest.getRequest();
        DeleteSubscriptionsResponse deleteSubscriptionsResponse = new DeleteSubscriptionsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)deleteSubscriptionsRequest, endpointServiceRequest.getChannel());
            this.deleteSubscriptions(serviceContext, deleteSubscriptionsRequest, deleteSubscriptionsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)deleteSubscriptionsResponse, serviceException);
        }
        deleteSubscriptionsResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)deleteSubscriptionsRequest, (ServiceResponse)deleteSubscriptionsResponse, serviceContext, deleteSubscriptionsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)deleteSubscriptionsResponse);
    }

    public final void onModifyMonitoredItems(EndpointServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        ModifyMonitoredItemsRequest modifyMonitoredItemsRequest = (ModifyMonitoredItemsRequest)endpointServiceRequest.getRequest();
        ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = new ModifyMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)modifyMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.modifyMonitoredItems(serviceContext, modifyMonitoredItemsRequest, modifyMonitoredItemsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)modifyMonitoredItemsResponse, serviceException);
        }
        modifyMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)modifyMonitoredItemsRequest, (ServiceResponse)modifyMonitoredItemsResponse, serviceContext, modifyMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)modifyMonitoredItemsResponse);
    }

    public final void onModifySubscription(EndpointServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> endpointServiceRequest) throws ServiceFaultException {
        ModifySubscriptionRequest modifySubscriptionRequest = (ModifySubscriptionRequest)endpointServiceRequest.getRequest();
        ModifySubscriptionResponse modifySubscriptionResponse = new ModifySubscriptionResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)modifySubscriptionRequest, endpointServiceRequest.getChannel());
            this.modifySubscription(serviceContext, modifySubscriptionRequest, modifySubscriptionResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)modifySubscriptionResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)modifySubscriptionRequest, (ServiceResponse)modifySubscriptionResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)modifySubscriptionResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPublish(EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest) throws ServiceFaultException {
        PublishRequest publishRequest = (PublishRequest)endpointServiceRequest.getRequest();
        ServiceContext serviceContext = null;
        try {
            logger.debug("onPublish");
            SubscriptionServiceHandler subscriptionServiceHandler = this;
            synchronized (subscriptionServiceHandler) {
                Object object;
                ServiceContext serviceContext2 = serviceContext = this.validateRequest((ServiceRequest)publishRequest, endpointServiceRequest.getChannel());
                EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest2 = endpointServiceRequest;
                SubscriptionServiceHandler subscriptionServiceHandler2 = this;
                Session session = serviceContext2.getSession();
                LinkedBlockingQueue<a> linkedBlockingQueue = subscriptionServiceHandler2.gO.get(session);
                logger.debug("addToPublishRequestQueue: queue={}", linkedBlockingQueue);
                if (linkedBlockingQueue == null && subscriptionServiceHandler2.gO.putIfAbsent(session, linkedBlockingQueue = new LinkedBlockingQueue()) == null) {
                    object = new Thread(new b(subscriptionServiceHandler2, session, linkedBlockingQueue));
                    ((Thread)object).setName("PublishRequestQueue-" + session.getSessionName());
                    ((Thread)object).start();
                    if (logger.isDebugEnabled()) {
                        logger.debug("addToPublishRequestQueue: thread={} session={}", (Object)((Thread)object).getName(), (Object)session);
                    }
                    subscriptionServiceHandler2.gP.put(session, (Thread)object);
                }
                object = new PublishResponse();
                subscriptionServiceHandler2.subscriptionManager.acknowledge(serviceContext2, (PublishRequest)endpointServiceRequest2.getRequest(), (PublishResponse)object);
                if (!linkedBlockingQueue.offer(new a(subscriptionServiceHandler2, serviceContext2, endpointServiceRequest2, (PublishResponse)object))) {
                    throw new ServiceException(StatusCodes.Bad_TooManyPublishRequests);
                }
            }
        }
        catch (ServiceException serviceException) {
            PublishResponse publishResponse = new PublishResponse();
            this.handleServiceResultException((ServiceResponse)publishResponse, serviceException);
            publishResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)publishRequest, (ServiceResponse)publishResponse, serviceContext, publishResponse.getDiagnosticInfos()));
            endpointServiceRequest.sendResponse((ServiceResponse)publishResponse);
        }
        logger.debug("onPublish: done");
    }

    public final void onRepublish(EndpointServiceRequest<RepublishRequest, RepublishResponse> endpointServiceRequest) throws ServiceFaultException {
        RepublishRequest republishRequest = (RepublishRequest)endpointServiceRequest.getRequest();
        RepublishResponse republishResponse = new RepublishResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)republishRequest, endpointServiceRequest.getChannel());
            this.subscriptionManager.republish(serviceContext, republishRequest, republishResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)republishResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)republishRequest, (ServiceResponse)republishResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)republishResponse);
    }

    public final void onSetMonitoringMode(EndpointServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> endpointServiceRequest) throws ServiceFaultException {
        SetMonitoringModeRequest setMonitoringModeRequest = (SetMonitoringModeRequest)endpointServiceRequest.getRequest();
        SetMonitoringModeResponse setMonitoringModeResponse = new SetMonitoringModeResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)setMonitoringModeRequest, endpointServiceRequest.getChannel());
            this.setMonitoringMode(serviceContext, setMonitoringModeRequest, setMonitoringModeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)setMonitoringModeResponse, serviceException);
        }
        setMonitoringModeResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)setMonitoringModeRequest, (ServiceResponse)setMonitoringModeResponse, serviceContext, setMonitoringModeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)setMonitoringModeResponse);
    }

    public final void onSetPublishingMode(EndpointServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> endpointServiceRequest) throws ServiceFaultException {
        SetPublishingModeRequest setPublishingModeRequest = (SetPublishingModeRequest)endpointServiceRequest.getRequest();
        SetPublishingModeResponse setPublishingModeResponse = new SetPublishingModeResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)setPublishingModeRequest, endpointServiceRequest.getChannel());
            this.setPublishingMode(serviceContext, setPublishingModeRequest, setPublishingModeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)setPublishingModeResponse, serviceException);
        }
        setPublishingModeResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)setPublishingModeRequest, (ServiceResponse)setPublishingModeResponse, serviceContext, setPublishingModeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)setPublishingModeResponse);
    }

    public final void onSetTriggering(EndpointServiceRequest<SetTriggeringRequest, SetTriggeringResponse> endpointServiceRequest) throws ServiceFaultException {
        SetTriggeringRequest setTriggeringRequest = (SetTriggeringRequest)endpointServiceRequest.getRequest();
        SetTriggeringResponse setTriggeringResponse = new SetTriggeringResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)setTriggeringRequest, endpointServiceRequest.getChannel());
            this.subscriptionManager.setTriggering(serviceContext, setTriggeringRequest, setTriggeringResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)setTriggeringResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)setTriggeringRequest, (ServiceResponse)setTriggeringResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)setTriggeringResponse);
    }

    public final void onTransferSubscriptions(EndpointServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> endpointServiceRequest) throws ServiceFaultException {
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)endpointServiceRequest.getRequest();
        TransferSubscriptionsResponse transferSubscriptionsResponse = new TransferSubscriptionsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)transferSubscriptionsRequest, endpointServiceRequest.getChannel());
            this.transferSubscriptions(serviceContext, transferSubscriptionsRequest, transferSubscriptionsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)transferSubscriptionsResponse, serviceException);
        }
        transferSubscriptionsResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)transferSubscriptionsRequest, (ServiceResponse)transferSubscriptionsResponse, serviceContext, transferSubscriptionsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)transferSubscriptionsResponse);
    }

    public void setMaxMonitoredItemsPerCall(int n2) {
        this.getOperationLimits().setMaxMonitoredItemsPerCall(UnsignedInteger.valueOf((long)n2));
    }

    private static void a(TimestampsToReturn timestampsToReturn) throws ServiceException {
        if (timestampsToReturn == null) {
            throw new ServiceException(StatusCodes.Bad_TimestampsToReturnInvalid);
        }
    }

    protected void createMonitoredItems(ServiceContext serviceContext, CreateMonitoredItemsRequest createMonitoredItemsRequest, CreateMonitoredItemsResponse createMonitoredItemsResponse, List<ReadValueId> list, List<MonitoredDataItem> list2) throws ServiceException {
        Object[] objectArray = createMonitoredItemsRequest.getItemsToCreate();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        Subscription subscription = this.subscriptionManager.getSubscription(createMonitoredItemsRequest.getSubscriptionId());
        createMonitoredItemsRequest = createMonitoredItemsRequest.getTimestampsToReturn();
        SubscriptionServiceHandler.a((TimestampsToReturn)createMonitoredItemsRequest);
        MonitoredItemCreateResult[] monitoredItemCreateResultArray = new MonitoredItemCreateResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                monitoredItemCreateResultArray[i2] = new MonitoredItemCreateResult();
                this.validateEncoding(objectArray[i2].getItemToMonitor());
                MonitoredItem monitoredItem = this.subscriptionManager.createMonitoredItem(serviceContext, subscription, (TimestampsToReturn)createMonitoredItemsRequest, (MonitoredItemCreateRequest)objectArray[i2]);
                monitoredItemCreateResultArray[i2].setRevisedQueueSize(UnsignedInteger.valueOf((long)monitoredItem.getQueueSize()));
                monitoredItemCreateResultArray[i2].setRevisedSamplingInterval(Double.valueOf(monitoredItem.getSamplingInterval()));
                monitoredItemCreateResultArray[i2].setStatusCode(StatusCode.GOOD);
                monitoredItemCreateResultArray[i2].setMonitoredItemId(monitoredItem.getMonitoredItemId());
                MonitoringFilterResult monitoringFilterResult = monitoredItem.getFilterResult();
                if (monitoringFilterResult != null) {
                    monitoredItemCreateResultArray[i2].setFilterResult(ExtensionObject.binaryEncode((Structure)monitoringFilterResult, (EncoderContext)this.getEncoderContext()));
                }
                if (!(monitoredItem instanceof MonitoredDataItem)) continue;
                list.add(objectArray[i2].getItemToMonitor());
                list2.add((MonitoredDataItem)monitoredItem);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                monitoredItemCreateResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                monitoredItemCreateResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (EncodingException encodingException) {
                monitoredItemCreateResultArray[i2].setStatusCode(encodingException.getStatusCode());
                diagnosticInfoArray[i2] = new DiagnosticInfo(encodingException.getMessage(), null, null, null, null, null, null);
            }
        }
        subscription.resetLastAliveTime();
        createMonitoredItemsResponse.setResults(monitoredItemCreateResultArray);
        createMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void createSubscription(ServiceContext object, CreateSubscriptionRequest createSubscriptionRequest, CreateSubscriptionResponse createSubscriptionResponse) throws ServiceException {
        object = this.subscriptionManager.addSubscription((ServiceContext)object, createSubscriptionRequest);
        createSubscriptionResponse.setSubscriptionId(((SubscriptionBase)object).getSubscriptionId());
        createSubscriptionResponse.setRevisedLifetimeCount(UnsignedInteger.valueOf((long)((SubscriptionBase)object).getLifetimeCount()));
        createSubscriptionResponse.setRevisedMaxKeepAliveCount(UnsignedInteger.valueOf((long)((SubscriptionBase)object).getMaxKeepAliveCount()));
        createSubscriptionResponse.setRevisedPublishingInterval(Double.valueOf(((SubscriptionBase)object).getPublishingInterval()));
    }

    protected void deleteMonitoredItems(ServiceContext serviceContext, DeleteMonitoredItemsRequest objectArray, DeleteMonitoredItemsResponse deleteMonitoredItemsResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(objectArray.getSubscriptionId());
        objectArray = objectArray.getMonitoredItemIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.deleteMonitoredItem(serviceContext, subscription, (UnsignedInteger)objectArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        subscription.resetLastAliveTime();
        deleteMonitoredItemsResponse.setResults(statusCodeArray);
        deleteMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void deleteSubscriptions(ServiceContext serviceContext, DeleteSubscriptionsRequest objectArray, DeleteSubscriptionsResponse deleteSubscriptionsResponse) throws ServiceException {
        logger.debug("deleteSubscriptions");
        objectArray = objectArray.getSubscriptionIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                Subscription subscription = this.subscriptionManager.getSubscription((UnsignedInteger)objectArray[i2]);
                this.subscriptionManager.removeSubscription(serviceContext, subscription, true);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
        deleteSubscriptionsResponse.setResults(statusCodeArray);
        deleteSubscriptionsResponse.setDiagnosticInfos(diagnosticInfoArray);
        if (logger.isDebugEnabled()) {
            logger.debug("deleteSubscriptions, remaining requests:{}", this.gO.get(serviceContext.getSession()));
            logger.debug("subscriptions left in session:{}", (Object)serviceContext.getSession().getSubscriptionCount());
        }
        if (serviceContext.getSession().getSubscriptionCount() == 0) {
            Thread thread = this.gP.get(serviceContext.getSession());
            if (thread != null) {
                thread.interrupt();
                logger.debug("Interrupted publishThread");
                return;
            }
            logger.debug("Could not interrupt publishThread, it is null");
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected void modifyMonitoredItems(ServiceContext serviceContext, ModifyMonitoredItemsRequest modifyMonitoredItemsRequest, ModifyMonitoredItemsResponse modifyMonitoredItemsResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(modifyMonitoredItemsRequest.getSubscriptionId());
        Object[] objectArray = modifyMonitoredItemsRequest.getItemsToModify();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        SubscriptionServiceHandler.a(modifyMonitoredItemsRequest.getTimestampsToReturn());
        MonitoredItemModifyResult[] monitoredItemModifyResultArray = new MonitoredItemModifyResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                monitoredItemModifyResultArray[i2] = new MonitoredItemModifyResult();
                MonitoredItem monitoredItem = this.subscriptionManager.modifyMonitoredItem(serviceContext, subscription, (MonitoredItemModifyRequest)objectArray[i2], modifyMonitoredItemsRequest.getTimestampsToReturn(), objectArray[i2].getRequestedParameters());
                monitoredItemModifyResultArray[i2].setStatusCode(StatusCode.GOOD);
                monitoredItemModifyResultArray[i2].setRevisedQueueSize(UnsignedInteger.valueOf((long)monitoredItem.getQueueSize()));
                monitoredItemModifyResultArray[i2].setRevisedSamplingInterval(Double.valueOf(monitoredItem.getSamplingInterval()));
                if (monitoredItem.getFilterResult() == null) continue;
                monitoredItemModifyResultArray[i2].setFilterResult(ExtensionObject.binaryEncode((Structure)monitoredItem.getFilterResult(), (EncoderContext)this.getEncoderContext()));
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                monitoredItemModifyResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (EncodingException encodingException) {
                monitoredItemModifyResultArray[i2].setStatusCode(encodingException.getStatusCode());
                diagnosticInfoArray[i2] = new DiagnosticInfo(encodingException.getMessage(), null, null, null, null, null, null);
            }
        }
        subscription.resetLastAliveTime();
        modifyMonitoredItemsResponse.setResults(monitoredItemModifyResultArray);
        modifyMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void modifySubscription(ServiceContext object, ModifySubscriptionRequest modifySubscriptionRequest, ModifySubscriptionResponse modifySubscriptionResponse) throws ServiceException {
        object = this.subscriptionManager.modifySubscription((ServiceContext)object, modifySubscriptionRequest);
        modifySubscriptionResponse.setRevisedLifetimeCount(UnsignedInteger.valueOf((long)((SubscriptionBase)object).getLifetimeCount()));
        modifySubscriptionResponse.setRevisedMaxKeepAliveCount(UnsignedInteger.valueOf((long)((SubscriptionBase)object).getMaxKeepAliveCount()));
        modifySubscriptionResponse.setRevisedPublishingInterval(Double.valueOf(((SubscriptionBase)object).getPublishingInterval()));
    }

    protected void setMonitoringMode(ServiceContext serviceContext, SetMonitoringModeRequest setMonitoringModeRequest, SetMonitoringModeResponse setMonitoringModeResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(setMonitoringModeRequest.getSubscriptionId());
        Object[] objectArray = setMonitoringModeRequest.getMonitoredItemIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        SubscriptionManager.a(setMonitoringModeRequest.getMonitoringMode());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.setMonitoringMode(serviceContext, subscription, (UnsignedInteger)objectArray[i2], setMonitoringModeRequest.getMonitoringMode());
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        subscription.resetLastAliveTime();
        setMonitoringModeResponse.setResults(statusCodeArray);
        setMonitoringModeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void setPublishingMode(ServiceContext serviceContext, SetPublishingModeRequest setPublishingModeRequest, SetPublishingModeResponse setPublishingModeResponse) throws ServiceException {
        Object[] objectArray = setPublishingModeRequest.getSubscriptionIds();
        this.checkRequestLength(objectArray, 0);
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.setPublishingMode(serviceContext, (UnsignedInteger)objectArray[i2], setPublishingModeRequest.getPublishingEnabled());
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        setPublishingModeResponse.setResults(statusCodeArray);
        setPublishingModeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void transferSubscriptions(ServiceContext serviceContext, TransferSubscriptionsRequest objectArray, TransferSubscriptionsResponse transferSubscriptionsResponse) throws ServiceException {
        objectArray = objectArray.getSubscriptionIds();
        this.checkRequestLength(objectArray, 0);
        TransferResult[] transferResultArray = new TransferResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                transferResultArray[i2] = new TransferResult();
                Subscription subscription = this.subscriptionManager.transferSubscription(serviceContext, (UnsignedInteger)objectArray[i2]);
                subscription.resetLastAliveTime();
                transferResultArray[i2].setStatusCode(StatusCode.GOOD);
                transferResultArray[i2].setAvailableSequenceNumbers(subscription.getAvailableSequenceNumbers());
                logger.debug("transferred: {}", (Object)subscription);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                transferResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
        transferSubscriptionsResponse.setResults(transferResultArray);
        transferSubscriptionsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    static /* synthetic */ Logger aT() {
        return logger;
    }

    static /* synthetic */ ConcurrentHashMap c(SubscriptionServiceHandler subscriptionServiceHandler) {
        return subscriptionServiceHandler.gO;
    }

    static /* synthetic */ ConcurrentHashMap d(SubscriptionServiceHandler subscriptionServiceHandler) {
        return subscriptionServiceHandler.gP;
    }

    private class b
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(b.class);
        private final Session cf;
        private BlockingQueue<a> du;
        private /* synthetic */ SubscriptionServiceHandler bo;

        public b(SubscriptionServiceHandler subscriptionServiceHandler, Session session, LinkedBlockingQueue<a> linkedBlockingQueue) {
            this.bo = subscriptionServiceHandler;
            this.cf = session;
            this.du = linkedBlockingQueue;
        }

        @Override
        public void run() {
            this.logger.debug("PublishRequestQueueHandler.run");
            while (this.bo.subscriptionManager.isRunning() && this.cf.isActive()) {
                try {
                    a a2;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PublishRequestQueueHandler.run: publishRequestQueue.size={}", (Object)this.du.size());
                    }
                    if ((a2 = this.du.take()) == this.bo.gQ) break;
                    EndpointServiceRequest endpointServiceRequest = a2.o;
                    PublishRequest publishRequest = (PublishRequest)endpointServiceRequest.getRequest();
                    PublishResponse publishResponse = a2.p;
                    ServiceContext serviceContext = a2.serviceContext;
                    try {
                        boolean bl;
                        a a3 = a2;
                        b b2 = this;
                        RequestHeader requestHeader = ((PublishRequest)a3.o.getRequest()).getRequestHeader();
                        long l2 = a3.f();
                        long l3 = requestHeader.getTimeoutHint().getValue();
                        if (l2 <= 0L || l3 <= 0L) {
                            bl = false;
                        } else {
                            long l4;
                            long l5 = System.currentTimeMillis() - l2;
                            boolean bl2 = (double)l4 > (double)l3 * 0.9;
                            b2.logger.debug("publishTimeoutCheck: elapsed={} vs. timeout={} -> {}", new Object[]{l5, l3, bl2});
                            bl = bl2;
                        }
                        if (bl) {
                            this.logger.debug("PublishRequest Timeout: {} - Timestamp= {}", (Object)publishRequest.getRequestHeader(), (Object)DateTime.fromMillis((long)a2.f()));
                            throw new ServiceException(StatusCodes.Bad_Timeout);
                        }
                        this.bo.subscriptionManager.publish(serviceContext, publishRequest, publishResponse);
                    }
                    catch (ServiceException serviceException) {
                        this.bo.handleServiceResultException((ServiceResponse)publishResponse, serviceException);
                    }
                    catch (Exception exception) {
                        this.logger.error("PublishRequestQueueHandler.run", (Throwable)exception);
                        this.bo.handleServiceResultException((ServiceResponse)publishResponse, new ServiceException(new ServiceFaultException((Throwable)exception)));
                    }
                    this.bo.validateResponse((ServiceRequest)publishRequest, (ServiceResponse)publishResponse, serviceContext);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Returning sequence numbers: {}", (Object)Arrays.toString(publishResponse.getAvailableSequenceNumbers()));
                    }
                    endpointServiceRequest.sendResponse((ServiceResponse)publishResponse);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("PublishRequestQueueHandler: interrupted");
                }
            }
            this.logger.debug("PublishRequestQueueHandler: terminated");
        }
    }

    private final class a {
        private final EndpointServiceRequest<PublishRequest, PublishResponse> o;
        private final PublishResponse p;
        private final ServiceContext serviceContext;
        private final long timestamp = System.currentTimeMillis();

        private a(SubscriptionServiceHandler subscriptionServiceHandler, ServiceContext serviceContext, EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest, PublishResponse publishResponse, byte by) {
            this.serviceContext = serviceContext;
            this.o = endpointServiceRequest;
            this.p = publishResponse;
        }

        public final long f() {
            return this.timestamp;
        }

        /* synthetic */ a(SubscriptionServiceHandler subscriptionServiceHandler, ServiceContext serviceContext, EndpointServiceRequest endpointServiceRequest, PublishResponse publishResponse) {
            this(subscriptionServiceHandler, serviceContext, (EndpointServiceRequest<PublishRequest, PublishResponse>)endpointServiceRequest, publishResponse, 0);
        }
    }
}

