/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManagerListener;
import com.prosysopc.ua.server.e;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AggregateFilter;
import org.opcfoundation.ua.core.AggregateFilterResult;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.ContentFilterResult;
import org.opcfoundation.ua.core.CreateSubscriptionRequest;
import org.opcfoundation.ua.core.DataChangeFilter;
import org.opcfoundation.ua.core.DataChangeNotification;
import org.opcfoundation.ua.core.DeadbandType;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ModifySubscriptionRequest;
import org.opcfoundation.ua.core.MonitoredItemCreateRequest;
import org.opcfoundation.ua.core.MonitoredItemModifyRequest;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.MonitoringParameters;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.NotificationMessage;
import org.opcfoundation.ua.core.PublishRequest;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.RepublishRequest;
import org.opcfoundation.ua.core.RepublishResponse;
import org.opcfoundation.ua.core.SetTriggeringRequest;
import org.opcfoundation.ua.core.SetTriggeringResponse;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.SubscriptionAcknowledgement;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static int bB = 3600000;
    private static int bC = 100;
    private static Logger logger = LoggerFactory.getLogger(SubscriptionManager.class);
    private static final long bD = (long)Math.floor(UnsignedInteger.MAX_VALUE.doubleValue() / 3.0);
    private int bE = 0;
    private int maxNotificationsPerPublish = 50000;
    private double bF = bB;
    private int bG = 10;
    private double bH = 3600000.0;
    private int bI = Integer.MAX_VALUE;
    private double bJ = bC;
    private double bK = 1.0;
    private final ConcurrentHashMap<NodeId, a<SubscriptionBase>> bL = new ConcurrentHashMap();
    private volatile boolean running = false;
    private ServerDiagnosticsTypeNode bM;
    private final SessionManagerListener sessionManagerListener = new e(this);
    private SubscriptionDiagnosticsArrayTypeNode bN;
    private final Map<UnsignedInteger, Subscription> bO = new ConcurrentHashMap<UnsignedInteger, Subscription>();
    protected final List<SubscriptionManagerListener> listeners = new CopyOnWriteArrayList<SubscriptionManagerListener>();
    protected final NodeManagerTable nodeManagerTable;
    protected final SessionManager sessionManager;

    private static String a(String charSequence, DateTime dateTime, UnsignedShort unsignedShort) {
        if (dateTime != null && !dateTime.equals((Object)DateTime.MIN_VALUE)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MMM dd (zzz) HH:mm:ss.SSS");
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append(simpleDateFormat.format(dateTime.getCalendar(TimeZone.getDefault()).getTime()));
            if (unsignedShort != null && !unsignedShort.equals((Object)UnsignedShort.valueOf((int)0))) {
                ((StringBuilder)charSequence).append(String.format("/%d picos", unsignedShort.getValue()));
            }
            return ((StringBuilder)charSequence).toString();
        }
        return "";
    }

    public SubscriptionManager(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        this.sessionManager = sessionManager;
        this.nodeManagerTable = nodeManagerTable;
        sessionManager.addListener(this.sessionManagerListener);
    }

    public void addListener(SubscriptionManagerListener subscriptionManagerListener) {
        if (!this.hasListener(subscriptionManagerListener)) {
            this.listeners.add(subscriptionManagerListener);
        }
    }

    public int getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public double getMaxPublishingInterval() {
        return this.bF;
    }

    public int getMaxRetransmissionQueueSize() {
        return this.bG;
    }

    public double getMaxSamplingInterval() {
        return this.bH;
    }

    public int getMaxSubscriptionCount() {
        return this.bI;
    }

    public double getMinPublishingInterval() {
        return this.bJ;
    }

    public double getMinSamplingInterval() {
        return this.bK;
    }

    public NodeManagerTable getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Subscription getSubscription(UnsignedInteger unsignedInteger) throws ServiceException {
        if (unsignedInteger == null || unsignedInteger.equals((Object)UnsignedInteger.ZERO)) {
            logger.debug("SubscriptionId {} not found:", (Object)unsignedInteger);
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        Subscription subscription = this.bO.get(unsignedInteger);
        if (subscription == null) {
            logger.debug("SubscriptionId {} not found:", (Object)unsignedInteger);
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        return subscription;
    }

    public int getSubscriptionCount() {
        return this.bO.size();
    }

    public boolean hasListener(SubscriptionManagerListener subscriptionManagerListener) {
        if (subscriptionManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(subscriptionManagerListener);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void removeListener(SubscriptionManagerListener subscriptionManagerListener) {
        this.listeners.remove(subscriptionManagerListener);
    }

    public void setMaxNotificationsPerPublish(int n2) {
        this.maxNotificationsPerPublish = n2;
    }

    public void setMaxPublishingInterval(double d2) {
        this.bF = d2;
    }

    public void setMaxRetransmissionQueueSize(int n2) {
        this.bG = n2;
    }

    public void setMaxSamplingInterval(double d2) {
        this.bH = d2;
    }

    public void setMaxSubscriptionCount(int n2) {
        this.bI = n2;
    }

    public void setMinPublishingInterval(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("minPublishingInterval must be greater than 0");
        }
        this.bJ = d2;
    }

    public void setMinSamplingInterval(double d2) {
        this.bK = d2;
    }

    private synchronized void a(Subscription subscription) {
        if (this.bM.isEnabledFlag().booleanValue()) {
            this.bM.getServerDiagnosticsSummaryNode().incCumulatedSubscriptionCount();
            this.bM.getServerDiagnosticsSummaryNode().incCurrentSubscriptionCount();
            this.b(subscription).incCurrentSubscriptionsCount();
        }
    }

    private static UnsignedInteger a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        if (unsignedInteger.longValue() < 3L * unsignedInteger2.longValue()) {
            return UnsignedInteger.valueOf((long)(3L * unsignedInteger2.longValue()));
        }
        return unsignedInteger;
    }

    private static UnsignedInteger b(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.longValue() <= 0L) {
            return UnsignedInteger.valueOf((long)1L);
        }
        if (unsignedInteger.longValue() > bD) {
            return UnsignedInteger.valueOf((long)bD);
        }
        return unsignedInteger;
    }

    private double a(Double d2) {
        if (d2.equals(Double.NaN)) {
            return this.getMinPublishingInterval();
        }
        if (d2.equals(0.0)) {
            return this.getMinPublishingInterval();
        }
        if (d2 < this.getMinPublishingInterval()) {
            return this.getMinPublishingInterval();
        }
        if (d2 > this.getMaxPublishingInterval()) {
            return this.getMaxPublishingInterval();
        }
        return d2;
    }

    private MonitoringFilter a(MonitoringParameters monitoringParameters) throws StatusException {
        try {
            monitoringParameters = monitoringParameters.getFilter() == null ? null : (MonitoringFilter)monitoringParameters.getFilter().decode(this.nodeManagerTable.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            throw new StatusException(StatusCodes.Bad_MonitoredItemFilterInvalid, (Throwable)decodingException);
        }
        return monitoringParameters;
    }

    private void a(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAddSubscription(serviceContext, subscription);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAddSubscription", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireAfterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.nodeManagerTable.afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireAfterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.nodeManagerTable.afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterModifyMonitoredItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.nodeManagerTable.afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterModifyMonitoredItem(serviceContext, subscription, monitoredEventItem);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.nodeManagerTable.createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onCreateMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onCreateMonitoredDataItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, EventFilter eventFilter, NodeId nodeId, EventFilterResult eventFilterResult) throws StatusException {
        this.nodeManagerTable.createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onCreateMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onCreateMonitoredEventItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void fireDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.nodeManagerTable.deleteMonitoredItem(serviceContext, subscription, monitoredItem);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onDeleteMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.nodeManagerTable.modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, (MonitoringFilterResult)aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onModifyMonitoredDataItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void a(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.nodeManagerTable.modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onModifyMonitoredEventItem", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private void b(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        for (SubscriptionManagerListener subscriptionManagerListener : this.listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onRemoveSubscription(serviceContext, subscription);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onRemoveSubscription", subscriptionManagerListener, runtimeException);
            }
        }
    }

    private synchronized SessionDiagnosticsVariableTypeNode a(Session session) {
        return session.getDiagnostics().getSessionDiagnosticsNode();
    }

    private SessionDiagnosticsVariableTypeNode b(Subscription subscription) {
        return this.a(subscription.getSession());
    }

    private synchronized void P() {
        this.bM = this.sessionManager.getServerDiagnostics();
        this.bM.addEnabledChangeListener(new DataChangeListener(this){
            private /* synthetic */ SubscriptionManager dl;
            {
                this.dl = subscriptionManager;
            }

            @Override
            public final void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (!dataValue2.isNull() && dataValue2.getValue().booleanValue()) {
                    this.dl.resetDiagnostics();
                }
            }
        });
        this.bN = this.bM.getSubscriptionDiagnosticsArrayNode();
    }

    private void a(Subscription subscription, Session object) {
        object = this.getPublishQueue((Session)object);
        subscription.setPublishQueue((BlockingQueue<SubscriptionBase>)object);
    }

    private static void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    private String a(NotificationMessage dataChangeNotification) {
        dataChangeNotification = dataChangeNotification.getNotificationData();
        try {
            dataChangeNotification = (DataChangeNotification)dataChangeNotification[0].decode(this.nodeManagerTable.getEncoderContext());
            dataChangeNotification = dataChangeNotification.getMonitoredItems()[0];
            dataChangeNotification = dataChangeNotification.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" Status: ");
            stringBuilder.append(dataChangeNotification.getStatusCode());
            if (dataChangeNotification.getStatusCode().isNotBad()) {
                stringBuilder.append(" | Value: ");
                if (dataChangeNotification.isNull()) {
                    stringBuilder.append("NULL");
                } else {
                    Object object = dataChangeNotification.getValue();
                    stringBuilder.append("(" + object.getCompositeClass() + ")");
                    object = dataChangeNotification.getValue().getValue();
                    if (dataChangeNotification.getValue().isArray()) {
                        stringBuilder.append(MultiDimensionArrayUtils.toString((Object)object));
                    } else {
                        stringBuilder.append(object);
                    }
                }
            }
            stringBuilder.append(SubscriptionManager.a(" | ServerTimestamp: ", dataChangeNotification.getServerTimestamp(), dataChangeNotification.getServerPicoseconds()));
            stringBuilder.append(SubscriptionManager.a(" | SourceTimestamp: ", dataChangeNotification.getSourceTimestamp(), dataChangeNotification.getSourcePicoseconds()));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private synchronized void c(Subscription subscription) {
        if (this.bM != null && this.bM.isEnabledFlag().booleanValue()) {
            this.bN.removeSubscription(subscription);
            this.bM.getServerDiagnosticsSummaryNode().setCurrentSubscriptionCount(this.getSubscriptionCount());
            this.b(subscription).decCurrentSubscriptionsCount();
        }
    }

    private synchronized void resetDiagnostics() {
        this.getSessionManager().getServerDiagnostics().getServerDiagnosticsSummaryNode().setCurrentSubscriptionCount(this.getSubscriptionCount());
        for (Subscription subscription : this.bO.values()) {
            this.b(subscription).setCurrentSubscriptionsCount(0);
        }
        for (Subscription subscription : this.bO.values()) {
            this.a(subscription);
            this.b(subscription).setCurrentMonitoredItemsCount(subscription.getItemCount());
        }
    }

    private void a(MonitoredItem monitoredItem, MonitoringParameters monitoringParameters, TimestampsToReturn object) throws StatusException {
        logger.trace("setMonitoringParameters");
        monitoredItem.setTimestampsToReturn((TimestampsToReturn)object);
        if (monitoringParameters != null) {
            monitoredItem.setClientHandle(monitoringParameters.getClientHandle());
            object = monitoringParameters.getDiscardOldest();
            if (object != null) {
                monitoredItem.setDiscardOldest((Boolean)object);
            }
            if (monitoredItem instanceof MonitoredDataItem) {
                Object object2 = monitoringParameters;
                MonitoredItem monitoredItem2 = monitoredItem;
                object = this;
                if ((object2 = object2.getSamplingInterval()) != null && (Double)object2 >= 0.0) {
                    if ((Double)object2 < ((SubscriptionManager)object).getMinSamplingInterval()) {
                        object2 = ((SubscriptionManager)object).getMinSamplingInterval();
                    }
                    if ((Double)object2 > ((SubscriptionManager)object).getMaxSamplingInterval()) {
                        object2 = ((SubscriptionManager)object).getMaxSamplingInterval();
                    }
                    ((MonitoredDataItem)monitoredItem2).setSamplingInterval((Double)object2);
                } else {
                    ((MonitoredDataItem)monitoredItem2).setSamplingInterval(monitoredItem2.getSubscription().getPublishingInterval());
                }
            }
            if ((monitoringParameters = monitoringParameters.getQueueSize()) != null) {
                try {
                    monitoredItem.setQueueSize((UnsignedInteger)monitoringParameters);
                    return;
                }
                catch (ServiceException serviceException) {
                    throw new StatusException(serviceException.getServiceResult());
                }
            }
        }
    }

    private void a(NodeId nodeId, DataChangeFilter dataChangeFilter) throws StatusException {
        Object object;
        DeadbandType deadbandType = DeadbandType.valueOf((UnsignedInteger)dataChangeFilter.getDeadbandType());
        if (deadbandType == null || deadbandType == DeadbandType.None) {
            return;
        }
        try {
            object = new DataValue();
            this.nodeManagerTable.readAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, Attributes.DataType, null, TimestampsToReturn.Neither, DateTime.MIN_VALUE, (DataValue)object);
            object = (NodeId)object.getValue().getValue();
            object = (UaType)this.nodeManagerTable.getNode((NodeId)object);
            if (object == null || !object.inheritsFrom(Identifiers.Number)) {
                throw new Exception("DataType does not inherit from Number");
            }
        }
        catch (Exception exception) {
            logger.debug("DataType not Number", (Throwable)exception);
            throw new StatusException(new StatusCode(StatusCodes.Bad_FilterNotAllowed));
        }
        if (deadbandType == DeadbandType.Percent) {
            if (dataChangeFilter.getDeadbandValue() < 0.0 || dataChangeFilter.getDeadbandValue() > 100.0) {
                throw new StatusException(new StatusCode(StatusCodes.Bad_DeadbandFilterInvalid));
            }
            object = new ArrayList();
            try {
                this.getNodeManagerTable().browseNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, (List<ReferenceDescription>)object, nodeId, 0, BrowseDirection.Forward, Identifiers.HasProperty, true, new QualifiedName("EURange"), NodeClass.ALL, BrowseResultMask.ALL, null, 0);
                if (object.isEmpty()) {
                    throw new StatusException(new StatusCode(StatusCodes.Bad_MonitoredItemFilterUnsupported));
                }
                return;
            }
            catch (ServiceException serviceException) {
                throw new StatusException(new StatusCode(StatusCodes.Bad_MonitoredItemFilterUnsupported));
            }
        }
    }

    protected void acknowledge(ServiceContext serviceContext, PublishRequest subscriptionAcknowledgementArray, PublishResponse publishResponse) {
        if ((subscriptionAcknowledgementArray = subscriptionAcknowledgementArray.getSubscriptionAcknowledgements()) != null) {
            StatusCode[] statusCodeArray = new StatusCode[subscriptionAcknowledgementArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[subscriptionAcknowledgementArray.length];
            this.acknowledgeSubscriptions(serviceContext, subscriptionAcknowledgementArray, statusCodeArray, diagnosticInfoArray);
            publishResponse.setResults(statusCodeArray);
            publishResponse.setDiagnosticInfos(diagnosticInfoArray);
            return;
        }
        publishResponse.setResults(null);
        publishResponse.setDiagnosticInfos(null);
    }

    protected void acknowledgeSubscriptions(ServiceContext serviceContext, SubscriptionAcknowledgement[] subscriptionAcknowledgementArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        logger.debug("acknowledgeSubscriptions length: {}", (Object)subscriptionAcknowledgementArray.length);
        for (int i2 = 0; i2 < subscriptionAcknowledgementArray.length; ++i2) {
            try {
                Object object = subscriptionAcknowledgementArray[i2].getSubscriptionId();
                object = this.getSubscription((UnsignedInteger)object);
                object.acknowledge(subscriptionAcknowledgementArray[i2].getSequenceNumber());
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ack error: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
    }

    protected SubscriptionBase addSubscription(ServiceContext serviceContext, CreateSubscriptionRequest object) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("addSubscription");
        }
        if (serviceContext.getSession().getSubscriptionCount() >= this.getMaxSubscriptionCount()) {
            throw new ServiceException("Max allowed subscriptions = " + this.getMaxSubscriptionCount(), StatusCodes.Bad_TooManySubscriptions);
        }
        double d2 = this.a(object.getRequestedPublishingInterval());
        UnsignedInteger unsignedInteger = SubscriptionManager.b(object.getRequestedMaxKeepAliveCount());
        UnsignedInteger unsignedInteger2 = SubscriptionManager.a(object.getRequestedLifetimeCount(), unsignedInteger);
        UnsignedInteger unsignedInteger3 = this.nextSubscriptionId();
        object = new Subscription(this, unsignedInteger3, object.getPublishingEnabled(), d2, unsignedInteger2, unsignedInteger, object.getMaxNotificationsPerPublish(), object.getPriority());
        Session session = serviceContext.getSession();
        this.a(serviceContext, (Subscription)object);
        ((Subscription)object).setSession(session);
        this.bO.put(unsignedInteger3, (Subscription)object);
        if (logger.isDebugEnabled()) {
            logger.debug("addSubscription: subscription=" + object);
        }
        this.a((Subscription)object, session);
        this.a((Subscription)object);
        return object;
    }

    protected void addTriggeringLink(Subscription object, MonitoredItemBase monitoredItemBase, UnsignedInteger unsignedInteger) throws StatusException {
        object = (MonitoredItem)((SubscriptionBase)object).getItem(unsignedInteger);
        ((MonitoredItem)monitoredItemBase).addLink((MonitoredItem)object);
    }

    protected NumericRange checkIndexRangeForMonitoredItem(String string, UnsignedInteger unsignedInteger) throws ServiceException {
        try {
            return NumericRange.parse((String)string);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    protected void checkSession(ServiceContext serviceContext, Subscription subscription) throws ServiceException {
        if (!subscription.getSession().equals(serviceContext.getSession())) {
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
    }

    protected void close() {
        logger.debug("close");
        for (Subscription subscription : this.bO.values()) {
            subscription.internalClose(false);
        }
        this.running = false;
    }

    protected MonitoredDataItem createMonitoredDataItem(ServiceContext object, Subscription subscription, MonitoredItemCreateRequest monitoredItemCreateRequest, TimestampsToReturn timestampsToReturn, MonitoringFilter monitoringFilter) throws ServiceException, StatusException {
        UnsignedInteger unsignedInteger;
        timestampsToReturn = monitoredItemCreateRequest.getItemToMonitor();
        NodeId nodeId = timestampsToReturn.getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredDataItem: " + nodeId);
        }
        if (!AttributesUtil.isValid((UnsignedInteger)(unsignedInteger = timestampsToReturn.getAttributeId()))) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
        if (monitoringFilter != null && !unsignedInteger.equals((Object)Attributes.Value)) {
            throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
        }
        if (monitoringFilter instanceof DataChangeFilter) {
            this.a(nodeId, (DataChangeFilter)monitoringFilter);
        }
        QualifiedName qualifiedName = timestampsToReturn.getDataEncoding();
        SubscriptionManager.a(monitoredItemCreateRequest.getMonitoringMode());
        timestampsToReturn = this.checkIndexRangeForMonitoredItem(timestampsToReturn.getIndexRange(), unsignedInteger);
        MonitoringParameters monitoringParameters = monitoredItemCreateRequest.getRequestedParameters();
        AggregateFilterResult aggregateFilterResult = monitoringFilter instanceof AggregateFilter ? new AggregateFilterResult() : null;
        this.a((ServiceContext)object, subscription, nodeId, unsignedInteger, (NumericRange)timestampsToReturn, monitoringParameters, monitoringFilter, aggregateFilterResult);
        object = subscription.addDataItem((ServiceContext)object, nodeId, unsignedInteger, (NumericRange)timestampsToReturn, qualifiedName, monitoredItemCreateRequest.getMonitoringMode());
        ((MonitoredItem)object).setFilter(monitoringFilter);
        ((MonitoredItem)object).setFilterResult((MonitoringFilterResult)aggregateFilterResult);
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredDataItem: " + object);
        }
        return object;
    }

    protected MonitoredItem createMonitoredEventItem(ServiceContext object, Subscription subscription, MonitoredItemCreateRequest monitoredItemCreateRequest, EventFilter eventFilter) throws StatusException {
        monitoredItemCreateRequest = monitoredItemCreateRequest.getItemToMonitor().getNodeId();
        if (logger.isDebugEnabled()) {
            logger.debug("createMonitoredEventItem: " + monitoredItemCreateRequest);
        }
        EventFilterResult eventFilterResult = new EventFilterResult();
        eventFilterResult.setSelectClauseResults(new StatusCode[eventFilter.getSelectClauses().length]);
        eventFilterResult.setSelectClauseDiagnosticInfos(new DiagnosticInfo[eventFilter.getSelectClauses().length]);
        eventFilterResult.setWhereClauseResult(new ContentFilterResult());
        this.a((ServiceContext)object, subscription, eventFilter, (NodeId)monitoredItemCreateRequest, eventFilterResult);
        object = subscription.addEventItem((ServiceContext)object, (NodeId)monitoredItemCreateRequest, eventFilter, eventFilterResult);
        return object;
    }

    protected MonitoredItem createMonitoredItem(ServiceContext iterator, Subscription subscription, TimestampsToReturn object, MonitoredItemCreateRequest object2) throws StatusException, ServiceException {
        MonitoredItem monitoredItem;
        Object object3 = object2.getRequestedParameters();
        MonitoringFilter object42 = this.a((MonitoringParameters)object3);
        if (object2.getItemToMonitor().getAttributeId().equals((Object)Attributes.EventNotifier) && object42 != null) {
            if (!(object42 instanceof EventFilter)) {
                throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
            }
            monitoredItem = this.createMonitoredEventItem((ServiceContext)((Object)iterator), subscription, (MonitoredItemCreateRequest)object2, (EventFilter)object42);
        } else {
            if (object42 instanceof EventFilter) {
                throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
            }
            if (object42 instanceof AggregateFilter) {
                throw new StatusException(StatusCodes.Bad_FilterNotAllowed);
            }
            monitoredItem = this.createMonitoredDataItem((ServiceContext)((Object)iterator), subscription, (MonitoredItemCreateRequest)object2, (TimestampsToReturn)object, object42);
        }
        NodeId nodeId = object2.getItemToMonitor().getNodeId();
        object2 = this.nodeManagerTable.findNode(nodeId);
        if (object2 != null) {
            monitoredItem.setNode((UaNode)object2);
        }
        this.a(monitoredItem, (MonitoringParameters)object3, (TimestampsToReturn)object);
        object3 = monitoredItem;
        object2 = subscription;
        object = iterator;
        iterator = this;
        if (object3 instanceof MonitoredEventItem) {
            ((SubscriptionManager)((Object)iterator)).nodeManagerTable.afterCreateMonitoredEventItem((ServiceContext)object, (Subscription)object2, (MonitoredEventItem)object3);
        } else {
            ((SubscriptionManager)((Object)iterator)).nodeManagerTable.afterCreateMonitoredDataItem((ServiceContext)object, (Subscription)object2, (MonitoredDataItem)object3);
        }
        for (SubscriptionManagerListener subscriptionManagerListener : ((SubscriptionManager)((Object)iterator)).listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onAfterCreateMonitoredItem((ServiceContext)object, (Subscription)object2, (MonitoredItem)object3);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAfterCreateMonitoredItem", subscriptionManagerListener, runtimeException);
            }
        }
        if (this.bM.isEnabledFlag().booleanValue() && subscription.getSession() != null) {
            this.b(subscription).incCurrentMonitoredItemsCount();
        }
        return monitoredItem;
    }

    protected MonitoredItemBase deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger object) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("deleteMonitoredItem: " + subscription + " ItemId=" + object);
        }
        object = (MonitoredItem)subscription.getItem((UnsignedInteger)object);
        this.fireDeleteMonitoredItem(serviceContext, subscription, (MonitoredItem)object);
        try {
            subscription.internalRemoveItem((MonitoredItem)object);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        if (this.bM.isEnabledFlag().booleanValue()) {
            this.b(subscription).decCurrentMonitoredItemsCount();
        }
        this.fireAfterDeleteMonitoredItem(serviceContext, subscription, (MonitoredItem)object);
        return object;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected Subscription getNextSubscriptionToPublish(ServiceContext object, long l2) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: session=" + ((ServiceContext)object).getSession());
        }
        if (!this.isRunning()) {
            throw new ServiceException(StatusCodes.Bad_NoSubscription);
        }
        if (!((Session)(object = ((ServiceContext)object).getSession())).isActive()) {
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        Subscription subscription = ((Session)object).getTransferredSubscriptions().poll();
        if (subscription != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNextSubscriptionToPublish: transferred=" + subscription);
            }
            return subscription;
        }
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue((Session)object);
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: queue=" + blockingQueue);
        }
        if (blockingQueue != null) {
            try {
                long l3 = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug("getNextSubscriptionToPublish: subscriptionCount=" + ((Session)object).getSubscriptionCount());
                }
                if (((Session)object).getSubscriptionCount() == 0) {
                    subscription = (Subscription)blockingQueue.poll();
                } else if (l2 > 0L) {
                    subscription = (Subscription)blockingQueue.poll(l2, TimeUnit.MILLISECONDS);
                    if (subscription == null) {
                        throw new ServiceException(StatusCodes.Bad_Timeout);
                    }
                } else {
                    subscription = (Subscription)blockingQueue.take();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("getNextSubscriptionToPublish: subscription=" + subscription + "; dt=" + (System.currentTimeMillis() - l3));
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug("getNextSubscriptionToPublish interrupted", (Throwable)interruptedException);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNextSubscriptionToPublish: " + subscription);
        }
        if (subscription == null) {
            throw new ServiceException(StatusCodes.Bad_NoSubscription);
        }
        return subscription;
    }

    protected BlockingQueue<SubscriptionBase> getPublishQueue(Session object) {
        if (object == null) {
            return null;
        }
        a<SubscriptionBase> a2 = this.bL.get(((Session)object).getAuthenticationToken());
        if (a2 == null) {
            a2 = new a(this, (Session)object);
            if ((object = this.bL.putIfAbsent(((Session)object).getAuthenticationToken(), a2)) != null) {
                return object;
            }
        }
        return a2;
    }

    protected MonitoredItem modifyMonitoredItem(ServiceContext serviceContext, Subscription object, MonitoredItemModifyRequest object2, TimestampsToReturn object3, MonitoringParameters object4) throws StatusException {
        object2 = (MonitoredItem)((SubscriptionBase)object).getItem(object2.getMonitoredItemId());
        Object object5 = this.a((MonitoringParameters)object4);
        if (object2 instanceof MonitoredEventItem) {
            EventFilter eventFilter = (EventFilter)object5;
            object5 = (MonitoredEventItem)object2;
            object4 = object;
            object3 = serviceContext;
            object = this;
            try {
                EventFilterResult eventFilterResult = new EventFilterResult();
                eventFilterResult.setSelectClauseResults(new StatusCode[eventFilter.getSelectClauses().length]);
                eventFilterResult.setSelectClauseDiagnosticInfos(new DiagnosticInfo[eventFilter.getSelectClauses().length]);
                eventFilterResult.setWhereClauseResult(new ContentFilterResult());
                super.a((ServiceContext)object3, (Subscription)object4, (MonitoredEventItem)object5, eventFilter, eventFilterResult);
                ((MonitoredItem)object5).setFilterResult((MonitoringFilterResult)eventFilterResult);
                ((MonitoredItem)object5).setFilter((MonitoringFilter)eventFilter);
                super.a((ServiceContext)object3, (Subscription)object4, (MonitoredEventItem)object5);
            }
            catch (ClassCastException classCastException) {
                throw new StatusException(classCastException.getMessage(), StatusCodes.Bad_EventFilterInvalid);
            }
            catch (ServiceException serviceException) {
                throw new StatusException(serviceException.getServiceResult());
            }
        }
        MonitoringFilter monitoringFilter = object5;
        MonitoredDataItem monitoredDataItem = (MonitoredDataItem)object2;
        MonitoringParameters monitoringParameters = object4;
        object5 = object3;
        object4 = object;
        object3 = serviceContext;
        object = this;
        AggregateFilterResult aggregateFilterResult = null;
        if (monitoringFilter instanceof AggregateFilter) {
            aggregateFilterResult = new AggregateFilterResult();
        }
        if (monitoringFilter instanceof DataChangeFilter) {
            super.a(monitoredDataItem.getNodeId(), (DataChangeFilter)monitoringFilter);
        }
        super.a((ServiceContext)object3, (Subscription)object4, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
        super.a(monitoredDataItem, monitoringParameters, (TimestampsToReturn)object5);
        if (monitoringFilter != null) {
            try {
                monitoredDataItem.setFilter(monitoringFilter);
            }
            catch (ServiceException serviceException) {
                throw new StatusException(serviceException.getServiceResult());
            }
            monitoredDataItem.setFilterResult((MonitoringFilterResult)aggregateFilterResult);
        }
        super.fireAfterModifyMonitoredDataItem((ServiceContext)object3, (Subscription)object4, monitoredDataItem);
        ((MonitoredItem)object2).setServiceContext(serviceContext);
        return object2;
    }

    protected SubscriptionBase modifySubscription(ServiceContext iterator, ModifySubscriptionRequest object) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("modifySubscription");
        }
        Subscription subscription = this.getSubscription(object.getSubscriptionId());
        this.checkSession((ServiceContext)((Object)iterator), subscription);
        double d2 = this.a(object.getRequestedPublishingInterval());
        UnsignedInteger unsignedInteger = SubscriptionManager.b(object.getRequestedMaxKeepAliveCount());
        UnsignedInteger unsignedInteger2 = SubscriptionManager.a(object.getRequestedLifetimeCount(), unsignedInteger);
        subscription.setMaxNotificationsPerPublish(object.getMaxNotificationsPerPublish());
        subscription.setLifetimeCount(unsignedInteger2);
        subscription.setMaxKeepAliveCount(unsignedInteger);
        subscription.setPublishingInterval(d2);
        subscription.setPriority(object.getPriority());
        subscription.resetLastAliveTime();
        Subscription subscription2 = subscription;
        object = iterator;
        iterator = this;
        for (SubscriptionManagerListener subscriptionManagerListener : ((SubscriptionManager)((Object)iterator)).listeners) {
            if (subscriptionManagerListener == null) continue;
            try {
                subscriptionManagerListener.onModifySubscription((ServiceContext)object, subscription2);
            }
            catch (RuntimeException runtimeException) {
                SubscriptionManager.listenerError("onAfterModifySubscription", subscriptionManagerListener, runtimeException);
            }
        }
        return subscription;
    }

    protected UnsignedInteger nextSubscriptionId() {
        return UnsignedInteger.valueOf((long)(++this.bE));
    }

    protected void publish(ServiceContext serviceContext, PublishRequest publishRequest, PublishResponse publishResponse) throws ServiceException {
        Subscription subscription;
        if (logger.isTraceEnabled()) {
            logger.debug("publish(session=" + serviceContext.getSession().getSessionName() + "): " + publishRequest);
        } else if (logger.isDebugEnabled()) {
            logger.debug("publish(session=" + serviceContext.getSession().getSessionName() + "): " + publishRequest.getClass().getSimpleName());
        }
        try {
            long l2 = publishRequest.getRequestHeader().getTimeoutHint().getValue();
            subscription = this.getNextSubscriptionToPublish(serviceContext, l2);
            if (logger.isDebugEnabled()) {
                logger.debug("publish: subscription=" + subscription);
            }
        }
        catch (ServiceException serviceException) {
            publishResponse.setSubscriptionId(UnsignedInteger.valueOf((long)0L));
            logger.debug("ServiceException: ", (Throwable)serviceException);
            throw serviceException;
        }
        NotificationMessage notificationMessage = subscription.getNextNotificationMessage(serviceContext.getSession());
        publishResponse.setSubscriptionId(subscription.getSubscriptionId());
        publishResponse.setAvailableSequenceNumbers(subscription.getAvailableSequenceNumbers());
        if (logger.isDebugEnabled()) {
            logger.debug("publish: Available sequence numbers on Subscription " + subscription.getSubscriptionId().toString() + ": " + Arrays.toString(publishResponse.getAvailableSequenceNumbers()));
        }
        publishResponse.setNotificationMessage(notificationMessage);
        publishResponse.setMoreNotifications(subscription.hasMoreNotifications());
        if (logger.isDebugEnabled()) {
            logger.debug("publish: Notification data: " + publishResponse.getNotificationMessage().getNotificationData());
            logger.debug("publish: MoreNotifications=" + publishResponse.getMoreNotifications());
        }
        publishResponse.setDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics((ServiceRequest)publishRequest, publishResponse.getDiagnosticInfos()));
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder().append("publish: subscriptionId=").append(publishResponse.getSubscriptionId()).append("; SN=").append(publishResponse.getNotificationMessage().getSequenceNumber());
            publishResponse.getSubscriptionId();
            logger.debug(stringBuilder.append(this.a(notificationMessage)).toString());
        }
    }

    protected void removeSubscription(ServiceContext serviceContext, Subscription subscription, boolean bl) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("removeSubscription: subscription=" + subscription);
        }
        Session session = serviceContext.getSession();
        if (serviceContext != ServiceContext.INTERNAL_OPERATION_CONTEXT && !subscription.getSession().equals(session)) {
            throw new ServiceException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
        this.b(serviceContext, subscription);
        this.c(subscription);
        subscription.internalClose(bl);
        this.bO.remove(subscription.getSubscriptionId());
        if (logger.isDebugEnabled()) {
            logger.debug("removeSubscription: subscriptions=" + Arrays.toString(this.bO.keySet().toArray()));
        }
    }

    protected void removeTriggeringLink(SubscriptionBase object, MonitoredItemBase monitoredItemBase, UnsignedInteger unsignedInteger) throws StatusException {
        object = (MonitoredItem)((SubscriptionBase)object).getItem(unsignedInteger);
        ((MonitoredItem)monitoredItemBase).removeLink((MonitoredItem)object);
    }

    protected void republish(ServiceContext serviceContext, RepublishRequest republishRequest, RepublishResponse republishResponse) throws ServiceException {
        Subscription subscription = this.getSubscription(republishRequest.getSubscriptionId());
        this.checkSession(serviceContext, subscription);
        republishResponse.setNotificationMessage(subscription.getNotificationMessage(republishRequest.getRetransmitSequenceNumber()));
    }

    protected void setMonitoringMode(ServiceContext serviceContext, Subscription subscription, UnsignedInteger object, MonitoringMode monitoringMode) throws ServiceException, StatusException {
        this.checkSession(serviceContext, subscription);
        object = subscription.getItem((UnsignedInteger)object);
        object.setMonitoringMode(monitoringMode);
        if (object instanceof MonitoredEventItem) {
            this.a(serviceContext, subscription, (MonitoredEventItem)object);
            return;
        }
        this.fireAfterModifyMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)object);
    }

    protected void setPublishingMode(ServiceContext serviceContext, UnsignedInteger object, Boolean bl) throws ServiceException, StatusException {
        object = this.getSubscription((UnsignedInteger)object);
        this.checkSession(serviceContext, (Subscription)object);
        ((SubscriptionBase)object).setPublishingEnabled(bl);
        ((Subscription)object).resetLastAliveTime();
    }

    protected void setTriggering(ServiceContext object, SetTriggeringRequest setTriggeringRequest, SetTriggeringResponse setTriggeringResponse) throws ServiceException {
        MonitoredItemBase monitoredItemBase;
        object = this.getSubscription(setTriggeringRequest.getSubscriptionId());
        try {
            monitoredItemBase = ((SubscriptionBase)object).getItem(setTriggeringRequest.getTriggeringItemId());
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getMessage(), statusException.getStatusCode());
        }
        UnsignedInteger[] unsignedIntegerArray = setTriggeringRequest.getLinksToAdd();
        UnsignedInteger[] unsignedIntegerArray2 = setTriggeringRequest.getLinksToRemove();
        if (unsignedIntegerArray.length == 0 && unsignedIntegerArray2.length == 0) {
            throw new ServiceException(StatusCodes.Bad_NothingToDo);
        }
        StatusCode[] statusCodeArray = new StatusCode[unsignedIntegerArray2.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[unsignedIntegerArray2.length];
        for (int i2 = 0; i2 < unsignedIntegerArray2.length; ++i2) {
            try {
                this.removeTriggeringLink((SubscriptionBase)object, monitoredItemBase, unsignedIntegerArray2[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Error while removeTriggeringLink", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        setTriggeringResponse.setRemoveResults(statusCodeArray);
        setTriggeringResponse.setRemoveDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics((ServiceRequest)setTriggeringRequest, diagnosticInfoArray));
        StatusCode[] statusCodeArray2 = new StatusCode[unsignedIntegerArray.length];
        DiagnosticInfo[] diagnosticInfoArray2 = new DiagnosticInfo[unsignedIntegerArray.length];
        for (int i3 = 0; i3 < unsignedIntegerArray.length; ++i3) {
            try {
                this.addTriggeringLink((Subscription)object, monitoredItemBase, unsignedIntegerArray[i3]);
                statusCodeArray2[i3] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Error while addTriggeringLink", (Throwable)statusException);
                statusCodeArray2[i3] = statusException.getStatusCode();
                diagnosticInfoArray2[i3] = statusException.getDiagnosticInfo();
            }
        }
        setTriggeringResponse.setAddResults(statusCodeArray2);
        setTriggeringResponse.setAddDiagnosticInfos(ServiceHandler.validateOperationalDiagnostics((ServiceRequest)setTriggeringRequest, diagnosticInfoArray2));
    }

    protected void start() {
        this.P();
        this.running = true;
    }

    protected Subscription transferSubscription(ServiceContext serviceContext, UnsignedInteger object) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscription: ID=" + object);
            logger.debug("serviceContext=" + serviceContext);
        }
        Session session = serviceContext.getSession();
        if (logger.isDebugEnabled()) {
            logger.debug("session=" + session);
        }
        object = this.getSubscription((UnsignedInteger)object);
        if (logger.isDebugEnabled()) {
            logger.debug("subscription=" + object);
            logger.debug("subscription.getSession()=" + ((Subscription)object).getSession());
            logger.debug("subscription.getSession().getUserIdentity()=" + ((Subscription)object).getSession().getUserIdentity());
            logger.debug("session.getUserIdentity()=" + session.getUserIdentity());
        }
        if (!((Subscription)object).getSession().getUserIdentity().equals(session.getUserIdentity())) {
            throw new ServiceException(StatusCodes.Bad_UserAccessDenied);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("subscription.getSession().getTransferredSubscriptions()=" + ((Subscription)object).getSession().getTransferredSubscriptions());
        }
        ((Subscription)object).getSession().getTransferredSubscriptions().add((Subscription)object);
        ((Subscription)object).setSession(session);
        if (logger.isDebugEnabled()) {
            logger.debug("subscription.getItems()=" + Arrays.toString(((SubscriptionBase)object).getItems()));
        }
        for (MonitoredItemBase monitoredItemBase : ((SubscriptionBase)object).getItems()) {
            ((MonitoredItem)monitoredItemBase).setServiceContext(serviceContext);
        }
        this.a((Subscription)object, session);
        return object;
    }

    static void a(MonitoringMode monitoringMode) throws ServiceException {
        if (monitoringMode == null) {
            throw new ServiceException(StatusCodes.Bad_MonitoringModeInvalid);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void a(SubscriptionManager object, Session session, Subscription subscription) {
        subscription = null;
        logger.debug("removePublishQueue: session={} subscription={}", (Object)session, (Object)subscription);
        object = ((SubscriptionManager)object).bL.remove(session.getAuthenticationToken());
        if (object != null && logger.isDebugEnabled()) {
            logger.debug("removePublishQueue: queue={}", (Object)Arrays.toString(object.toArray()));
        }
        if (object != null && object.isEmpty() && subscription != null) {
            object.offer(subscription);
        }
    }

    static /* synthetic */ Map a(SubscriptionManager subscriptionManager) {
        return subscriptionManager.bO;
    }

    private final class a<T>
    extends PriorityBlockingQueue<T> {
        private final Session cf;

        public a(SubscriptionManager subscriptionManager, Session session) {
            this.cf = session;
        }

        @Override
        public final String toString() {
            a a2 = this;
            return "Session=" + a2.cf + " Elements=" + super.toString();
        }
    }
}

