/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.DataChangeNotification;
import org.opcfoundation.ua.core.EventFieldList;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.EventNotificationList;
import org.opcfoundation.ua.core.MonitoredItemNotification;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.core.NotificationMessage;
import org.opcfoundation.ua.core.StatusChangeNotification;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.utils.NumericRange;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    private volatile boolean closed;
    private final AtomicBoolean bS = new AtomicBoolean(true);
    private final AtomicBoolean bT = new AtomicBoolean(true);
    private final AtomicInteger bU = new AtomicInteger(0);
    private final AtomicReference<DateTime> bV = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong bW = new AtomicLong(0L);
    private final AtomicReference<DateTime> bX = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong bY = new AtomicLong(0L);
    private volatile MonitoredItemBase bZ;
    private final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final AtomicLong ca = new AtomicLong(1L);
    private ScheduledExecutorService cb;
    private final AtomicReference<BlockingQueue<SubscriptionBase>> cc = new AtomicReference();
    private ScheduledFuture<?> cd;
    private final Map<UnsignedInteger, NotificationMessage> ce = new ConcurrentHashMap<UnsignedInteger, NotificationMessage>();
    private volatile Session cf;
    private final SessionManagerListener sessionManagerListener = new h(this);
    private volatile SubscriptionManager subscriptionManager;
    private final Map<UnsignedInteger, MonitoredItem> cg = new ConcurrentHashMap<UnsignedInteger, MonitoredItem>();

    public Subscription(SubscriptionManager subscriptionManager, UnsignedInteger unsignedInteger, Boolean bl, Double d2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedInteger unsignedInteger4, UnsignedByte unsignedByte) {
        super(unsignedInteger, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger4, unsignedByte);
        if (subscriptionManager == null) {
            throw new NullPointerException("subscriptionManager required");
        }
        this.subscriptionManager = subscriptionManager;
        subscriptionManager.getSessionManager().addListener(this.sessionManagerListener);
    }

    public MonitoredDataItem addDataItem(ServiceContext object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        this.logger.trace("addDataItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        if (monitoringMode == null) {
            throw new NullPointerException("monitoringMode");
        }
        if (unsignedInteger.equals((Object)Attributes.EventNotifier)) {
            throw new IllegalArgumentException("addItem called with EventNotifier, use addEventItme instead");
        }
        object = new MonitoredDataItem((ServiceContext)object, this, this.W(), nodeId, unsignedInteger, numericRange, monitoringMode);
        this.addItem((MonitoredItemBase)object, ((MonitoredItemBase)object).getMonitoredItemId());
        return object;
    }

    public MonitoredDataItem addDataItem(ServiceContext object, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        object = this.addDataItem((ServiceContext)object, uaNode.getNodeId(), unsignedInteger, numericRange, qualifiedName, monitoringMode);
        ((MonitoredItem)object).setNode(uaNode);
        return object;
    }

    public MonitoredEventItem addEventItem(ServiceContext object, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.logger.debug("addEventItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        object = new MonitoredEventItem((ServiceContext)object, this, this.W(), nodeId, eventFilter, eventFilterResult);
        this.addItem((MonitoredItemBase)object, ((MonitoredItemBase)object).getMonitoredItemId());
        return object;
    }

    public void close() throws ServiceException {
        this.logger.debug("close");
        if (this.subscriptionManager != null) {
            this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
            this.subscriptionManager.removeSubscription(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, false);
        }
    }

    @Override
    public int compareTo(SubscriptionBase subscriptionBase) {
        Subscription subscription = (Subscription)subscriptionBase;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        BlockingQueue<SubscriptionBase> blockingQueue2 = subscription.getPublishQueue();
        if (blockingQueue == null && blockingQueue2 != null) {
            return 1;
        }
        if (blockingQueue != null && blockingQueue2 == null) {
            return -1;
        }
        if (this.V() && !subscription.V()) {
            return 1;
        }
        if (!this.V() && subscription.V()) {
            return -1;
        }
        int n2 = super.compareTo(subscriptionBase);
        if (n2 == 0 && subscriptionBase instanceof Subscription) {
            return subscription.U().compareTo(this.U());
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SubscriptionBase)object;
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        object = ((SubscriptionBase)object).getSubscriptionId();
        return !(unsignedInteger == null ? object != null : !unsignedInteger.equals(object));
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        Object[] objectArray = this.ce.keySet().toArray(new UnsignedInteger[this.ce.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    @Override
    public int getMaxNotificationsPerPublish() {
        int n2 = super.getMaxNotificationsPerPublish();
        try {
            if (n2 == 0 || n2 > this.subscriptionManager.getMaxNotificationsPerPublish()) {
                n2 = this.subscriptionManager.getMaxNotificationsPerPublish();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return n2;
    }

    public Session getSession() {
        return this.cf;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public boolean hasExpired() {
        long l2;
        Subscription subscription = this;
        long l3 = DateTime.currentTime().getTimeInMillis() - subscription.bV.get().getTimeInMillis();
        boolean bl = (double)l2 > (double)this.lifetimeCount * this.publishingInterval;
        this.logger.trace("hasExpired: result={} lifetimeCount={} publishingInterval={} elapsed={}", new Object[]{bl, this.lifetimeCount, this.publishingInterval, l3});
        return bl;
    }

    public int hashCode() {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        int n2 = 31 + (unsignedInteger == null ? 0 : unsignedInteger.hashCode());
        return n2;
    }

    public Boolean hasMoreNotifications() {
        boolean bl;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        boolean bl2 = bl = blockingQueue != null && blockingQueue.contains(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("hasMoreNotifications: lastSentItem={}", (Object)this.bZ);
            this.logger.trace("hasMoreNotifications: hasMoreDataChangeNotifications={}", (Object)this.bS.get());
            this.logger.trace("hasMoreNotifications: hasMoreEventNotifications={}", (Object)this.bT.get());
            this.logger.trace("hasMoreNotifications: isInQueue={}", (Object)bl);
        }
        return this.bZ != null || this.bS.get() || this.bT.get() || bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        return this.removeItem(monitoredItemBase.getMonitoredItemId());
    }

    @Override
    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.subscriptionManager.deleteMonitoredItem(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, unsignedInteger);
    }

    public void start() {
        this.logger.debug("start");
        this.startPublishing();
    }

    private List<ExtensionObject> a(List<ExtensionObject> list, NotificationData notificationData, Session session) {
        if (list == null) {
            list = new ArrayList<ExtensionObject>();
        }
        try {
            list.add(ExtensionObject.binaryEncode((Structure)notificationData, (EncoderContext)session.getSessionManager().getServer().getEncoderContext()));
        }
        catch (EncodingException encodingException) {
            this.logger.error("EncodingException: ", (Throwable)encodingException);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.error("Invalid session: {}", (Object)session);
        }
        return list;
    }

    private void b(NotificationMessage notificationMessage) {
        if (!this.isClosed()) {
            int n2;
            this.ce.put(notificationMessage.getSequenceNumber(), notificationMessage);
            int n3 = n2 = this.subscriptionManager == null ? 0 : this.subscriptionManager.getMaxRetransmissionQueueSize();
            while (this.ce.size() > n2) {
                this.ce.remove(Collections.min(this.ce.keySet()));
            }
        }
    }

    private void Q() {
        long l2 = Subscription.T();
        if (this.bY.get() != 0L && this.isTimeToPublish(l2)) {
            this.addToPublishQueue(l2, false);
        }
    }

    private DataChangeNotification R() {
        this.logger.trace("getDataChangeNotification");
        DataChangeNotification dataChangeNotification = new DataChangeNotification();
        ArrayList<MonitoredItemNotification> arrayList = new ArrayList<MonitoredItemNotification>();
        boolean bl = false;
        int n2 = this.getMaxNotificationsPerPublish();
        MonitoredItemBase monitoredItemBase = null;
        while (!this.items.isEmpty()) {
            this.bS.set(false);
            for (MonitoredItemBase monitoredItemBase2 : this.items.values()) {
                if (this.bZ != null) {
                    if (monitoredItemBase2 != this.bZ) continue;
                    this.bZ = null;
                    continue;
                }
                this.bZ = null;
                if (!(monitoredItemBase2 instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBase2;
                if (bl) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("getDataChangeNotification: monitoredItemId={} hasMoreSamples={}", (Object)monitoredItemBase2.getMonitoredItemId(), (Object)monitoredDataItem.hasMoreSamples());
                    }
                    if (!monitoredDataItem.hasMoreSamples()) continue;
                    this.bZ = monitoredItemBase;
                    break;
                }
                DataValue dataValue = monitoredDataItem.getNextSample(this.cg.containsKey(monitoredDataItem.getMonitoredItemId()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getDataChangeNotification: dataItem.MonitoredItemId={} nodeId={} value={}", new Object[]{monitoredDataItem.getMonitoredItemId(), monitoredDataItem.getNodeId(), dataValue});
                    this.logger.debug("getDataChangeNotification: hasMoreSamples={}", (Object)monitoredDataItem.hasMoreSamples());
                }
                if (!monitoredDataItem.hasMoreSamples()) {
                    this.cg.remove(monitoredDataItem.getMonitoredItemId());
                }
                if (dataValue == null) continue;
                arrayList.add(new MonitoredItemNotification(monitoredItemBase2.getClientHandle(), dataValue));
                if (monitoredDataItem.hasMoreSamples()) {
                    this.bS.set(true);
                }
                if (n2 <= 0 || arrayList.size() < n2) continue;
                bl = true;
                monitoredItemBase = monitoredItemBase2;
                this.logger.debug("isFull");
            }
            if (this.bS.get() && !bl) continue;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getDataChangeNotification: notifications.size()={}", (Object)arrayList.size());
        }
        dataChangeNotification.setMonitoredItems(arrayList.toArray(new MonitoredItemNotification[arrayList.size()]));
        return dataChangeNotification;
    }

    private EventNotificationList S() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getEventNotifications");
        }
        ArrayList<EventFieldList> arrayList = new ArrayList<EventFieldList>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).getEvents(arrayList);
        }
        return new EventNotificationList(arrayList.toArray(new EventFieldList[0]));
    }

    private static long T() {
        return new GregorianCalendar().getTimeInMillis();
    }

    private DateTime U() {
        return this.bX.get();
    }

    private boolean V() {
        return (double)DateTime.currentTime().getTimeInMillis() > (double)this.U().getTimeInMillis() + (double)this.getMaxKeepAliveCount() * this.publishingInterval;
    }

    private UnsignedInteger W() {
        return UnsignedInteger.valueOf((long)this.bW.incrementAndGet());
    }

    private void removeAllItems() {
        for (Map.Entry entry : this.items.entrySet()) {
            MonitoredItemBase object = (MonitoredItemBase)entry.getValue();
            try {
                this.removeItem(object);
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Exception while removing all items: item=" + object.getMonitoredItemId() + " of subscription " + this.getSubscriptionId() + " of session " + this.getSession() + ". Exception=" + exception.getMessage());
            }
        }
    }

    private void X() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredDataItem) || ((MonitoredDataItem)(monitoredItemBase = (MonitoredDataItem)monitoredItemBase)).hasMoreSamples()) continue;
            ((MonitoredDataItem)monitoredItemBase).addNewSample(((MonitoredDataItem)monitoredItemBase).getLastValue(), false);
        }
    }

    private void Y() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            if (monitoredItemBase instanceof MonitoredDataItem) {
                ((MonitoredDataItem)monitoredItemBase).updateQueue();
                continue;
            }
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).updateQueue();
        }
    }

    protected void acknowledge(UnsignedInteger unsignedInteger) throws ServiceException {
        if (this.ce.remove(unsignedInteger) == null) {
            this.logger.info("Acknowledge on Subscription " + this.getSubscriptionId().toString() + ": " + unsignedInteger + " - Bad_SequenceNumberUnknown");
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
            diagnosticInfo.setAdditionalInfo(unsignedInteger.toString());
            throw new ServiceException("Cannot acknowledge", StatusCodes.Bad_SequenceNumberUnknown, diagnosticInfo, null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Acknowledged on Subscription " + this.getSubscriptionId().toString() + ": " + unsignedInteger);
            this.logger.debug("Available sequence numbers on Subscription " + this.getSubscriptionId().toString() + ": " + Arrays.toString(this.ce.keySet().toArray()));
        }
    }

    protected void addToPublishQueue(long l2, boolean bl) {
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addToPublishQueue: subscriptionId=" + this.getSubscriptionId().getValue() + " queue=" + blockingQueue);
        }
        if (blockingQueue != null) {
            this.bS.set(false);
            this.bT.set(false);
            if (bl) {
                blockingQueue.remove(this);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Needs keepalive = true");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Needs keepalive = false");
            }
            if (!blockingQueue.contains(this)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("addToPublishQueue: q.offer()");
                }
                blockingQueue.offer(this);
            }
            if (l2 > 0L) {
                this.bY.set(l2);
            }
            this.resetKeepAliveCounter();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("addToPublishQueue done. queue=" + blockingQueue);
                return;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("addToPublishQueue: queue=null");
        }
    }

    @Override
    protected void enabledChanged() throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("enabledChanged:" + Boolean.toString(this.isPublishingEnabled()));
        }
        if (this.isPublishingEnabled() && this.cf != null) {
            this.Y();
            this.X();
            this.Q();
            this.startPublishing();
        }
    }

    protected NotificationMessage getNextNotificationMessage(Session session) {
        StatusChangeNotification statusChangeNotification;
        Session session2 = this.getSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getNextNotificationMessage: session=" + session);
            this.logger.debug("getNextNotificationMessage: getSession()=" + session2);
        }
        boolean bl = true;
        List<ExtensionObject> list = null;
        if (session2 != null && !session2.equals(session)) {
            statusChangeNotification = new StatusChangeNotification();
            statusChangeNotification.setStatus(new StatusCode(StatusCodes.Good_SubscriptionTransferred));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getNextNotificationMessage: transferNotification=" + statusChangeNotification);
            }
            list = this.a(null, (NotificationData)statusChangeNotification, session2);
        } else {
            if (this.hasExpired()) {
                statusChangeNotification = new StatusChangeNotification();
                statusChangeNotification.setStatus(new StatusCode(StatusCodes.Bad_Timeout));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getNextNotificationMessage: timeoutNotification=" + statusChangeNotification);
                }
                list = this.a(null, (NotificationData)statusChangeNotification, session);
                try {
                    this.close();
                }
                catch (ServiceException serviceException) {
                    this.logger.error("ServiceException: ", (Throwable)serviceException);
                }
            }
            if (this.isPublishingEnabled()) {
                statusChangeNotification = this.R();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DataChangeNotification: ", (Object)statusChangeNotification);
                }
                session2 = this.S();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getNextNotificationMessage: dataChangeNotification.getMonitoredItems().length=" + statusChangeNotification.getMonitoredItems().length + " " + (this.bZ == null ? "null" : this.bZ.getMonitoredItemId().toString()));
                }
                if (statusChangeNotification.getMonitoredItems().length > 0) {
                    list = this.a(list, (NotificationData)statusChangeNotification, session);
                    bl = false;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getNextNotificationMessage: eventNotification.getEvents().length=" + session2.getEvents().length);
                }
                if (session2.getEvents().length > 0) {
                    list = this.a(list, (NotificationData)session2, session);
                    bl = false;
                }
            }
        }
        statusChangeNotification = DateTime.currentTime();
        session2 = new NotificationMessage(this.getNextSequenceNumber(bl), (DateTime)statusChangeNotification, list == null ? null : list.toArray(new ExtensionObject[list.size()]));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getNextNotificationMessage: isKeepaliveMessage=" + bl);
        }
        if (!bl) {
            this.b((NotificationMessage)session2);
        }
        this.bX.set((DateTime)statusChangeNotification);
        this.bV.set((DateTime)statusChangeNotification);
        if (this.hasMoreNotifications().booleanValue()) {
            this.addToPublishQueue(0L, false);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getNextNotificationMessage: notificationMessage=" + session2);
        }
        return session2;
    }

    protected UnsignedInteger getNextSequenceNumber(boolean bl) {
        long l2 = bl ? this.ca.get() : this.ca.getAndIncrement();
        try {
            return UnsignedInteger.valueOf((long)l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ca.set(bl ? 1L : 2L);
            return UnsignedInteger.valueOf((long)1L);
        }
    }

    protected NotificationMessage getNotificationMessage(UnsignedInteger unsignedInteger) throws ServiceException {
        if ((unsignedInteger = this.ce.get(unsignedInteger)) == null) {
            throw new ServiceException(StatusCodes.Bad_MessageNotAvailable);
        }
        return unsignedInteger;
    }

    protected BlockingQueue<SubscriptionBase> getPublishQueue() {
        if (this.cf != null && this.cf.isActive()) {
            return this.cc.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose(boolean bl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: SubscriptionId=" + this.getSubscriptionId() + " removeFromQueue=" + bl);
        }
        this.publishingEnabled = false;
        BlockingQueue<SubscriptionBase> blockingQueue = this.cc.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: PublishQueue: " + blockingQueue);
        }
        if (blockingQueue != null) {
            if (bl) {
                blockingQueue.remove(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PublishQueue after remove: " + blockingQueue);
            }
            this.setPublishQueue(null);
        }
        this.stopPublishing();
        this.removeAllItems();
        if (this.cf != null) {
            this.cf.removeSubscription(this);
        }
        if (this.subscriptionManager != null) {
            this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
        }
        Subscription subscription = this;
        synchronized (subscription) {
            this.ce.clear();
            this.subscriptionManager = null;
            this.cf = null;
            this.closed = true;
            return;
        }
    }

    protected void internalRemoveItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        super.removeItem(monitoredItem.getMonitoredItemId());
        monitoredItem.close();
    }

    protected boolean isTimeToPublish(long l2) {
        long l3 = l2 - this.bY.get();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isTimeToPublish: now-lastPublishCheckTime=" + l3 + " publishingInterval=" + this.publishingInterval);
        }
        return (double)l3 >= this.publishingInterval - 10.0;
    }

    protected void needTrigger(MonitoredItem object, boolean bl, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("needTrigger: triggering item monitoredItemId=" + ((MonitoredItemBase)object).getMonitoredItemId() + " needDataChange=" + bl + " needEventChange=" + bl2);
        }
        for (MonitoredItem monitoredItem : ((MonitoredItem)object).links) {
            this.cg.put(monitoredItem.getMonitoredItemId(), monitoredItem);
        }
        if (bl) {
            this.bS.set(true);
        }
        if (bl2) {
            this.bT.set(true);
        }
        this.Q();
    }

    protected void newEventAvailable(MonitoredEventItem monitoredEventItem) {
        this.logger.debug("newEventAvailable");
        this.bT.set(true);
        this.Q();
    }

    protected void newSampleAvailable(MonitoredItem monitoredItem, DataValue dataValue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("newSampleAvailable: monitoredItemId=" + monitoredItem.getMonitoredItemId());
        }
        this.bS.set(true);
        this.Q();
    }

    @Override
    protected void paramChanged() throws ServiceException {
        this.logger.debug("paramChanged");
        if (this.isPublishingEnabled() && this.cf != null) {
            this.Q();
            this.startPublishing();
            BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue before=" + blockingQueue);
            }
            if (blockingQueue.contains(this)) {
                blockingQueue.remove(this);
                blockingQueue.offer(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue after=" + blockingQueue);
            }
        }
    }

    protected void resetKeepAliveCounter() {
        this.bU.set(0);
    }

    protected void resetLastAliveTime() {
        this.bV.set(DateTime.currentTime());
    }

    protected void setPublishQueue(BlockingQueue<SubscriptionBase> monitoredItemBaseArray) {
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        if (monitoredItemBaseArray != blockingQueue) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setPublishQueue: " + monitoredItemBaseArray);
            }
            if (monitoredItemBaseArray != null && blockingQueue != null) {
                blockingQueue.remove(this);
            }
            this.cc.set((BlockingQueue<SubscriptionBase>)monitoredItemBaseArray);
            if (monitoredItemBaseArray != null) {
                for (MonitoredItemBase monitoredItemBase : this.getItems()) {
                    if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                    ((MonitoredDataItem)monitoredItemBase).startSampling();
                }
            }
        }
    }

    protected void setSession(Session session) {
        if (session != this.cf) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setSession: " + session);
            }
            if (this.cf != null) {
                this.cf.removeSubscription(this);
            }
            this.cf = session;
            if (session != null) {
                session.addSubscription(this);
            }
            this.start();
        }
    }

    protected synchronized void startPublishing() {
        long l2;
        if (this.cb == null) {
            this.cb = Executors.newScheduledThreadPool(1, StackUtils.newNamedThreadFactory((String)("PublishExecutor-" + this.getSession().getSessionName() + "-Subscription" + this.getSubscriptionId())));
        }
        if (this.cd != null) {
            this.cd.cancel(false);
            this.logger.debug("startPublishing: canceled existing scheduled publish task");
        }
        if ((l2 = (long)this.getPublishingInterval()) <= 0L) {
            l2 = 10L;
        }
        this.cd = this.cb.scheduleAtFixedRate(new PublishTask(this), l2, l2, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("startPublishing: publishExecutor scheduled, interval=" + this.getPublishingInterval());
        }
    }

    protected synchronized void stopPublishing() {
        if (this.cb != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("stopPublishing: publishExecutor.shutdown()");
            }
            this.cb.shutdown();
            this.cb = null;
        }
    }

    static /* synthetic */ Session h(Subscription subscription) {
        return subscription.cf;
    }

    public class PublishTask
    implements Runnable {
        private /* synthetic */ Subscription gk;

        public PublishTask(Subscription subscription) {
            this.gk = subscription;
        }

        @Override
        public void run() {
            PublishTask publishTask = this;
            if (publishTask.gk.logger.isDebugEnabled()) {
                publishTask.gk.logger.debug("publishCheck: SubscriptionID=" + publishTask.gk.getSubscriptionId());
            }
            long l2 = Subscription.T();
            if (publishTask.gk.logger.isDebugEnabled()) {
                publishTask.gk.logger.debug("now=" + l2);
            }
            if (publishTask.gk.isTimeToPublish(l2)) {
                if (publishTask.gk.logger.isDebugEnabled()) {
                    publishTask.gk.logger.debug("lastPublishCheckTime(was)=" + publishTask.gk.bY);
                }
                if (publishTask.gk.hasMoreNotifications().booleanValue()) {
                    publishTask.gk.addToPublishQueue(l2, false);
                } else {
                    publishTask.incKeepAliveCounter(l2);
                }
                if (publishTask.gk.hasExpired()) {
                    try {
                        publishTask.gk.logger.info("Subscription timeout: SubscriptionId=" + publishTask.gk.getSubscriptionId() + " Session=" + publishTask.gk.getSession());
                        publishTask.gk.addToPublishQueue(l2, true);
                        publishTask.gk.close();
                        return;
                    }
                    catch (ServiceException serviceException) {
                        publishTask.gk.logger.warn("While removing expired subscription " + publishTask.gk.getSubscriptionId() + " of session " + publishTask.gk.getSession(), (Throwable)serviceException);
                    }
                }
            }
        }

        protected void incKeepAliveCounter(long l2) {
            if (this.gk.logger.isDebugEnabled()) {
                this.gk.logger.debug("incKeepAliveCounter: SubscriptionId=" + this.gk.getSubscriptionId() + " Count=" + this.gk.bU.get() + " Max=" + this.gk.getMaxKeepAliveCount());
            }
            if ((long)this.gk.bU.incrementAndGet() >= this.gk.getMaxKeepAliveCount()) {
                this.gk.bU.set(0);
                this.gk.addToPublishQueue(l2, true);
            }
        }
    }
}

