/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureInfo {
    private static final Logger logger = LoggerFactory.getLogger(StructureInfo.class);
    private final Map<String, Method> cq = new HashMap<String, Method>();
    private final Map<String, Method> cr = new HashMap<String, Method>();

    StructureInfo(Class<? extends Structure> clazz) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz, Object.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray.getPropertyDescriptors()) {
                Method method = propertyDescriptor.getReadMethod();
                Method object = propertyDescriptor.getWriteMethod();
                if (method == null || object == null) continue;
                String string = object.getName().substring(3);
                this.cq.put(string, method);
                this.cr.put(string, object);
            }
            return;
        }
        catch (Exception exception) {
            logger.error("Could not figure out the fields of the Structure {}", clazz, (Object)exception);
            return;
        }
    }

    public Class<?> getFieldJavaClass(String string) {
        try {
            return this.cq.get(string).getReturnType();
        }
        catch (Exception exception) {
            logger.error("Trying to get Java Class of unknown field:{}", (Object)string, (Object)exception);
            return null;
        }
    }

    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.cq.keySet());
    }

    public Object getFieldValue(Structure structure, String object) {
        if ((object = this.cq.get(object)) == null) {
            return null;
        }
        try {
            return ((Method)object).invoke((Object)structure, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<String, Object> getSubComponents(Structure structure) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.cq.keySet()) {
            try {
                hashMap.put(string, this.cq.get(string).invoke((Object)structure, new Object[0]));
            }
            catch (Exception exception) {
                logger.error("Error in reading value for property {} in Structure {}", new Object[]{string, structure, exception});
            }
        }
        return hashMap;
    }

    public boolean setFieldValue(Structure structure, String string, Object object) {
        logger.trace("SetFieldValue value={}, fieldName={}, Structure={}", new Object[]{object, string, structure});
        Method method = this.cr.get(string);
        if (method == null) {
            return false;
        }
        try {
            Object object2 = method.getParameterTypes();
            if (((Class<?>[])object2).length != 1) {
                logger.error("Error, a set method has more than one parameter");
            }
            if (object2[0].isEnum() && object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (n2 < 0 || n2 >= object2[0].getEnumConstants().length) {
                    logger.error("Trying to set enum with integer, and the interger value is out of bounds of the enum.values");
                    return false;
                }
                object2 = object2[0].getEnumConstants()[n2];
                method.invoke((Object)structure, object2);
            } else {
                method.invoke((Object)structure, object);
            }
        }
        catch (Exception exception) {
            logger.error("Could not set the field {} for Structure {}, newValue={}", new Object[]{string, structure, object, exception});
            return false;
        }
        return true;
    }

    public void setSubComponents(Structure structure, Map<String, Object> object) {
        for (Map.Entry entry : object.entrySet()) {
            Method method = this.cr.get(entry.getKey());
            if (method == null) {
                logger.error("Error, this StructureInfo does not support writing property {} for Structure {}", entry.getKey(), (Object)structure);
                continue;
            }
            try {
                method.invoke((Object)structure, entry.getValue());
            }
            catch (Exception exception) {
                logger.error("Error in writing value for property {} in Structure {}", new Object[]{entry.getValue(), structure, entry});
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StructureInfo [readMap=").append(this.cq).append(", writeMap=").append(this.cr).append("]");
        return stringBuilder.toString();
    }
}

