/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ActivateSessionRequest;
import org.opcfoundation.ua.core.ActivateSessionResponse;
import org.opcfoundation.ua.core.CancelRequest;
import org.opcfoundation.ua.core.CancelResponse;
import org.opcfoundation.ua.core.CloseSessionRequest;
import org.opcfoundation.ua.core.CloseSessionResponse;
import org.opcfoundation.ua.core.CreateSessionRequest;
import org.opcfoundation.ua.core.CreateSessionResponse;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.SessionServiceSetHandler;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionServiceHandler
extends ServiceHandler
implements SessionServiceSetHandler {
    private static Logger logger = LoggerFactory.getLogger(SessionServiceHandler.class);
    private int dj = 32;

    public SessionServiceHandler(SessionManager sessionManager) {
        super(sessionManager);
    }

    public int getMinServerNonceLength() {
        return this.dj;
    }

    public final void onActivateSession(EndpointServiceRequest<ActivateSessionRequest, ActivateSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        ActivateSessionRequest activateSessionRequest = (ActivateSessionRequest)endpointServiceRequest.getRequest();
        ActivateSessionResponse activateSessionResponse = new ActivateSessionResponse();
        try {
            this.validateRequest((ServiceRequest)activateSessionRequest, endpointServiceRequest.getChannel());
            Object object = activateSessionRequest.getUserIdentityToken();
            UserIdentityToken userIdentityToken = null;
            if (object != null) {
                try {
                    userIdentityToken = (UserIdentityToken)object.decode(this.getEncoderContext());
                }
                catch (DecodingException decodingException) {
                    throw new ServiceException(StatusCodes.Bad_IdentityTokenInvalid);
                }
            }
            object = this.getSessionManager().activateSession(endpointServiceRequest.getChannel(), activateSessionRequest.getRequestHeader().getAuthenticationToken(), userIdentityToken, activateSessionRequest.getClientSignature(), activateSessionRequest.getClientSoftwareCertificates(), activateSessionRequest.getUserTokenSignature(), activateSessionRequest.getLocaleIds());
            activateSessionResponse.setServerNonce(((Session)object).getNewServerNonce(this.dj));
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)activateSessionResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)activateSessionRequest, (ServiceResponse)activateSessionResponse, null);
        endpointServiceRequest.sendResponse((ServiceResponse)activateSessionResponse);
    }

    public final void onCancel(EndpointServiceRequest<CancelRequest, CancelResponse> endpointServiceRequest) throws ServiceFaultException {
        CancelRequest cancelRequest = (CancelRequest)endpointServiceRequest.getRequest();
        CancelResponse cancelResponse = new CancelResponse();
        try {
            this.validateRequest((ServiceRequest)cancelRequest, endpointServiceRequest.getChannel());
            this.getSessionManager().cancelSession(cancelRequest.getRequestHeader().getAuthenticationToken());
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)cancelResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)cancelRequest, (ServiceResponse)cancelResponse, null);
        endpointServiceRequest.sendResponse((ServiceResponse)cancelResponse);
    }

    public final void onCloseSession(EndpointServiceRequest<CloseSessionRequest, CloseSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        CloseSessionRequest closeSessionRequest = (CloseSessionRequest)endpointServiceRequest.getRequest();
        CloseSessionResponse closeSessionResponse = new CloseSessionResponse();
        try {
            this.validateRequest((ServiceRequest)closeSessionRequest, endpointServiceRequest.getChannel());
            this.getSessionManager().closeSession(closeSessionRequest.getRequestHeader().getAuthenticationToken(), closeSessionRequest.getDeleteSubscriptions());
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)closeSessionResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)closeSessionRequest, (ServiceResponse)closeSessionResponse, null);
        endpointServiceRequest.sendResponse((ServiceResponse)closeSessionResponse);
    }

    public final void onCreateSession(EndpointServiceRequest<CreateSessionRequest, CreateSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateSessionRequest createSessionRequest = (CreateSessionRequest)endpointServiceRequest.getRequest();
        CreateSessionResponse createSessionResponse = new CreateSessionResponse();
        try {
            this.validateRequest((ServiceRequest)createSessionRequest, endpointServiceRequest.getChannel());
            Object object = this.getSessionManager().createSession(endpointServiceRequest.getChannel(), createSessionRequest.getClientCertificate(), createSessionRequest.getClientDescription(), createSessionRequest.getMaxResponseMessageSize(), createSessionRequest.getRequestedSessionTimeout(), createSessionRequest.getSessionName());
            createSessionResponse.setServerNonce(((Session)object).getNewServerNonce(this.dj));
            createSessionResponse.setRevisedSessionTimeout(Double.valueOf(((Session)object).getSessionTimeout()));
            createSessionResponse.setSessionId(((Session)object).getSessionId());
            createSessionResponse.setAuthenticationToken(((Session)object).getAuthenticationToken());
            createSessionResponse.setMaxRequestMessageSize(this.getSessionManager().getMaxRequestMessageSize());
            object = this.getSessionManager().getServerIdentity();
            createSessionResponse.setServerCertificate(((SecureIdentity)object).getCertificate().getEncoded());
            if (logger.isDebugEnabled()) {
                logger.debug("getEndpoints(): " + this.getSessionManager().getEndpoints());
            }
            createSessionResponse.setServerEndpoints(this.getSessionManager().getEndpoints());
            createSessionResponse.setServerSoftwareCertificates(((ApplicationIdentity)object).getSoftwareCertificates());
            createSessionResponse.setServerSignature(SessionServiceHandler.a(createSessionRequest.getClientCertificate(), createSessionRequest.getClientNonce(), endpointServiceRequest.getChannel().getSecurityPolicy(), (ApplicationIdentity)object));
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)createSessionResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)createSessionRequest, (ServiceResponse)createSessionResponse, null);
        endpointServiceRequest.sendResponse((ServiceResponse)createSessionResponse);
    }

    public void setMinServerNonceLength(int n2) {
        this.dj = n2;
    }

    private static SignatureData a(byte[] byArray, byte[] byArray2, SecurityPolicy securityPolicy, ApplicationIdentity applicationIdentity) throws ServiceException {
        if (byArray2 == null || byArray2.length == 0 ? securityPolicy != SecurityPolicy.NONE : byArray2.length < 32) {
            throw new ServiceException(StatusCodes.Bad_NonceInvalid);
        }
        if (byArray != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new ServiceException(StatusCodes.Bad_SecurityChecksFailed);
            }
            catch (Exception exception) {
                throw new ServiceException(StatusCodes.Bad_NonceInvalid);
            }
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                throw new ServiceException(StatusCodes.Bad_NonceInvalid);
            }
            catch (Exception exception) {
                throw new ServiceException(StatusCodes.Bad_NonceInvalid);
            }
            try {
                return CryptoUtil.signAsymm((PrivateKey)applicationIdentity.getPrivateKey().getPrivateKey(), (SecurityAlgorithm)securityPolicy.getAsymmetricSignatureAlgorithm(), (byte[])byteArrayOutputStream.toByteArray());
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException.getStatusCode());
            }
        }
        return null;
    }

    @Override
    protected ServiceContext createServiceContext(RequestHeader requestHeader) throws ServiceException {
        return new ServiceContext(null, requestHeader);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

