/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsObjectType;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private UnsignedInteger maxRequestMessageSize;
    private int kd = 100;
    private double ke = 3600000.0;
    private double kf = 100.0;
    private volatile boolean running;
    private final UaServer cp;
    private ServerDiagnosticsTypeNode bM;
    private final List<SessionDiagnosticsObjectType> kg = new CopyOnWriteArrayList<SessionDiagnosticsObjectType>();
    private ScheduledExecutorService kh;
    private final Map<NodeId, Session> ki = new ConcurrentHashMap<NodeId, Session>();
    private SessionsDiagnosticsSummaryTypeNode kj;
    protected List<SessionManagerListener> listeners = new CopyOnWriteArrayList<SessionManagerListener>();
    protected final Map<NodeId, Session> newSessions = new ConcurrentHashMap<NodeId, Session>();

    public SessionManager(UaServer uaServer) {
        this.cp = uaServer;
    }

    public void addListener(SessionManagerListener sessionManagerListener) {
        if (!this.hasListener(sessionManagerListener)) {
            this.listeners.add(sessionManagerListener);
        }
    }

    public EndpointDescription[] getEndpoints() {
        return this.cp.getEndpoints();
    }

    public int getMaxBrowseContinuationPoints() {
        return this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxBrowseContinuationPoints().intValue();
    }

    public int getMaxHistoryContinuationPoints() {
        return this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxHistoryContinuationPoints().intValue();
    }

    public int getMaxQueryContinuationPoints() {
        return this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxQueryContinuationPoints().intValue();
    }

    public UnsignedInteger getMaxRequestMessageSize() {
        return this.maxRequestMessageSize;
    }

    public int getMaxSessionCount() {
        return this.kd;
    }

    public double getMaxSessionTimeout() {
        return this.ke;
    }

    public double getMinSessionTimeout() {
        return this.kf;
    }

    public UaServer getServer() {
        return this.cp;
    }

    public ServerDiagnosticsTypeNode getServerDiagnostics() {
        return this.bM;
    }

    public Session getSession(NodeId nodeId) throws ServiceException {
        if (!this.isRunning()) {
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        Session session = this.ki.get(nodeId);
        if (session == null) {
            if (this.newSessions.containsKey(nodeId)) {
                this.newSessions.remove(nodeId);
                throw new ServiceException(StatusCodes.Bad_SessionNotActivated);
            }
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        return session;
    }

    public int getSessionCount() {
        return this.ki.size() + this.newSessions.size();
    }

    public SessionDiagnosticsObjectType[] getSessionDiagnostics() {
        return this.kg.toArray(new SessionDiagnosticsObjectType[0]);
    }

    public Collection<Session> getSessions() {
        return this.ki.values();
    }

    public boolean hasListener(SessionManagerListener sessionManagerListener) {
        if (sessionManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(sessionManagerListener);
    }

    public boolean isRunning() {
        boolean bl = this.running && this.cp.isRunning();
        if (!bl) {
            logger.debug("isRunning: running=" + this.running + " server.isRunning()=" + this.cp.isRunning());
        }
        return bl;
    }

    public void removeListener(SessionManagerListener sessionManagerListener) {
        this.listeners.remove(sessionManagerListener);
    }

    public void setMaxBrowseContinuationPoints(int n2) {
        this.setMaxBrowseContinuationPoints(UnsignedShort.valueOf((int)n2));
    }

    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) {
        this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxBrowseContinuationPoints(unsignedShort);
    }

    public void setMaxHistoryContinuationPoints(int n2) {
        this.setMaxHistoryContinuationPoints(UnsignedShort.valueOf((int)n2));
    }

    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) {
        this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxHistoryContinuationPoints(unsignedShort);
    }

    public void setMaxQueryContinuationPoints(int n2) {
        this.setMaxQueryContinuationPoints(UnsignedShort.valueOf((int)n2));
    }

    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) {
        this.cp.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxQueryContinuationPoints(unsignedShort);
    }

    public void setMaxRequestMessageSize(int n2) {
        this.setMaxRequestMessageSize(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxRequestMessageSize(UnsignedInteger unsignedInteger) {
        this.maxRequestMessageSize = unsignedInteger;
    }

    public void setMaxSessionCount(int n2) {
        this.kd = n2;
    }

    public void setMaxSessionTimeout(double d2) {
        this.ke = d2;
    }

    public void setMinSessionTimeout(double d2) {
        this.kf = d2;
    }

    private void a(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                if (sessionManagerListener.onActivateSession(session, serverUserIdentity)) continue;
                throw new StatusException("User identity rejected", StatusCodes.Bad_UserAccessDenied);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onActivateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void b(Session session) {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onAfterActivateSession(session);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onAfterActivateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void c(Session session) throws StatusException {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onCreateSession(session);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onCreateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private static void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session activateSession(ServerSecureChannel serverSecureChannel, NodeId object, UserIdentityToken userIdentityToken, SignatureData securityPolicy3, SignedSoftwareCertificate[] object2, SignatureData signatureData, String[] stringArray) throws ServiceException {
        SecurityPolicy securityPolicy2;
        logger.debug("activateSession: serverSecureChannel={}", (Object)serverSecureChannel);
        Object object32 = this;
        synchronized (object32) {
            object2 = this.newSessions.remove(object);
            if (object2 == null) {
                try {
                    object2 = this.getSession((NodeId)object);
                }
                catch (ServiceException serviceException) {
                    logger.info("Session NOT Activated: Unknown Token={}", object);
                    throw new ServiceException(StatusCodes.Bad_SessionIdInvalid);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("activateSession: session.getChannel()={}", (Object)((Session)object2).getChannel());
                }
                if (((Session)object2).getChannel().getSecureChannelId() != serverSecureChannel.getSecureChannelId()) {
                    ((Session)object2).setChannel(serverSecureChannel);
                }
            } else {
                if (((Session)object2).getChannel().getSecureChannelId() != serverSecureChannel.getSecureChannelId() && !((Session)object2).isActive()) {
                    throw new ServiceException(StatusCodes.Bad_SecureChannelIdInvalid);
                }
                securityPolicy2 = serverSecureChannel.getRemoteCertificate();
                Cert cert = ((Session)object2).getChannel().getRemoteCertificate();
                if (cert != null && !cert.equals((Object)securityPolicy2)) {
                    logger.info("activateSession: Client certificate changed from the original. Cannot activate.");
                    throw new ServiceException(StatusCodes.Bad_SecurityChecksFailed);
                }
                ((Session)object2).setChannel(serverSecureChannel);
                this.ki.put((NodeId)object, (Session)object2);
            }
        }
        try {
            object32 = ((Session)object2).getClientIdentity().getCertificate();
            securityPolicy2 = (SecurityPolicy)(object32 == null ? null : object32.getEncoded());
            object = this;
            SessionManager.a((SignatureData)securityPolicy3, object.cp.getApplicationIdentity(), ((Session)object2).getServerNonce(), serverSecureChannel.getSecurityPolicy(), (byte[])securityPolicy2);
        }
        catch (SecureIdentityException secureIdentityException) {
            ((Session)object2).deactivate();
            logger.info("Session NOT activated: {} - {}", (Object)((Session)object2).getSessionName(), (Object)secureIdentityException);
            logger.debug("SecureIdentityException: {}", (Throwable)secureIdentityException);
            throw new ServiceException(StatusCodes.Bad_ApplicationSignatureInvalid);
        }
        try {
            object32 = null;
            if (userIdentityToken != null) {
                for (SecurityPolicy securityPolicy3 : this.cp.getUserTokenPolicies()) {
                    if (!securityPolicy3.getPolicyId().equals(userIdentityToken.getPolicyId())) continue;
                    object32 = securityPolicy3.getSecurityPolicyUri();
                }
            }
            try {
                securityPolicy2 = object32 == null ? serverSecureChannel.getSecurityPolicy() : SecurityPolicy.getSecurityPolicy((String)object32);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException("UserTokenPolicy unknown: " + (userIdentityToken == null ? "userToken is null" : userIdentityToken.getPolicyId()), StatusCodes.Bad_IdentityTokenInvalid);
            }
            SessionManager sessionManager = this;
            ServerUserIdentity serverUserIdentity = new ServerUserIdentity(this, userIdentityToken, signatureData, sessionManager.cp.getApplicationIdentity(), ((Session)object2).getServerNonce(), securityPolicy2);
            logger.debug("userIdentity: {}", (Object)serverUserIdentity);
            boolean bl = false;
            for (Object object32 : this.cp.getUserTokenPolicies()) {
                if (!object32.getTokenType().equals((Object)serverUserIdentity.getType())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new ServiceException(StatusCodes.Bad_IdentityTokenRejected);
            }
            this.a((Session)object2, serverUserIdentity);
            ((Session)object2).activate(serverUserIdentity);
            this.b((Session)object2);
            logger.info("Session activated: {}", object2);
        }
        catch (SecureIdentityException secureIdentityException) {
            this.activateSessionError((Session)object2, userIdentityToken, secureIdentityException);
            securityPolicy2 = secureIdentityException.getStatusCode();
            if (securityPolicy2 == null) {
                securityPolicy2 = StatusCodes.Bad_IdentityTokenInvalid;
            }
            throw new ServiceException((UnsignedInteger)securityPolicy2);
        }
        catch (StatusException statusException) {
            this.activateSessionError((Session)object2, userIdentityToken, statusException);
            throw new ServiceException(statusException.getStatusCode(), statusException.getDiagnosticInfo());
        }
        ((Session)object2).setLocaleIds(stringArray);
        return object2;
    }

    protected void activateSessionError(Session session, UserIdentityToken object, Exception exception) {
        Exception exception2 = exception;
        UserIdentityToken userIdentityToken = object;
        Session session2 = session;
        object = this;
        for (SessionManagerListener sessionManagerListener : ((SessionManager)object).listeners) {
            try {
                sessionManagerListener.onActivateSessionError(session2, userIdentityToken, exception2);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onActivateSessionError", sessionManagerListener, runtimeException);
            }
        }
        session.deactivate();
        logger.info("Session NOT activated: {} - {}", (Object)session.getSessionName(), (Object)exception);
        logger.debug("SessionManager.activateSessionError()", (Throwable)exception);
    }

    protected void cancelSession(NodeId object) throws ServiceException {
        Object object2 = object = this.getSession((NodeId)object);
        SessionManager sessionManager = this;
        for (SessionManagerListener sessionManagerListener : sessionManager.listeners) {
            try {
                sessionManagerListener.onCancelSession((Session)object2);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onCancelSession", sessionManagerListener, runtimeException);
            }
        }
        ((Session)object).cancel();
    }

    protected void close() {
        logger.debug("close");
        if (this.bM != null) {
            this.bM.setEnabled(false);
        }
        for (NodeId nodeId : this.ki.keySet()) {
            try {
                this.closeSession(nodeId, true);
            }
            catch (ServiceException serviceException) {
                logger.debug("While closing session " + nodeId + ": ", (Throwable)serviceException);
            }
        }
        if (this.kh != null) {
            this.kh.shutdownNow();
        }
        this.bM = null;
        this.kh = null;
        this.running = false;
    }

    protected void closeSession(NodeId object, boolean bl) throws ServiceException {
        logger.debug("closeSession: Token={}", object);
        Session session = this.ki.remove(object);
        if (session == null && (session = this.newSessions.remove(object)) == null) {
            throw new ServiceException(StatusCodes.Bad_SessionIdInvalid);
        }
        boolean bl2 = bl;
        Session session2 = session;
        object = this;
        for (SessionManagerListener sessionManagerListener : ((SessionManager)object).listeners) {
            try {
                sessionManagerListener.onCloseSession(session2, bl2);
            }
            catch (RuntimeException runtimeException) {
                SessionManager.listenerError("onCloseSession", sessionManagerListener, runtimeException);
            }
        }
        logger.info("Session closed: {}", (Object)session);
        session2 = session;
        object = this;
        if (((SessionManager)object).bM.isEnabled()) {
            ((SessionManager)object).kj.removeSession(session2);
            ((SessionManager)object).bM.getServerDiagnosticsSummaryNode().setCurrentSessionCount(((SessionManager)object).getSessionCount());
        }
        session.close(bl);
    }

    protected synchronized Session createSession(ServerSecureChannel serverSecureChannel, byte[] object, ApplicationDescription object2, UnsignedInteger object3, Double d2, String string) throws ServiceException {
        double d3;
        if (logger.isDebugEnabled()) {
            logger.debug("createSession: serverSecureChannel={} clientDescription={} clientCertificate={}", new Object[]{serverSecureChannel, object2, Arrays.toString((byte[])object)});
            logger.debug("createSession: sessionCount={} maxSessionCount={}", (Object)this.getSessionCount(), (Object)this.getMaxSessionCount());
        }
        SecurityMode securityMode = new SecurityMode(serverSecureChannel.getSecurityPolicy(), serverSecureChannel.getMessageSecurityMode());
        if (!serverSecureChannel.getEndpoint().supportsSecurityMode(securityMode)) {
            logger.info("The requested SecurityMode(" + securityMode + ") is not supported by the endpoint. Client=" + object2.getApplicationUri());
            throw new ServiceException(StatusCodes.Bad_SecurityModeRejected);
        }
        if (this.getSessionCount() >= this.getMaxSessionCount()) {
            logger.info("createSession: MaxSessionCount exceeded, rejecting connection from " + object2.getApplicationUri() + " maxSessionCount=" + this.getMaxSessionCount());
            throw new ServiceException(StatusCodes.Bad_TooManySessions);
        }
        try {
            Cert cert = object == null ? null : new Cert((byte[])object);
            if (cert != null && !serverSecureChannel.needsCertificate()) {
                logger.info("Client sent a certificate, although SecurityPolicy NONE is used");
            }
            ApplicationIdentity applicationIdentity = new ApplicationIdentity(cert, null);
            applicationIdentity.setApplicationDescription((ApplicationDescription)object2);
            object = this.provideSession(string, applicationIdentity);
        }
        catch (ServiceResultException serviceResultException) {
            logger.error(serviceResultException.getMessage());
            throw new ServiceException(StatusCodes.Bad_CertificateInvalid);
        }
        ((Session)object).setMaxResponseMessageSize((UnsignedInteger)object3);
        object3 = d2;
        object2 = this;
        double d4 = object3 == null || (Double)object3 < ((SessionManager)object2).getMinSessionTimeout() ? ((SessionManager)object2).getMinSessionTimeout() : (d3 = (Double)object3 > ((SessionManager)object2).getMaxSessionTimeout() ? ((SessionManager)object2).getMaxSessionTimeout() : ((Double)object3).doubleValue());
        if (logger.isTraceEnabled()) {
            logger.trace("createSession: requestedSessionTimeout=" + d2 + " revisedSessionTimeout=" + d3);
        }
        ((Session)object).setSessionTimeout(d3);
        ((Session)object).setChannel(serverSecureChannel);
        try {
            this.c((Session)object);
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getStatusCode(), statusException.getDiagnosticInfo());
        }
        this.newSessions.put(((Session)object).getAuthenticationToken(), (Session)object);
        object3 = object;
        object2 = this;
        if (((SessionManager)object2).bM.isEnabled()) {
            ((SessionManager)object2).kj.addSession((Session)object3);
            ((SessionManager)object2).bM.getServerDiagnosticsSummaryNode().incCumulatedSessionCount();
            ((SessionManager)object2).bM.getServerDiagnosticsSummaryNode().incCurrentSessionCount();
        }
        logger.info("Session created: " + object);
        return object;
    }

    protected Session provideSession(String string, ApplicationIdentity applicationIdentity) {
        return new Session(this, applicationIdentity, string);
    }

    protected void resetDiagnostics() {
        this.kj.clear();
        for (Session object : this.getSessions()) {
            this.kj.addSession(object);
            object.resetDiagnostics();
        }
        ServerDiagnosticsSummaryTypeNode serverDiagnosticsSummaryTypeNode = this.bM.getServerDiagnosticsSummaryNode();
        try {
            UaNode statusException = this.cp.getNodeManagerRoot().getNode(Identifiers.ViewsFolder);
            serverDiagnosticsSummaryTypeNode.setServerViewCount(statusException.getComponents().length);
        }
        catch (StatusException statusException) {
            logger.warn("ViewsFolder not available", (Throwable)statusException);
        }
        serverDiagnosticsSummaryTypeNode.setCurrentSessionCount(this.getSessionCount());
        serverDiagnosticsSummaryTypeNode.setCumulatedSessionCount(this.getSessionCount());
    }

    protected void start() throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("start");
        }
        SessionManager sessionManager = this;
        this.bM = sessionManager.cp.getNodeManagerRoot().getServerData().getServerDiagnosticsNode();
        sessionManager.bM.addEnabledChangeListener(new DataChangeListener(sessionManager){
            private /* synthetic */ SessionManager gt;
            {
                this.gt = sessionManager;
            }

            @Override
            public final void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (!dataValue2.isNull() && dataValue2.getValue().booleanValue()) {
                    this.gt.resetDiagnostics();
                }
            }
        });
        sessionManager.bM.addEnabledChangeListener(new DataChangeListener(sessionManager){
            private /* synthetic */ SessionManager gt;
            {
                this.gt = sessionManager;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onDataChange(UaNode object, DataValue object22, DataValue dataValue) {
                void var3_5;
                if (!var3_5.isNull() && !var3_5.getValue().booleanValue()) {
                    for (Session session : this.gt.getSessions()) {
                        this.gt.kj.removeSession(session);
                    }
                }
            }
        });
        sessionManager.kj = sessionManager.bM.getSessionsDiagnosticsSummaryNode();
        logger.debug("initDiagnostics: diagnostics={}", sessionManager.kg);
        this.running = true;
        sessionManager = this;
        if (sessionManager.kh == null) {
            sessionManager.kh = Executors.newScheduledThreadPool(1, StackUtils.newNamedThreadFactory((String)"SessionMonitor"));
            sessionManager.kh.scheduleWithFixedDelay(new a(sessionManager), 1000L, 1000L, TimeUnit.MILLISECONDS);
            logger.debug("sessionMonitorExecutor scheduled");
        }
    }

    final ApplicationIdentity getServerIdentity() {
        return this.cp.getApplicationIdentity();
    }

    static void a(SignatureData signatureData, SecureIdentity object, byte[] object2, SecurityPolicy securityPolicy, byte[] byArray) throws SecureIdentityException {
        if (securityPolicy.equals((Object)SecurityPolicy.NONE)) {
            return;
        }
        object = ((SecureIdentity)object).getCertificate().getEncoded();
        if (object2 != null) {
            object = ByteBufferUtils.concatenate((byte[][])new byte[][]{(byte[])object, object2});
        }
        try {
            X509Certificate x509Certificate = CertificateUtils.decodeX509Certificate((byte[])byArray);
            object2 = x509Certificate;
            CryptoUtil.verifyAsymm((X509Certificate)x509Certificate, (SecurityAlgorithm)securityPolicy.getAsymmetricSignatureAlgorithm(), (byte[])object, (byte[])signatureData.getSignature());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SecureIdentityException("Signature invalid", illegalArgumentException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecureIdentityException("Signature invalid", generalSecurityException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SecureIdentityException("Signature invalid", serviceResultException);
        }
    }

    static /* synthetic */ void c(SessionManager sessionManager) {
        for (Session session : sessionManager.newSessions.values()) {
            if (!session.isTimeout()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("SessionMonitor: new session timeout {}", (Object)session.getSessionName());
            }
            sessionManager.newSessions.remove(session.getAuthenticationToken());
        }
    }

    private final class a
    implements Runnable {
        private /* synthetic */ SessionManager gt;

        private a(SessionManager sessionManager, byte by) {
            this.gt = sessionManager;
        }

        @Override
        public final void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("SessionMonitor.run: sessions=" + Arrays.toString(this.gt.ki.values().toArray()));
            }
            for (Session session : this.gt.ki.values()) {
                if (!session.isTimeout()) continue;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SessionMonitor: session timeout " + session.getSessionName());
                    }
                    this.gt.closeSession(session.getAuthenticationToken(), false);
                    this.gt.bM.getServerDiagnosticsSummaryNode().incSessionTimeoutCount();
                }
                catch (ServiceException serviceException) {
                    logger.warn("SessionMonitor: " + serviceException);
                }
            }
            SessionManager.c(this.gt);
        }

        /* synthetic */ a(SessionManager sessionManager) {
            this(sessionManager, 0);
        }
    }
}

