/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.AbstractContinuationPoint;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsTypeNodeBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.PublishRequest;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.ServiceCounterDataType;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    public static final Session INTERNAL_SESSION = new Session();
    private static long eU = 10000L;
    private static volatile int eV = (int)System.currentTimeMillis();
    private static Logger logger = LoggerFactory.getLogger(Session.class);
    private volatile boolean active = false;
    private final NodeId authenticationToken;
    private final Map<Long, BrowseContinuationPoint> eW = new ConcurrentSkipListMap<Long, BrowseContinuationPoint>();
    private volatile ServerSecureChannel eX;
    private final ApplicationIdentity eY;
    private final SessionDiagnosticsObjectTypeNode eZ;
    private final Map<Long, HistoryContinuationPoint> fa = new ConcurrentSkipListMap<Long, HistoryContinuationPoint>();
    private volatile long fb = 0L;
    private volatile long fc;
    private final List<Locale> locales = new CopyOnWriteArrayList<Locale>();
    private volatile byte[] serverNonce;
    private SessionManager sessionManager;
    private volatile double sessionTimeout;
    private final List<Subscription> bc = new CopyOnWriteArrayList<Subscription>();
    private final Queue<Subscription> fd = new ConcurrentLinkedQueue<Subscription>();
    private ServerUserIdentity fe = null;
    protected List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();

    public static long getActivationTimeout() {
        return eU;
    }

    public static void setActivationTimeout(long l2) {
        eU = l2;
    }

    private Session() {
        this.sessionManager = null;
        this.eZ = null;
        this.eY = null;
        this.authenticationToken = null;
    }

    protected Session(SessionManager object, ApplicationIdentity applicationIdentity, String string) {
        this.sessionManager = object;
        UaServer.NodeManagerUaServer nodeManagerUaServer = ((SessionManager)object).getServer().getNodeManagerUaServer();
        NodeId nodeId = NodeId.randomGUID((int)nodeManagerUaServer.getNamespaceIndex());
        if (string == null) {
            string = "ServerAssigned " + nodeId;
        }
        try {
            this.eZ = nodeManagerUaServer.createInstance(SessionDiagnosticsObjectTypeNode.class, string, nodeId);
        }
        catch (UaInstantiationException uaInstantiationException) {
            throw new RuntimeException(uaInstantiationException);
        }
        this.eZ.setsessionManager((SessionManager)object);
        object = this.eZ.getSessionDiagnosticsNode();
        ((SessionDiagnosticsVariableTypeNodeBase)object).setSessionId(nodeId);
        ((SessionDiagnosticsVariableTypeNodeBase)object).setClientConnectionTime(DateTime.currentTime());
        ((SessionDiagnosticsVariableTypeNodeBase)object).setClientDescription(applicationIdentity.getApplicationDescription());
        ((SessionDiagnosticsVariableTypeNodeBase)object).setSessionName(string);
        object = this.eZ.getSessionSecurityDiagnosticsNode();
        ((SessionSecurityDiagnosticsTypeNodeBase)object).setSessionId(this.getSessionId());
        string = applicationIdentity.getCertificate();
        ((SessionSecurityDiagnosticsTypeNodeBase)object).setClientCertificate(string != null ? string.getEncoded() : null);
        this.eY = applicationIdentity;
        this.authenticationToken = NodeId.get((IdType)IdType.Numeric, (int)0, (Object)UnsignedInteger.getFromBits((int)(++eV)));
        this.fc = System.currentTimeMillis();
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.listeners.contains(sessionListener)) {
            this.listeners.add(sessionListener);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Session)object;
        if (this.authenticationToken == null ? ((Session)object).authenticationToken != null : !this.authenticationToken.equals((Object)((Session)object).authenticationToken)) {
            return false;
        }
        return !(this.getSessionId() == null ? ((Session)object).getSessionId() != null : !this.getSessionId().equals((Object)((Session)object).getSessionId()));
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public ServerSecureChannel getChannel() {
        return this.eX;
    }

    public ApplicationIdentity getClientIdentity() {
        return this.eY;
    }

    public DateTime getClientLastContactTime() {
        return this.eZ.getSessionDiagnosticsNode().getClientLastContactTime();
    }

    public Locale getDefaultLocale() {
        if (this.locales == null || this.locales.isEmpty()) {
            return Locale.ENGLISH;
        }
        return this.locales.get(0);
    }

    public SessionDiagnosticsObjectTypeNode getDiagnostics() {
        return this.eZ;
    }

    public Locale[] getLocales() {
        return this.locales.toArray(new Locale[this.locales.size()]);
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.eZ.getSessionDiagnosticsNode().getMaxResponseMessageSize();
    }

    public NodeId getSessionId() {
        return this.eZ.getSessionDiagnosticsNode().getSessionId();
    }

    public String getSessionName() {
        return this.eZ.getSessionDiagnosticsNode().getSessionName();
    }

    public double getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getSubscriptionCount() {
        return this.bc.size();
    }

    public ServerUserIdentity getUserIdentity() {
        return this.fe;
    }

    public int hashCode() {
        int n2 = 31 + (this.authenticationToken == null ? 0 : this.authenticationToken.hashCode());
        n2 *= 31;
        if (this.eZ != null) {
            n2 += this.getSessionId().hashCode();
        }
        return n2;
    }

    public boolean hasLocale(Locale locale) {
        return this.locales.contains(locale);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.listeners.contains(sessionListener);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.fc;
        double d2 = this.isActive() ? this.sessionTimeout : (double)eU;
        logger.trace("isTimeout: timeout={} delay={}", (Object)d2, (Object)l2);
        return (double)l2 > d2;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    public String toString() {
        return String.format("%s (ID=%s Token=%s Channel=(%s))", this.getSessionName(), this.getSessionId(), this.getAuthenticationToken(), this.getChannel());
    }

    private static Long a(byte[] byArray) throws StatusException {
        if (byArray == null) {
            throw new StatusException("null", StatusCodes.Bad_ContinuationPointInvalid);
        }
        Object object = new ByteArrayInputStream(byArray);
        object = new DataInputStream((InputStream)object);
        try {
            object = ((DataInputStream)object).readLong();
        }
        catch (IOException iOException) {
            throw new StatusException("Too short array: " + Arrays.toString(byArray), StatusCodes.Bad_ContinuationPointInvalid);
        }
        return object;
    }

    private void ay() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionActivated(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionActivated:", (Throwable)exception);
            }
        }
    }

    private void az() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionChanged(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionChanged:", (Throwable)exception);
            }
        }
    }

    private AbstractContinuationPoint a(byte[] byArray, Map<Long, ? extends AbstractContinuationPoint> object) throws StatusException {
        Long l2 = Session.a(byArray);
        object = object.remove(l2);
        logger.debug("getContinuationPoint: i={} result={}", (Object)l2, object);
        if (object == null) {
            throw new StatusException("Not found: " + Arrays.toString(byArray), StatusCodes.Bad_ContinuationPointInvalid);
        }
        return object;
    }

    private UnsignedInteger a(String object, String string) {
        try {
            Object object2 = this.eZ.getSessionDiagnosticsNode().getClass().getMethod("get" + (String)object, new Class[0]);
            object2 = ((Method)object2).invoke((Object)this.eZ.getSessionDiagnosticsNode(), new Object[0]);
            if (object2 != null) {
                if (object2 instanceof ServiceCounterDataType) {
                    if (string.equals("TotalCount")) {
                        string = ((ServiceCounterDataType)object2).getTotalCount().inc();
                        ((ServiceCounterDataType)object2).setTotalCount((UnsignedInteger)string);
                        return string;
                    }
                    if (string.equals("ErrorCount")) {
                        string = ((ServiceCounterDataType)object2).getErrorCount().inc();
                        ((ServiceCounterDataType)object2).setErrorCount((UnsignedInteger)string);
                        return string;
                    }
                }
                if (object2 instanceof UnsignedInteger) {
                    string = (UnsignedInteger)object2;
                    string = string.add(1);
                    object = this.eZ.getSessionDiagnosticsNode().getClass().getMethod("set" + (String)object, UnsignedInteger.class);
                    ((Method)object).invoke((Object)this.eZ.getSessionDiagnosticsNode(), string);
                    return string;
                }
            }
        }
        catch (SecurityException securityException) {
            logger.warn("SecurityException: ", (Throwable)securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn("IllegalArgumentException: ", (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.warn("IllegalAccessException: ", (Throwable)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.warn("NoSuchMethodException: ", (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.warn("InvocationTargetException: ", (Throwable)invocationTargetException);
        }
        return null;
    }

    private static byte[] a(Long l2) throws StatusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new StatusException("Cannot create long");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private synchronized long aA() {
        return ++this.fb;
    }

    private static void a(ServiceContext serviceContext, Map<Long, ? extends AbstractContinuationPoint> map, int n2) throws StatusException {
        if (n2 == 0) {
            return;
        }
        Iterator<? extends AbstractContinuationPoint> iterator = map.values().iterator();
        try {
            while (map.size() > n2) {
                AbstractContinuationPoint abstractContinuationPoint = iterator.next();
                if (abstractContinuationPoint.getServiceContext().equals(serviceContext)) continue;
                iterator.remove();
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StatusException(StatusCodes.Bad_NoContinuationPoints);
        }
    }

    protected void activate(ServerUserIdentity serverUserIdentity) throws StatusException {
        SessionSecurityDiagnosticsTypeNode sessionSecurityDiagnosticsTypeNode;
        this.fe = serverUserIdentity;
        this.active = true;
        logger.debug("ServerUserIdentity: {}", (Object)serverUserIdentity);
        if (serverUserIdentity != null && (sessionSecurityDiagnosticsTypeNode = this.eZ.getSessionSecurityDiagnosticsNode()) != null) {
            sessionSecurityDiagnosticsTypeNode.setAuthenticationMechanism(serverUserIdentity.getType().name());
            if (serverUserIdentity.getName() != null && serverUserIdentity.getName().length() > 0) {
                String[] stringArray = sessionSecurityDiagnosticsTypeNode.getClientUserIdHistory();
                int n2 = stringArray == null ? 0 : stringArray.length;
                ArrayList<String> arrayList = new ArrayList<String>(n2 + 1);
                if (n2 > 0) {
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                arrayList.add(serverUserIdentity.getName());
                sessionSecurityDiagnosticsTypeNode.setClientUserIdHistory(stringArray);
            }
            sessionSecurityDiagnosticsTypeNode.setClientUserIdOfSession(serverUserIdentity.getName());
        }
        this.ay();
    }

    protected byte[] addBrowseContinuationPoint(BrowseContinuationPoint browseContinuationPoint) throws StatusException {
        Session.a(browseContinuationPoint.getServiceContext(), this.eW, this.getSessionManager().getMaxBrowseContinuationPoints());
        Long l2 = this.aA();
        logger.debug("addContinuationPoint: i={}", (Object)l2);
        this.eW.put(l2, browseContinuationPoint);
        this.az();
        return Session.a(l2);
    }

    protected byte[] addHistoryContinuationPoint(HistoryContinuationPoint historyContinuationPoint) throws StatusException {
        Session.a(historyContinuationPoint.getServiceContext(), this.fa, this.getSessionManager().getMaxHistoryContinuationPoints());
        long l2 = this.aA();
        this.fa.put(l2, historyContinuationPoint);
        this.az();
        return Session.a(l2);
    }

    protected void addSubscription(Subscription subscription) {
        this.bc.add(subscription);
        this.getDiagnostics().getSubscriptionDiagnosticsArrayNode().addSubscription(subscription);
        this.az();
    }

    protected void cancel() {
    }

    protected void close(boolean bl) {
        logger.debug("close");
        try {
            this.eZ.getNodeManager().deleteNode(this.eZ, true, true);
        }
        catch (StatusException statusException) {
            logger.warn("Unexpected error while removing diagnostics node", (Throwable)statusException);
        }
        this.sessionManager = null;
        this.active = false;
        Session session = this;
        for (SessionListener sessionListener : session.listeners) {
            try {
                sessionListener.onSessionClosed(session);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionClosed:", (Throwable)exception);
            }
        }
        this.listeners.clear();
    }

    protected void deactivate() {
        this.active = false;
        this.az();
    }

    protected BrowseContinuationPoint getBrowseContinuationPoint(byte[] byArray) throws StatusException {
        return (BrowseContinuationPoint)this.a(byArray, this.eW);
    }

    protected QualifiedName getDefaultEncoding() {
        return QualifiedName.DEFAULT_BINARY_ENCODING;
    }

    protected HistoryContinuationPoint getHistoryContinuationPoint(byte[] byArray) throws StatusException {
        return (HistoryContinuationPoint)this.a(byArray, this.fa);
    }

    protected byte[] getNewServerNonce(int n2) {
        this.serverNonce = CryptoUtil.createNonce((int)n2);
        this.az();
        return this.serverNonce;
    }

    protected byte[] getServerNonce() {
        return this.serverNonce;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected Queue<Subscription> getTransferredSubscriptions() {
        return this.fd;
    }

    protected void removeSubscription(Subscription subscription) {
        if (this.getDiagnostics() != null && this.getDiagnostics().getSubscriptionDiagnosticsArrayNode() != null) {
            this.getDiagnostics().getSubscriptionDiagnosticsArrayNode().removeSubscription(subscription);
        }
        this.bc.remove(subscription);
    }

    protected void resetDiagnostics() {
        try {
            this.eZ.getSessionDiagnosticsNode().clear();
        }
        catch (Exception exception) {
            logger.warn("Error while reseting Diagnostics", (Throwable)exception);
        }
        this.az();
    }

    protected void setChannel(ServerSecureChannel serverSecureChannel) {
        this.eX = serverSecureChannel;
        if (logger.isDebugEnabled()) {
            logger.debug("setChannel: serverSecureChannel=" + (serverSecureChannel == null ? "null" : ObjectUtils.printFields((Object)serverSecureChannel)));
        }
        if (serverSecureChannel != null) {
            String string = serverSecureChannel.getEndpoint().getEndpointUrl();
            this.eZ.getSessionDiagnosticsNode().setEndpointUrl(string);
            this.eZ.getSessionSecurityDiagnosticsNode().setEncoding("UA Binary");
            this.eZ.getSessionSecurityDiagnosticsNode().setTransportProtocol(UriUtil.getTransportProtocol((String)string).toLowerCase());
            this.eZ.getSessionSecurityDiagnosticsNode().setSecurityMode(serverSecureChannel.getMessageSecurityMode());
            this.eZ.getSessionSecurityDiagnosticsNode().setSecurityPolicyUri(serverSecureChannel.getSecurityPolicy().getPolicyUri());
        }
        this.az();
    }

    protected void setLocaleIds(String[] stringArray) {
        if (stringArray != null) {
            this.locales.clear();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                this.locales.add(LocalizedText.toLocale((String)string));
            }
        }
        this.eZ.getSessionDiagnosticsNode().setLocaleIds(stringArray);
        this.az();
    }

    protected void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.eZ.getSessionDiagnosticsNode().setMaxResponseMessageSize(unsignedInteger);
        this.az();
    }

    protected void setSessionName(String string) {
        this.eZ.getSessionDiagnosticsNode().setSessionName(string);
        this.az();
    }

    protected void setSessionTimeout(double d2) {
        logger.debug("setSessionTimeout: {}", (Object)d2);
        this.sessionTimeout = d2;
        this.eZ.getSessionDiagnosticsNode().setActualSessionTimeout(this.sessionTimeout);
        this.az();
    }

    final void a(ServiceRequest serviceRequest) {
        this.fc = System.currentTimeMillis();
        if (this.eZ.isEnabled()) {
            this.eZ.getSessionDiagnosticsNode().setClientLastContactTime(DateTime.currentTime());
            Object object = serviceRequest.getClass().getName().replace("Request", "Count").replaceAll(".*[.]", "");
            String string = object;
            object = this;
            ((Session)object).a(string, "TotalCount");
            string = "TotalRequestCount";
            object = this;
            ((Session)object).a(string, "TotalCount");
            if (serviceRequest instanceof PublishRequest) {
                this.eZ.getSessionDiagnosticsNode().incCurrentPublishRequestsInQueue();
            }
        }
        this.az();
    }

    final void a(ServiceResponse serviceResponse) {
        if (this.eZ.isEnabled()) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                Object object = serviceResponse.getClass().getName().replace("Response", "Count").replaceAll(".*[.]", "");
                String string = object;
                object = this;
                ((Session)object).a(string, "ErrorCount");
                string = "TotalRequestCount";
                object = this;
                ((Session)object).a(string, "ErrorCount");
                if (statusCode.getValue().equals((Object)StatusCodes.Bad_UserAccessDenied)) {
                    string = "UnauthorizedRequestsCount";
                    object = this;
                    ((Session)object).a(string, "TotalCount");
                }
            }
            if (serviceResponse instanceof PublishResponse) {
                this.eZ.getSessionDiagnosticsNode().decCurrentPublishRequestsInQueue();
            }
            this.az();
        }
    }
}

