/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceManagerBase {
    private static final Logger logger = LoggerFactory.getLogger(ServiceManagerBase.class);
    private final AtomicReference<UaNode> co = new AtomicReference<Object>(null);
    private final UaServer cp;

    public ServiceManagerBase(UaServer uaServer) {
        this.cp = uaServer;
    }

    public UaNode getNode(NodeId object) throws StatusException {
        UaNode uaNode = this.co.get();
        if (uaNode != null && object != null && object.equals((Object)uaNode.getNodeId())) {
            return uaNode;
        }
        object = this.getNodeManagerTable().getNode((NodeId)object);
        if (object != null && !(object instanceof UaExternalNode)) {
            this.co.set((UaNode)object);
        }
        return object;
    }

    public NodeManagerTable getNodeManagerTable() {
        return this.cp.getAddressSpace();
    }

    public UaServer getServer() {
        return this.cp;
    }

    protected boolean arrayDimensionsMatch(Variant variant, Integer unsignedIntegerArray, UnsignedInteger[] unsignedIntegerArray2) {
        if (unsignedIntegerArray == null) {
            return true;
        }
        switch (unsignedIntegerArray.intValue()) {
            case -3: {
                if (variant.isArray()) {
                    return true;
                }
                return variant.getDimension() < 2;
            }
            case -2: {
                return true;
            }
            case -1: {
                return !variant.isArray();
            }
        }
        unsignedIntegerArray = unsignedIntegerArray2;
        if (unsignedIntegerArray2 == null) {
            return true;
        }
        return variant.getDimension() == unsignedIntegerArray.length;
    }

    protected void checkIsMethod(UaNode uaNode) throws StatusException {
        if (!(uaNode == null || uaNode instanceof UaMethod)) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkIsValueNode(UaNode uaNode) throws StatusException {
        if (!this.isValueNode(uaNode)) {
            throw new StatusException("Node " + uaNode.getNodeId() + " is not a Variable or VariableType", StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkIsVariable(UaNode uaNode) throws StatusException {
        if (!this.isVariable(uaNode)) {
            throw new StatusException("Node " + uaNode.getNodeId() + " is not a Variable or VariableType", StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    @Deprecated
    protected void checkIsVariableOrVariableType(UaNode uaNode) throws StatusException {
        this.checkIsValueNode(uaNode);
    }

    protected boolean dataTypeEquals(Variant variant, NodeId nodeId) {
        if (variant.getValue() == null) {
            return this.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().isNullable(nodeId);
        }
        if (Identifiers.BaseDataType.equals((Object)nodeId)) {
            return true;
        }
        UaDataType[] uaDataTypeArray = variant.getValue().getClass();
        if (uaDataTypeArray.equals(byte[].class) && (nodeId.equals((Object)Identifiers.ByteString) || nodeId.equals((Object)Identifiers.Byte))) {
            return true;
        }
        uaDataTypeArray = this.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypesForJavaClass(variant.getCompositeClass());
        try {
            UaDataType uaDataType;
            for (uaDataType = (UaDataType)this.getNode(nodeId); uaDataType != null && uaDataType.getJavaClass() == null; uaDataType = (UaDataType)uaDataType.getSuperType()) {
            }
            for (UaDataType uaDataType2 : uaDataTypeArray) {
                if (uaDataType2.inheritsFrom(nodeId)) {
                    return true;
                }
                if (uaDataType == null || uaDataType.getJavaClass() == null || !uaDataType.getJavaClass().isAssignableFrom(variant.getCompositeClass())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        logger.debug("dataTypeEquals: variant={} dataType={}", (Object)variant, (Object)nodeId);
        return false;
    }

    protected SubscriptionManager getSubscriptionManager() {
        return this.getServer().getSubscriptionManager();
    }

    protected boolean isValueNode(UaNode uaNode) {
        return uaNode == null || uaNode instanceof UaValueNode;
    }

    protected boolean isVariable(UaNode uaNode) {
        return uaNode == null || uaNode instanceof UaVariable;
    }

    protected void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    protected boolean requireUaNode() {
        return false;
    }
}

