/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.Session;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.RequestHeader;

public class ServiceContext {
    public static final ServiceContext INTERNAL_OPERATION_CONTEXT = new ServiceContext(Session.INTERNAL_SESSION, null);
    private RequestHeader kc;
    private Session cf;

    public ServiceContext(Session session, RequestHeader requestHeader) {
        this.cf = session;
        this.kc = requestHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServiceContext)) {
            return false;
        }
        object = (ServiceContext)object;
        if (this.kc == null) {
            return ((ServiceContext)object).kc == null;
        }
        if (((ServiceContext)object).kc == null) {
            return false;
        }
        if (this.kc.getRequestHandle() != null && this.kc.getRequestHandle().getValue() != 0L) {
            return this.kc.getRequestHandle().equals((Object)((ServiceContext)object).kc.getRequestHandle());
        }
        if (this.kc.getRequestHandle() != null && this.kc.getTimestamp() != null) {
            return this.kc.getTimestamp().equals((Object)((ServiceContext)object).kc.getTimestamp());
        }
        return false;
    }

    public String getAuditEntryId() {
        return this.kc.getAuditEntryId();
    }

    public UnsignedInteger getReturnDiagnostics() {
        return this.kc.getReturnDiagnostics();
    }

    public Session getSession() {
        return this.cf;
    }

    public UnsignedInteger getTimeoutHint() {
        return this.kc.getTimeoutHint();
    }

    public DateTime getTimestamp() {
        return this.kc.getTimestamp();
    }

    public int hashCode() {
        int n2 = 31 + (this.kc == null ? 0 : this.kc.hashCode());
        n2 = n2 * 31 + (this.cf == null ? 0 : this.cf.hashCode());
        return n2;
    }

    public boolean isInternal() {
        return this.equals(INTERNAL_OPERATION_CONTEXT);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.getTimestamp().getTimeInMillis() + this.getTimeoutHint().getValue();
    }
}

