/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.server.SessionManager;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.IssuedIdentityToken;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.core.UserNameIdentityToken;
import org.opcfoundation.ua.core.UserTokenType;
import org.opcfoundation.ua.core.X509IdentityToken;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.SecurityPolicy;

public class ServerUserIdentity
extends UserIdentity {
    private final SessionManager sessionManager;
    private final UserIdentityToken fK;

    public ServerUserIdentity(SessionManager object, UserIdentityToken object2, SignatureData signatureData, ApplicationIdentity applicationIdentity, byte[] byArray, SecurityPolicy securityPolicy) throws SecureIdentityException {
        this.sessionManager = object;
        this.fK = object2;
        if (object2 != null) {
            if (object2 instanceof UserNameIdentityToken) {
                object = (UserNameIdentityToken)object2;
                this.name = object.getUserName();
                this.encryptedPassword = object.getPassword();
                if (this.name == null || this.name.isEmpty()) {
                    throw new SecureIdentityException("UserName not defined for UserNameIdentityToken");
                }
                this.decryptPassword((UserIdentityToken)object2, applicationIdentity, byArray, object.getEncryptionAlgorithm());
                this.type = UserTokenType.UserName;
                return;
            }
            if (object2 instanceof IssuedIdentityToken) {
                this.issuedIdentityToken = ((IssuedIdentityToken)object2).getTokenData();
                this.type = UserTokenType.IssuedToken;
                return;
            }
            if (object2 instanceof X509IdentityToken) {
                try {
                    object = (X509IdentityToken)object2;
                    object = object.getCertificateData();
                    object2 = signatureData.getAlgorithm();
                    String string = securityPolicy.getAsymmetricSignatureAlgorithm().getUri();
                    if (object2 != null && !((String)object2).equals(string)) {
                        SessionManager.logger.debug("UserTokenSignature.Algorithm does not match the one defined by the userTokenPolicy: " + (String)object2 + " vs. " + string);
                        boolean bl = false;
                        for (SecurityPolicy securityPolicy2 : SecurityPolicy.getAllSecurityPolicies()) {
                            if (!securityPolicy2.getAsymmetricSignatureAlgorithm().getUri().equals(object2)) continue;
                            securityPolicy = securityPolicy2;
                            bl = true;
                            SessionManager.logger.debug("Found a matching security policy: " + securityPolicy2.getPolicyUri());
                            break;
                        }
                        if (!bl) {
                            SessionManager.logger.warn("Could not find a matching security policy for the signature algorithm " + (String)object2 + " -> Using the Token Policy algorithm " + string);
                        }
                    }
                    SessionManager.a(signatureData, applicationIdentity, byArray, securityPolicy, (byte[])object);
                    this.certificate = new Cert((byte[])object);
                }
                catch (ServiceResultException serviceResultException) {
                    throw new SecureIdentityException("Failed to create certificate", serviceResultException);
                }
                this.type = UserTokenType.Certificate;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public UserIdentityToken getToken() {
        return this.fK;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

