/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.NodeMap;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opcfoundation.ua.builtintypes.NodeId;

public class NodeMapUaNode
extends NodeMap {
    private final Map<NodeId, UaNode> map;

    public NodeMapUaNode(UaNodeFactory uaNodeFactory) {
        super(uaNodeFactory);
        this.map = new ConcurrentSkipListMap<NodeId, UaNode>();
    }

    public NodeMapUaNode(UaNodeFactory uaNodeFactory, Map<NodeId, UaNode> map) {
        super(uaNodeFactory);
        this.map = map;
    }

    @Override
    public UaNode addNode(UaNode uaNode) {
        return this.map.put(uaNode.getNodeId(), uaNode);
    }

    @Override
    public void clear() {
        for (NodeId nodeId : this.map.keySet()) {
            this.remove(nodeId);
        }
    }

    public Map<NodeId, UaNode> getMap() {
        return this.map;
    }

    @Override
    public UaNode getNode(NodeId nodeId) {
        return this.map.get(nodeId);
    }

    @Override
    public boolean hasNode(NodeId nodeId) {
        return this.map.containsKey(nodeId);
    }

    @Override
    public UaNode remove(NodeId nodeId) {
        return this.map.remove(nodeId);
    }
}

