/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.NodeMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.DefaultNodeBuilderConfiguration;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.EventManagerUaNode;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.InvalidTypeNodeException;
import com.prosysopc.ua.server.IoManagerUaNode;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MethodManagerUaNode;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeBuilder;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeMapUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaInstantiationException;
import com.prosysopc.ua.server.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaServerNodeFactory;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AggregateFilterResult;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringParameters;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManagerUaNode
extends NodeManager {
    private static boolean iv = true;
    private static Logger logger = LoggerFactory.getLogger(NodeManagerUaNode.class);
    private UaNodeBuilderConfiguration iw = new DefaultNodeBuilderConfiguration();
    private UaNodeFactory nodeFactory;
    private char ix;
    private String iy;
    private NodeMap iz;

    public NodeManagerUaNode(UaServer object, String object2) {
        super((UaServer)object, (String)object2);
        object = this;
        ((NodeManagerUaNode)object).setNodeIdDelimiter('/');
        ((NodeManager)object).setIoManager(new IoManagerUaNode((NodeManager)object));
        object2 = new MethodManagerUaNode((NodeManager)object);
        ((NodeManager)object).setMethodManager((MethodManager)object2);
        object2 = new EventManagerUaNode((NodeManager)object);
        ((NodeManager)object).setEventManager((EventManager)object2);
        object2 = new HistoryManager((NodeManager)object);
        ((NodeManager)object).setHistoryManager((HistoryManager)object2);
        ((NodeManagerUaNode)object).nodeFactory = new UaServerNodeFactory((NodeManagerUaNode)object);
        ((NodeManagerUaNode)object).iz = ((NodeManagerUaNode)object).createNodeMap();
    }

    public void addComponent(UaNode uaNode, UaInstance uaInstance) throws StatusException {
        this.addNodeAndReference(uaNode, uaInstance, Identifiers.HasComponent);
    }

    @Override
    public UaNode addNode(UaNode uaNode) throws StatusException {
        NodeId nodeId = uaNode.getNodeId();
        if (nodeId == null || nodeId.equals((Object)NodeId.NULL)) {
            throw new StatusException("NodeId==null", StatusCodes.Bad_NodeIdInvalid);
        }
        UaNode uaNode2 = this.getNodeOrExternal(nodeId);
        if (uaNode2 == uaNode) {
            return uaNode2;
        }
        if (iv && uaNode2 != null && !(uaNode2 instanceof UaExternalNode)) {
            throw new StatusException("A different node with the same nodeId (" + nodeId + ") already exists in the nodeManager. Existing node: " + this.getNode(nodeId));
        }
        if (nodeId.getNamespaceIndex() != this.getNamespaceIndex()) {
            throw new StatusException(String.format("NodeId of node %s does not belong to this NodeManager (namespaceIndex %d vs. expected %d)", uaNode.getBrowseName(), nodeId.getNamespaceIndex(), this.getNamespaceIndex()), StatusCodes.Bad_NodeIdRejected);
        }
        if (uaNode2 instanceof UaExternalNode) {
            this.replaceExternalNode((UaExternalNode)uaNode2, uaNode);
        }
        logger.debug("newNode: {}", (Object)nodeId);
        this.iz.addNode(uaNode);
        this.getNodeManagerTable().getNodeManagerRoot().addModelChange(uaNode, ModelChangeType.NodeAdded);
        return uaNode;
    }

    public UaNode addNodeAndReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId) throws StatusException {
        UaNode uaNode3 = this.addNode(uaNode2);
        this.addReference(uaNode, uaNode2, nodeId, false);
        return uaNode3;
    }

    public void addReference(NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl) throws StatusException {
        try {
            this.addReference(nodeId, this.getNamespaceTable().toNodeId(expandedNodeId), nodeId2, bl);
            return;
        }
        catch (ServiceResultException serviceResultException) {
            return;
        }
    }

    public void addReference(NodeId object, NodeId object2, NodeId nodeId, boolean bl) throws StatusException {
        if (nodeId == null) {
            throw new NullPointerException("referenceType");
        }
        object = this.getNodeOrExternal((NodeId)object);
        object2 = this.getNodeOrExternal((NodeId)object2);
        this.addReference((UaNode)object, (UaNode)object2, nodeId, bl);
    }

    public void addReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId, boolean bl) {
        uaNode.addReference(uaNode2, nodeId, bl);
    }

    public <T extends UaType> T addType(ExpandedNodeId expandedNodeId, String string, T t) throws UaNodeFactoryException, StatusException {
        try {
            return this.addType(this.getNamespaceTable().toNodeId(expandedNodeId), string, t);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    public <T extends UaType> T addType(NodeId object, String string, T t) throws StatusException, UaNodeFactoryException {
        object = (UaType)this.nodeFactory.createNode(t.getNodeClass(), (NodeId)object, string, this.getDefaultLocale());
        this.addNodeAndReference(t, (UaNode)object, Identifiers.HasSubtype);
        return (T)object;
    }

    public <T extends BaseEventType> T createEvent(Class<T> object) {
        object = this.createNodeBuilder((Class<T>)object);
        ((NodeBuilder)object).setBrowseName(QualifiedName.NULL);
        ((NodeBuilder)object).setDisplayName(LocalizedText.NULL);
        ((NodeBuilder)object).setNodeId(NodeId.NULL);
        try {
            return (T)((BaseEventType)((NodeBuilder)object).build());
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public <T extends BaseEventType> T createEvent(ExpandedNodeId expandedNodeId) {
        try {
            return this.createEvent(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Creating the node failed", (Exception)((Object)serviceResultException));
        }
    }

    public <T extends BaseEventType> T createEvent(NodeId object) {
        object = this.createNodeBuilder((NodeId)object);
        ((NodeBuilder)object).setBrowseName(QualifiedName.NULL);
        ((NodeBuilder)object).setDisplayName(LocalizedText.NULL);
        ((NodeBuilder)object).setNodeId(NodeId.NULL);
        try {
            return (T)((BaseEventType)((NodeBuilder)object).build());
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public FolderType createFolder(String string, NodeId nodeId) {
        return this.createInstance(FolderTypeNode.class, string, nodeId);
    }

    public <T extends UaInstance> T createInstance(Class<T> object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        object = this.createNodeBuilder((Class<T>)object);
        ((NodeBuilder)object).setBrowseName(qualifiedName);
        ((NodeBuilder)object).setDisplayName(localizedText);
        ((NodeBuilder)object).setNodeId(nodeId);
        try {
            return ((NodeBuilder)object).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public <T extends UaInstance> T createInstance(Class<T> object, String string) {
        object = this.createInstance(this.b((Class<? extends UaInstance>)object), string);
        return (T)object;
    }

    public <T extends UaInstance> T createInstance(Class<T> object, String string, NodeId nodeId) {
        object = this.createInstance(this.b((Class<? extends UaInstance>)object), string, nodeId);
        return (T)object;
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), nodeId, qualifiedName, localizedText);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", (Exception)((Object)serviceResultException));
        }
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, String string) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), string);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", (Exception)((Object)serviceResultException));
        }
    }

    public UaInstance createInstance(ExpandedNodeId expandedNodeId, String string, NodeId nodeId) {
        try {
            return this.createInstance(this.getNamespaceTable().toNodeId(expandedNodeId), string, nodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Cannot instantiate from typeId that points to another server", (Exception)((Object)serviceResultException));
        }
    }

    public UaInstance createInstance(NodeId object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        object = this.createNodeBuilder((NodeId)object);
        ((NodeBuilder)object).setBrowseName(qualifiedName);
        ((NodeBuilder)object).setDisplayName(localizedText);
        ((NodeBuilder)object).setNodeId(nodeId);
        try {
            return ((NodeBuilder)object).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node failed", nodeBuilderException);
        }
    }

    public UaInstance createInstance(NodeId nodeId, String string) {
        try {
            return this.createNodeBuilder(nodeId).setName(string).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node with builder failed", nodeBuilderException);
        }
    }

    public UaInstance createInstance(NodeId nodeId, String string, NodeId nodeId2) {
        try {
            return this.createNodeBuilder(nodeId).setNodeId(nodeId2).setName(string).build();
        }
        catch (NodeBuilderException nodeBuilderException) {
            throw new UaInstantiationException("Creating the node with builder failed", nodeBuilderException);
        }
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(Class<T> clazz) {
        return this.createNodeBuilder(this.b(clazz), this.iw);
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(Class<T> clazz, UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        return this.createNodeBuilder(this.b(clazz), uaNodeBuilderConfiguration);
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(NodeId nodeId) {
        return this.createNodeBuilder(nodeId, this.iw);
    }

    public <T extends UaInstance> NodeBuilder<T> createNodeBuilder(NodeId nodeId, UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        try {
            Object object;
            try {
                object = this.getNodeFactory().getClassType(null, this.getNamespaceTable().toExpandedNodeId(nodeId));
                object = this.b((Class<? extends UaInstance>)object);
                nodeId = object;
            }
            catch (Exception exception) {}
            object = new NodeBuilder(this, uaNodeBuilderConfiguration, this.getType(nodeId));
            ((NodeBuilder)object).setDefaultNameSpaceIndex(this.getNamespaceIndex());
            return object;
        }
        catch (InvalidTypeNodeException invalidTypeNodeException) {
            throw new UaInstantiationException("Invalid type node for instantiation.");
        }
        catch (StatusException statusException) {
            throw new UaInstantiationException("Could not get type node.");
        }
    }

    public NodeId createNodeId(UaNode uaNode, QualifiedName qualifiedName) {
        return this.createNodeId(uaNode, qualifiedName, this.getNamespaceIndex());
    }

    public NodeId createNodeId(UaNode uaNode, QualifiedName object, int n2) {
        String string = this.getNodeIdFormat();
        if (string == null || NodeId.isNull((NodeId)uaNode.getNodeId())) {
            return new NodeId(n2, UUID.randomUUID());
        }
        object = object.getNamespaceIndex() + ":" + object.getName();
        return new NodeId(n2, String.format(string, uaNode.getNodeId().getValue().toString(), object));
    }

    public NodeId createNodeId(UaNode uaNode, String string) {
        return this.createNodeId(uaNode, string, this.getNamespaceIndex());
    }

    public NodeId createNodeId(UaNode uaNode, String string, int n2) {
        return this.createNodeId(uaNode, QualifiedName.parseQualifiedName((String)string), n2);
    }

    public UaNode deleteNode(NodeId object, boolean bl, boolean bl2) throws StatusException {
        object = this.getNode((NodeId)object);
        return this.deleteNode((UaNode)object, bl, bl2);
    }

    public UaNode deleteNode(UaNode uaNode, boolean bl, boolean bl2) throws StatusException {
        return this.deleteNode(uaNode, bl, bl2, false);
    }

    public void deleteReference(NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2) throws StatusException {
        this.deleteReference(this.getNode(nodeId), expandedNodeId, nodeId2);
    }

    public void deleteReference(UaNode uaNode, ExpandedNodeId expandedNodeId, NodeId nodeId) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, uaNode, expandedNodeId, null, nodeId, false, true, null);
    }

    public void deleteReference(UaNode uaNode, UaNode uaNode2, NodeId nodeId) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, uaNode, null, uaNode2, nodeId, false, true, null);
    }

    @Override
    public UaNode findNode(NodeId object) {
        String string;
        int n2;
        UaNode uaNode = this.iz.getNode((NodeId)object);
        if (uaNode == null && object.getIdType().equals((Object)IdType.String) && (n2 = ((String)(object = (String)object.getValue())).lastIndexOf(this.ix)) > 0 && !(string = ((String)object).substring(0, n2)).isEmpty()) {
            Object object2 = new NodeId(this.getNamespaceIndex(), string);
            if ((object2 = this.findNode((NodeId)object2)) == null) {
                object2 = this.findNode(new NodeId(this.getNamespaceIndex(), string));
            }
            if (object2 == null) {
                try {
                    object2 = this.findNode(new NodeId(this.getNamespaceIndex(), Integer.parseInt(string)));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (object2 != null) {
                object = ((String)object).substring(n2 + 1);
                uaNode = object2.getProperty(QualifiedName.parseQualifiedName((String)object));
            }
        }
        return uaNode;
    }

    @Override
    public IoManagerUaNode getIoManager() {
        return (IoManagerUaNode)super.getIoManager();
    }

    public UaNodeBuilderConfiguration getNodeBuilderConfiguration() {
        return this.iw;
    }

    public UaNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public char getNodeIdDelimiter() {
        return this.ix;
    }

    public String getNodeIdFormat() {
        return this.iy;
    }

    public UaNode getNodeOrExternal(NodeId nodeId) {
        UaNode uaNode = null;
        try {
            if (nodeId.getNamespaceIndex() == this.getNamespaceIndex() && (uaNode = this.iz.getNode(nodeId)) == null) {
                uaNode = this.getNodeManagerTable().getExternalNode(nodeId);
            }
            if (uaNode == null) {
                uaNode = this.getNodeManagerTable().getNodeOrExternal(nodeId);
            }
        }
        catch (StatusException statusException) {
            return null;
        }
        return uaNode;
    }

    public NodeMap getNodes() {
        return this.iz;
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    @Override
    public NodeId getVariableDataType(NodeId nodeId, UaValueNode uaValueNode) throws StatusException {
        if (uaValueNode == null) {
            return NodeId.NULL;
        }
        return uaValueNode.getDataTypeId();
    }

    @Override
    public boolean hasNode(NodeId nodeId) {
        return this.findNode(nodeId) != null;
    }

    public void setNodeBuilderConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.iw = uaNodeBuilderConfiguration;
    }

    public void setNodeFactory(UaNodeFactory uaNodeFactory) {
        this.nodeFactory = uaNodeFactory;
    }

    public void setNodeIdDelimiter(char c2) {
        this.ix = c2;
        this.iy = "%s" + c2 + "%s";
    }

    @Override
    public boolean supportsUaNode() {
        return true;
    }

    private void a(ServiceContext serviceContext, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId, boolean bl, Boolean bl2, UaReferenceType uaReferenceType) throws StatusException {
        if (uaNode2 == null && !ExpandedNodeId.isNull((ExpandedNodeId)expandedNodeId) && expandedNodeId.isLocal()) {
            uaNode2 = this.getNode(expandedNodeId, StatusCodes.Bad_TargetNodeIdInvalid);
        }
        if (!serviceContext.isInternal()) {
            this.fireDeleteReference(serviceContext, uaNode.getNodeId(), uaNode, expandedNodeId, uaNode2, nodeId, uaReferenceType, bl, bl2);
        }
        if (uaNode2 == null) {
            uaNode.deleteReference(expandedNodeId, nodeId, bl);
            return;
        }
        uaNode.deleteReference(uaNode2, nodeId, bl);
        if (bl2.booleanValue()) {
            uaNode2.deleteReference(uaNode, nodeId, !bl);
        }
    }

    private NodeId b(Class<? extends UaInstance> clazz) {
        try {
            return this.getNamespaceTable().toNodeId(AnnotationUtils.readTypeDefinitionId(clazz));
        }
        catch (ServiceResultException serviceResultException) {
            throw new UaInstantiationException("Could not read type definition node identifier (expecting Annotation TypeDefinitionId) from the class " + clazz, (Exception)((Object)serviceResultException));
        }
        catch (AnnotationException annotationException) {
            throw new UaInstantiationException("Could not read type definition node identifier (expecting Annotation TypeDefinitionId) from the class " + clazz, annotationException);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected NodeId addNode(ServiceContext var1_1, NodeId var2_3, NodeId var3_4, QualifiedName var4_5, NodeClass var5_6, ExpandedNodeId var6_7, NodeAttributes var7_8, NodeId var8_9) throws StatusException {
        if (NodeManagerUaNode.logger.isDebugEnabled()) {
            NodeManagerUaNode.logger.debug("addNode: (this={}) nodeId={}; parentNodeId={}; browseName={}; referenceTypeId={}", new Object[]{this, var2_3, var3_4, var4_5, var8_9});
        }
        var10_10 = var3_4.isNullNodeId() != false ? null : (var1_1.isInternal() == false ? this.getNode(var3_4, StatusCodes.Bad_ParentNodeIdInvalid) : this.getNodeOrExternal(var3_4));
        if (!var1_1.isInternal() && this.hasNode(var2_3)) {
            throw new StatusException(StatusCodes.Bad_NodeIdExists);
        }
        var11_11 = var7_8.getDisplayName();
        if (var11_11 == null || var11_11.getText() == "" || var11_11.getText() == null) {
            var11_11 = new LocalizedText(var4_5.toString(), Locale.ENGLISH);
        }
        var12_12 = null;
        if (!(ExpandedNodeId.isNull((ExpandedNodeId)var6_7) || var5_6.equals((Object)NodeClass.Object) || var5_6.equals((Object)NodeClass.Variable) || var5_6.equals((Object)NodeClass.Method))) {
            throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid);
        }
        if (ExpandedNodeId.isNull((ExpandedNodeId)var6_7) || !var6_7.isLocal()) {
            var12_12 = null;
        } else if (!var1_1.isInternal()) {
            try {
                var12_12 = this.findNode(var6_7);
                if (var12_12 != null || !this.getNamespaceTable().toNodeId(var6_7).equals((Object)var2_3)) ** GOTO lbl28
                var12_12 = null;
            }
            catch (ServiceResultException var13_13) {
                throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid, (Throwable)var13_13);
            }
        } else {
            try {
                var12_12 = this.getNodeOrExternal(this.getNamespaceTable().toNodeId(var6_7));
            }
            catch (ServiceResultException var13_14) {
                throw new StatusException(StatusCodes.Bad_TypeDefinitionInvalid, (Throwable)var13_14);
            }
        }
lbl28:
        // 4 sources

        var13_15 = this.getNamespaceIndex() < 2 || NodeId.isNull((NodeId)var8_9) != false ? null : this.getReferenceType(var8_9);
        var9_16 = this.findNode(var2_3);
        if (var9_16 == null || var1_1.isInternal()) {
            try {
                var9_16 = this.createNodeForAddNode(var2_3, var4_5, var5_6, var6_7, var11_11);
                var9_16.setAttributes(var7_8);
                if (!var1_1.isInternal()) {
                    this.fireAddNode(var1_1, var3_4, var10_10, var2_3, var9_16, var5_6, var4_5, var7_8, var13_15, var6_7, var12_12);
                }
                if (var10_10 != null) {
                    var10_10.addReference(var9_16, var8_9, false);
                }
                this.addNode(var9_16);
                return var9_16.getNodeId();
            }
            catch (UaNodeFactoryException var1_2) {
                NodeManagerUaNode.logger.error("UaNodeFactoryException: ", (Throwable)var1_2);
                throw new StatusException(StatusCodes.Bad_InternalError, (Throwable)var1_2);
            }
        }
        throw new StatusException(StatusCodes.Bad_NodeIdExists);
    }

    @Override
    protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass object, String string) throws StatusException {
        object = this.getNode(nodeId, StatusCodes.Bad_SourceNodeIdInvalid);
        UaNode uaNode = ExpandedNodeId.isNull((ExpandedNodeId)expandedNodeId) || !expandedNodeId.isLocal() ? null : this.getNode(expandedNodeId, StatusCodes.Bad_TargetNodeIdInvalid);
        UaReferenceType uaReferenceType = this.getReferenceType(nodeId2);
        this.fireAddReference(serviceContext, nodeId, (UaNode)object, expandedNodeId, uaNode, nodeId2, uaReferenceType, bl, uaNode, string);
        this.addReference((UaNode)object, uaNode, nodeId2, !bl);
    }

    @Override
    protected void close() {
        super.close();
        this.iz.clear();
    }

    @Override
    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode instanceof UaExternalNode) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        if (!uaNode.supportsAttribute(unsignedInteger)) {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
        logger.debug("createMonitoredDataItem: node{}", (Object)uaNode);
        this.fireCreateMonitoredDataItem(serviceContext, subscription, nodeId, uaNode, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected UaNode createNodeForAddNode(NodeId nodeId, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, LocalizedText localizedText) {
        return this.nodeFactory.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    protected NodeMap createNodeMap() {
        return new NodeMapUaNode(this.nodeFactory);
    }

    @Override
    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        this.fireDeleteNode(serviceContext, nodeId, uaNode, bl);
        this.deleteNode(uaNode, (boolean)bl, false);
    }

    protected UaNode deleteNode(UaNode objectArray, boolean n2, boolean bl, boolean bl2) throws StatusException {
        NodeManager nodeManager;
        UaNode uaNode;
        UaReference[] uaReferenceArray;
        if (objectArray == null) {
            return null;
        }
        if (bl2 && (uaReferenceArray = objectArray.getReferences(Identifiers.HasChild, true)) != null && uaReferenceArray.length > 1) {
            return null;
        }
        if (this.iz.hasNode(objectArray.getNodeId())) {
            this.getNodeManagerTable().getNodeManagerRoot().addModelChange((UaNode)objectArray, ModelChangeType.NodeDeleted);
        }
        if (bl) {
            Object[] object = objectArray;
            NodeManagerUaNode nodeManagerUaNode = this;
            Object[] objectArray2 = object.getReferences(Identifiers.HasChild, false);
            if (objectArray2 == null) {
                logger.error("deleteChildNodes: references={}", (Object)Arrays.toString(objectArray2));
            }
            Object[] objectArray3 = objectArray2;
            int n3 = objectArray2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = objectArray3[i2];
                nodeManagerUaNode.deleteNode(((UaReference)object2).getTargetNode(), false, true, true);
            }
        }
        if ((uaNode = this.iz.remove((UaNode)objectArray)) == null && objectArray.getNodeId().getNamespaceIndex() != this.getNamespaceIndex() && (nodeManager = this.getNodeManagerTable().getNodeManager(objectArray.getNodeId())) instanceof NodeManagerUaNode) {
            ((NodeManagerUaNode)nodeManager).deleteNode((UaNode)objectArray, n2 != 0, bl);
        }
        for (UaReference uaReference : objectArray.getReferences()) {
            uaReference.delete();
        }
        return uaNode;
    }

    @Override
    protected void deleteReference(ServiceContext serviceContext, NodeId object, ExpandedNodeId expandedNodeId, NodeId nodeId, Boolean bl, Boolean bl2) throws StatusException {
        object = this.getNode((NodeId)object, StatusCodes.Bad_SourceNodeIdInvalid);
        UaReferenceType uaReferenceType = this.getReferenceType(nodeId);
        this.a(serviceContext, (UaNode)object, expandedNodeId, null, nodeId, bl == false, bl2, uaReferenceType);
    }

    @Override
    protected QualifiedName getBrowseName(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode == null || uaNode instanceof UaExternalNode) {
            try {
                uaNode = this.findNode(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {}
            if (uaNode == null) {
                return QualifiedName.NULL;
            }
        }
        return uaNode.getBrowseName();
    }

    @Override
    protected LocalizedText getDisplayName(ExpandedNodeId expandedNodeId, UaNode uaNode, Locale locale) {
        if (uaNode == null || uaNode instanceof UaExternalNode) {
            return null;
        }
        return uaNode.getDisplayName();
    }

    protected UaNode getNode(ExpandedNodeId object, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return this.getNode((ExpandedNodeId)object);
        }
        catch (StatusException statusException) {
            object = statusException;
            if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_NodeIdInvalid)) {
                throw object;
            }
            throw new StatusException(((Throwable)object).getMessage(), unsignedInteger);
        }
    }

    protected UaNode getNode(NodeId object, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return this.getNode((NodeId)object);
        }
        catch (StatusException statusException) {
            object = statusException;
            if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_NodeIdInvalid)) {
                throw object;
            }
            throw new StatusException(((Throwable)object).getMessage(), unsignedInteger);
        }
    }

    @Override
    protected NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        if (uaNode == null) {
            try {
                uaNode = this.getNode(nodeId);
            }
            catch (StatusException statusException) {}
        }
        if (uaNode == null) {
            return NodeClass.Unspecified;
        }
        return uaNode.getNodeClass();
    }

    @Override
    protected UaReference[] getReferences(NodeId nodeId, UaNode uaNode) {
        if (uaNode == null) {
            return null;
        }
        return uaNode.getReferences();
    }

    @Override
    protected ExpandedNodeId getTypeDefinition(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode instanceof UaInstance) {
            return ((UaInstance)uaNode).getTypeDefinitionId();
        }
        return null;
    }

    protected void replaceExternalNode(UaExternalNode uaExternalNode, UaNode uaNode) throws StatusException {
        for (UaReference uaReference : uaExternalNode.getReferences()) {
            UaNode uaNode2 = uaReference.getSourceNode();
            UaNode uaNode3 = uaReference.getTargetNode();
            NodeId nodeId = uaReference.getReferenceTypeId();
            if (uaNode2 == uaExternalNode) {
                uaNode2 = uaNode;
                uaNode3.deleteReference(uaReference);
            } else if (uaNode3 == uaExternalNode) {
                uaNode3 = uaNode;
                uaNode2.deleteReference(uaReference);
            } else {
                logger.error("Unexpected error copying reference from ExternalNode, reference skipped");
                continue;
            }
            uaNode2.addReference(uaNode3, nodeId, false);
        }
        this.getNodeManagerTable().getExternalNodeManager().removeNode(uaExternalNode);
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }
}

